/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.jena;

import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.contrib.ssl.EasySSLProtocolSocketFactory;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.datatools.User;
import org.eaglei.datatools.Workspace;
import org.eaglei.datatools.config.DatatoolsConfiguration;
import org.eaglei.datatools.jena.EIInstanceFactory;
import org.eaglei.datatools.jena.SPARQLQueryUtil;
import org.eaglei.datatools.provider.EIDataToolsProviderException;
import org.eaglei.datatools.provider.RepositoryProvider;
import org.eaglei.datatools.provider.RepositoryProviderMessages;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIInstanceMinimal;
import org.eaglei.model.EIURI;
import org.eaglei.security.Session;

public final class RESTRepositoryProvider
implements RepositoryProvider {
    protected static final String READ_VIEW = "user";
    private static final String FORMAT_VALUE = "application/xml";
    private static final String RDF_FORMAT = "RDF/XML";
    private static final Log log = LogFactory.getLog(RESTRepositoryProvider.class);
    private static final boolean isDebugEnabled = log.isDebugEnabled();
    private static String DEFAULT_REPOSITORY = "";
    private static String DEFAULT_NAMESPACE = "";
    private static boolean ACCEPT_SELF_SIGNED_CERTS = false;
    private static HostConfiguration hostConfiguration;
    private static String WITDRAWN_WORKSPACE_URI;
    private static String SANDBOX_WORKSPACE_URI;
    private final Map<String, HttpClient> clientMap = new HashMap<String, HttpClient>();

    public RESTRepositoryProvider(DatatoolsConfiguration config) throws IOException {
        if (config != null) {
            DEFAULT_REPOSITORY = config.getDatatoolsRepositoryURL();
            DEFAULT_NAMESPACE = config.getDatatoolsRepositoryNamespace();
            ACCEPT_SELF_SIGNED_CERTS = config.getDatatoolsAcceptSelfSignedCerts();
        }
        if (ACCEPT_SELF_SIGNED_CERTS) {
            Protocol easyhttps = new Protocol("https", (SecureProtocolSocketFactory)new EasySSLProtocolSocketFactory(), 8443);
            URI uri = new URI(DEFAULT_REPOSITORY, true);
            hostConfiguration = new HostConfiguration();
            hostConfiguration.setHost(uri.getHost(), uri.getPort(), easyhttps);
        }
    }

    private HttpClient makeHttpClient(String username, String password) {
        HttpClient client = new HttpClient();
        client.setHttpConnectionManager((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
        client.getState().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
        client.getParams().setAuthenticationPreemptive(true);
        return client;
    }

    private int executeMethod(HttpClient client, HttpMethod method) throws HttpException, IOException {
        if (ACCEPT_SELF_SIGNED_CERTS) {
            return client.executeMethod(hostConfiguration, method);
        }
        return client.executeMethod(method);
    }

    private HttpClient getHttpClient(Session session) {
        if (!Session.isValid((Session)session)) {
            return null;
        }
        if (this.clientMap.get(session.getSessionId()) == null) {
            return null;
        }
        return this.clientMap.get(session.getSessionId());
    }

    protected void setWriteParameters(PostMethod method, String id) {
        method.setParameter("uri", id);
        method.setParameter("format", FORMAT_VALUE);
        method.setRequestHeader("charset", "UTF-8");
    }

    protected void setReadParameters(PostMethod method) {
        method.setParameter("format", FORMAT_VALUE);
        method.setParameter("view", READ_VIEW);
        method.setParameter("noinferred", "true");
        method.setRequestHeader("charset", "UTF-8");
    }

    @Override
    public void createInstance(Session session, EIInstance instance, EIEntity workspaceEntity) throws Exception {
        if (!Session.isValid((Session)session)) {
            log.error((Object)"Invalid Session - request cannot be completed");
            throw new EIDataToolsProviderException("No session information was found.");
        }
        if (instance == null || instance.getInstanceURI() == null) {
            log.warn((Object)"Trying to create (duplicate) instance with null instance or null instance URI");
            return;
        }
        String instanceUri = instance.getInstanceURI().toString();
        String instanceAsString = EIInstanceFactory.INSTANCE.serialize(instance, RDF_FORMAT);
        this.createInstance(session, instanceAsString, instanceUri, workspaceEntity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createInstance(Session session, String rdfString, String instanceUri, EIEntity workspaceEntity) throws Exception {
        block10: {
            if (!Session.isValid((Session)session)) {
                log.error((Object)"Invalid Session - request cannot be completed");
                throw new EIDataToolsProviderException("No session information was found.");
            }
            if (rdfString == null) {
                log.warn((Object)"Trying to create (duplicate) instance with null instance or null instance URI");
                return;
            }
            int status = 0;
            PostMethod method = new PostMethod(RestCommands.UpdateInstance.getURL());
            this.setWriteParameters(method, instanceUri);
            if (workspaceEntity != null && !workspaceEntity.equals((Object)EIEntity.NULL_ENTITY)) {
                log.info((Object)("creating instance in workspace " + workspaceEntity.getURI().toString()));
                method.setParameter("workspace", workspaceEntity.getURI().toString());
            } else {
                log.info((Object)"creating instance in default workspace");
                method.setParameter("workspace", DEFAULT_WORKSPACE_ENTITY.getURI().toString());
            }
            method.setParameter("action", "create");
            if (isDebugEnabled) {
                log.debug((Object)("dump data: " + rdfString));
            }
            method.setParameter("insert", rdfString);
            if (isDebugEnabled) {
                log.debug((Object)("Trying to get create instance at " + instanceUri));
            }
            try {
                HttpClient client = this.getHttpClient(session);
                status = this.executeMethod(client, (HttpMethod)method);
                String resp = this.getStringFromInputStream(method.getResponseBodyAsStream());
                if (status == 200 || status == 201) {
                    log.info((Object)("get instance succeded with status: " + status + " response: " + resp));
                    break block10;
                }
                log.error((Object)("create instance failed with status: " + status + " response: " + resp));
                throw new EIDataToolsProviderException(RepositoryProviderMessages.getFailedMessage("create", status));
            }
            finally {
                method.releaseConnection();
            }
        }
    }

    @Override
    public EIInstance deepCopy(Session session, EIURI originalUri) throws Exception {
        if (!Session.isValid((Session)session)) {
            log.error((Object)"Invalid Session - request cannot be completed");
            throw new EIDataToolsProviderException("No session information was found.");
        }
        EIInstance original = this.getInstance(session, originalUri);
        if (isDebugEnabled) {
            log.debug((Object)"got original instance");
        }
        return this.duplicateInstance(session, original);
    }

    public EIInstance duplicateInstance(Session session, EIInstance original) throws Exception {
        EIInstance duplicate = this.getEmptyEIInstance(session, original.getInstanceType().getURI());
        for (EIEntity property : original.getDatatypeProperties().keySet()) {
            for (String value : original.getDatatypeProperty(property)) {
                duplicate.addDatattypeProperty(property, value);
            }
        }
        for (EIEntity property : original.getObjectProperties().keySet()) {
            for (String value : original.getObjectProperty(property)) {
                duplicate.addObjectProperty(property, (EIEntity)value);
            }
        }
        for (EIEntity property : original.getNonOntologyLiteralProperties().keySet()) {
            for (String value : original.getNonOntologyLiteralProperty(property)) {
                duplicate.addNonOntologyLiteralProperty(property, value);
            }
        }
        for (EIEntity property : original.getNonOntologyResourceProperties().keySet()) {
            for (String value : original.getNonOntologyResourceProperty(property)) {
                duplicate.addNonOntologyResourceProperty(property, (EIEntity)value);
            }
        }
        if (isDebugEnabled) {
            log.debug((Object)"finished making new copy");
        }
        return duplicate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteInstance(Session session, EIURI instanceUri) throws Exception {
        block7: {
            if (!Session.isValid((Session)session)) {
                log.error((Object)"Invalid Session - request cannot be completed");
                throw new EIDataToolsProviderException("No session information was found.");
            }
            if (instanceUri == null || instanceUri.toString() == null || instanceUri.toString().length() == 0) {
                return;
            }
            String token = this.getToken(session, instanceUri.toString());
            int status = 0;
            PostMethod method = new PostMethod(RestCommands.UpdateInstance.getURL());
            this.setWriteParameters(method, instanceUri.toString());
            method.setParameter("action", "update");
            method.setParameter("token", token);
            method.setParameter("delete", this.createDeleteStatement(instanceUri));
            if (isDebugEnabled) {
                log.debug((Object)("Trying to get delete instance at " + instanceUri.toString()));
            }
            try {
                HttpClient client = this.getHttpClient(session);
                status = this.executeMethod(client, (HttpMethod)method);
                String resp = this.getStringFromInputStream(method.getResponseBodyAsStream());
                if (status == 200) {
                    log.info((Object)("delete instance succeded with status: " + status + " response: " + resp));
                    break block7;
                }
                log.error((Object)("delete instance failed with status: " + status + " response: " + resp));
                throw new EIDataToolsProviderException(RepositoryProviderMessages.getFailedMessage("delete", status));
            }
            finally {
                method.releaseConnection();
            }
        }
    }

    @Override
    public String updateInstance(Session session, EIInstance instance, String token) throws Exception {
        if (!Session.isValid((Session)session)) {
            log.error((Object)"Invalid Session - request cannot be completed");
            throw new EIDataToolsProviderException("No session information was found.");
        }
        if (instance == null || instance.getInstanceURI() == null || instance.getInstanceURI().toString() == null || instance.getInstanceURI().toString().length() == 0) {
            log.warn((Object)"Trying to update instance with null instance or null instance URI");
            return null;
        }
        instance.setReadOnlyLiteralProperties(new HashMap());
        String instanceAsString = EIInstanceFactory.INSTANCE.serialize(instance, RDF_FORMAT);
        String instanceUri = instance.getInstanceURI().toString();
        return this.updateInstance(session, instanceAsString, instanceUri, token);
    }

    public String updateInstance(Session session, String rdfString, String instanceUri, String token) throws Exception {
        if (!Session.isValid((Session)session)) {
            log.error((Object)"Invalid Session - request cannot be completed");
            throw new EIDataToolsProviderException("No session information was found.");
        }
        if (rdfString == null || rdfString.length() == 0) {
            log.warn((Object)"Trying to create (duplicate) instance with null instance or null instance URI");
            return null;
        }
        if (token == null) {
            return this.updateAndGetToken(session, rdfString, instanceUri);
        }
        int status = 0;
        PostMethod method = new PostMethod(RestCommands.UpdateInstance.getURL());
        this.setWriteParameters(method, instanceUri);
        method.setParameter("insert", rdfString);
        method.setParameter("delete", this.createDeleteStatement(instanceUri));
        if (isDebugEnabled) {
            log.debug((Object)("Trying to get update instance at " + instanceUri));
        }
        method.setParameter("action", "update");
        method.setParameter("token", token);
        try {
            HttpClient client = this.getHttpClient(session);
            status = this.executeMethod(client, (HttpMethod)method);
            String resp = this.getStringFromInputStream(method.getResponseBodyAsStream());
            if (status == 200) {
                log.info((Object)("update succeded with status: " + status + " response size: " + resp.length()));
                String string = resp;
                return string;
            }
            if (status == 409) {
                log.error((Object)("Stale token. Update instance failed with status: " + status + " response: " + resp));
                throw new EIDataToolsProviderException("This resource is being edited or has recently changed. Is it open in another window? Cancel and try editing again.");
            }
            log.error((Object)("update instance failed with status: " + status + " response: " + resp));
            throw new EIDataToolsProviderException(RepositoryProviderMessages.getFailedMessage("update", status));
        }
        finally {
            method.releaseConnection();
        }
    }

    private String createDeleteStatement(EIURI instanceUri) {
        return this.createDeleteStatement(instanceUri.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createDeleteStatement(String instanceUri) {
        String s = null;
        String wildcard = "<" + instanceUri + "> <http://eagle-i.org/ont/repo/1.0/MatchAnything> <http://eagle-i.org/ont/repo/1.0/MatchAnything> .";
        log.info((Object)"Trying to create a wildcard graph to delete all the statements");
        Model m = ModelFactory.createDefaultModel();
        StringReader st = new StringReader(wildcard);
        m.read((Reader)st, null, "N-TRIPLE");
        StringWriter sw = new StringWriter();
        try {
            m.write((Writer)sw, RDF_FORMAT);
            s = sw.toString();
            sw.flush();
        }
        finally {
            try {
                if (sw != null) {
                    sw.close();
                }
            }
            catch (IOException e) {
                log.warn((Object)("createDelete statement: " + e));
            }
        }
        return s;
    }

    protected String updateAndGetToken(Session session, EIInstance instance) throws Exception {
        String instanceUri = instance.getInstanceURI().toString();
        String instanceAsString = EIInstanceFactory.INSTANCE.serialize(instance, RDF_FORMAT);
        return this.updateAndGetToken(session, instanceAsString, instanceUri);
    }

    protected String getToken(Session session, String instanceUri) throws Exception {
        return this.updateAndGetToken(session, null, instanceUri);
    }

    protected String updateAndGetToken(Session session, String rdfString, String instanceUri) throws Exception {
        if (!Session.isValid((Session)session)) {
            log.error((Object)"Invalid Session - request cannot be completed");
            throw new EIDataToolsProviderException("No session information was found.");
        }
        PostMethod method = new PostMethod(RestCommands.UpdateInstance.getURL());
        this.setWriteParameters(method, instanceUri);
        if (rdfString != null && rdfString.length() > 0) {
            method.setParameter("insert", rdfString);
        }
        method.setParameter("action", "gettoken");
        int status = 0;
        try {
            HttpClient client = this.getHttpClient(session);
            status = this.executeMethod(client, (HttpMethod)method);
            String resp = this.getStringFromInputStream(method.getResponseBodyAsStream());
            if (status == 200) {
                String string = this.parseResponseToken(resp);
                return string;
            }
            log.error((Object)("get token failed with status: " + status + " response: " + resp));
            throw new EIDataToolsProviderException(RepositoryProviderMessages.getFailedMessage("get token", status));
        }
        finally {
            method.releaseConnection();
        }
    }

    private String parseResponseToken(String resp) {
        ResultSet results = ResultSetFactory.fromXML((String)resp);
        QuerySolution soln = results.nextSolution();
        Resource r = soln.getResource("token");
        String tokenid = r.getURI();
        log.info((Object)("Retrieved new token " + tokenid));
        return tokenid;
    }

    @Override
    public EIInstance getInstance(Session session, EIURI instanceID) throws Exception {
        if (!Session.isValid((Session)session)) {
            log.error((Object)"Invalid Session - request cannot be completed");
            throw new EIDataToolsProviderException("No session information was found.");
        }
        if (instanceID == null || instanceID.toString() == null) {
            log.warn((Object)"Trying to get instance for null EIURI");
            return null;
        }
        int status = 0;
        PostMethod method = new PostMethod(RestCommands.GetInstance.getURL());
        this.setReadParameters(method);
        method.setParameter("uri", instanceID.toString());
        HttpClient client = this.getHttpClient(session);
        if (isDebugEnabled) {
            log.debug((Object)("Trying to get instance " + instanceID.toString()));
        }
        try {
            status = this.executeMethod(client, (HttpMethod)method);
            if (status == 200) {
                if (isDebugEnabled) {
                    log.debug((Object)"started with an OK status");
                }
                if (isDebugEnabled) {
                    log.debug((Object)"reading in input stream as a model");
                }
                String response = this.getStringFromInputStream(method.getResponseBodyAsStream());
                EIInstance instance = EIInstanceFactory.INSTANCE.create(instanceID, response, RDF_FORMAT);
                if (isDebugEnabled) {
                    log.debug((Object)("got instance contents: " + instance));
                }
                EIInstance eIInstance = instance;
                return eIInstance;
            }
            log.error((Object)("get instance " + instanceID + " failed with status: " + status));
            throw new EIDataToolsProviderException(RepositoryProviderMessages.getFailedMessage("get instance", status));
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<EIURI> getNewInstanceID(Session session, int count) throws Exception {
        ArrayList<EIURI> instances;
        ResultSet results;
        block7: {
            if (!Session.isValid((Session)session)) {
                throw new EIDataToolsProviderException("No session information was found.");
            }
            int status = 0;
            results = null;
            PostMethod method = new PostMethod(RestCommands.GetNewInstanceIDs.getURL());
            instances = new ArrayList<EIURI>(count);
            log.info((Object)("getting " + count + " instance IDs"));
            try {
                method.setParameter("accept", "application/sparql-results+xml");
                method.setParameter("count", Integer.toString(count));
                HttpClient client = this.getHttpClient(session);
                status = this.executeMethod(client, (HttpMethod)method);
                String response = this.getStringFromInputStream(method.getResponseBodyAsStream());
                if (status == 200) {
                    results = ResultSetFactory.fromXML((String)response);
                    break block7;
                }
                log.error((Object)("Error getting instance IDs; HTTP Status: " + status + " Response: " + response));
                throw new EIDataToolsProviderException(RepositoryProviderMessages.getFailedMessage("get new ID", status));
            }
            finally {
                method.releaseConnection();
            }
        }
        while (results.hasNext()) {
            QuerySolution soln = results.nextSolution();
            Resource r = soln.getResource("new");
            String id = r.getURI();
            instances.add(EIURI.create((String)id));
            log.info((Object)("Created new instance id: " + id));
        }
        if (isDebugEnabled) {
            log.debug((Object)("Created " + instances.size() + " ids"));
        }
        return instances;
    }

    protected User getUserInformation(Session session, HttpClient client) throws Exception {
        String sessionId;
        int status = 0;
        String responseBody = null;
        ResultSet results = null;
        GetMethod method = new GetMethod(RestCommands.WhoAmI.getURL());
        try {
            if (client == null) {
                log.error((Object)"http Client is null");
            }
            status = this.executeMethod(client, (HttpMethod)method);
            responseBody = this.getStringFromInputStream(method.getResponseBodyAsStream());
        }
        catch (Exception e) {
            log.error((Object)("problem getting user info " + RestCommands.WhoAmI.getURL() + " Message from repo: " + responseBody));
            throw new EIDataToolsProviderException("Could not authenticate user. Re-enter username and/or password.");
        }
        finally {
            method.releaseConnection();
        }
        this.checkStatus(status);
        if (responseBody == null) {
            throw new EIDataToolsProviderException("Could not authenticate user. Re-enter username and/or password.");
        }
        results = ResultSetFactory.fromXML((String)responseBody);
        if (results == null) {
            throw new EIDataToolsProviderException("Could not authenticate user. Re-enter username and/or password.");
        }
        QuerySolution soln = results.nextSolution();
        Literal username = soln.getLiteral("username");
        Resource userURI = soln.getResource("uri");
        if (username == null || userURI == null) {
            throw new EIDataToolsProviderException("Could not authenticate user. Re-enter username and/or password.");
        }
        log.info((Object)("Authenticated user: " + username.getString() + " " + userURI.getURI()));
        if (!Session.isValid((Session)session)) {
            sessionId = UUID.randomUUID().toString();
            this.clientMap.put(sessionId, client);
        } else {
            sessionId = session.getSessionId();
        }
        log.info((Object)("session ID: " + sessionId + "; new session? " + (Session.isValid((Session)session) ? "yes" : "no")));
        Session newSession = new Session(sessionId, "", username.getString(), userURI.getURI());
        List<EIURI> states = this.getWFStatesList(newSession);
        log.info((Object)("has number of wfsStates " + states.size()));
        List<Workspace> workspaceList = this.getWorkspaces(newSession);
        log.info((Object)("has number of workspaces " + workspaceList.size()));
        User user = new User(username.getString(), EIURI.create((String)userURI.getURI()), states, workspaceList, newSession);
        return user;
    }

    private void checkStatus(int status) throws EIDataToolsProviderException {
        if (status != 200) {
            if (status == 404) {
                log.error((Object)"Repo unavailable");
                throw new EIDataToolsProviderException("The repository is currently unavailable.");
            }
            if (status == 401) {
                log.error((Object)"not authorized to get user information (login/whoami)");
                throw new EIDataToolsProviderException("Could not authenticate user. Re-enter username and/or password.");
            }
            throw new EIDataToolsProviderException("Could not authenticate user. Re-enter username and/or password.");
        }
    }

    @Override
    public List<Workspace> getWorkspaces(Session session) throws Exception {
        if (!Session.isValid((Session)session)) {
            log.error((Object)"Invalid Session - request cannot be completed");
            throw new EIDataToolsProviderException("No session information was found.");
        }
        GetMethod method = new GetMethod(RestCommands.Listgraphs.getURL());
        NameValuePair pair1 = new NameValuePair("format", FORMAT_VALUE);
        NameValuePair pair2 = new NameValuePair("type", "workspace");
        method.setQueryString(new NameValuePair[]{pair1, pair2});
        try {
            ArrayList<Workspace> workspaceList = new ArrayList<Workspace>();
            HttpClient client = this.getHttpClient(session);
            log.info((Object)("executing " + RestCommands.Listgraphs.getURL() + " api call"));
            int status = this.executeMethod(client, (HttpMethod)method);
            this.checkStatus(status);
            String responseBody = this.getStringFromInputStream(method.getResponseBodyAsStream());
            log.info((Object)(RestCommands.Listgraphs.getURL() + " api call has returned ,parsing the results"));
            ResultSet resultSet = ResultSetFactory.fromXML((String)responseBody);
            while (resultSet.hasNext()) {
                QuerySolution solution = resultSet.next();
                String workspaceName = solution.getLiteral("namedGraphLabel").getString();
                String workspaceURI = solution.getResource("namedGraphURI").getURI();
                if (workspaceURI.equals(WITDRAWN_WORKSPACE_URI) || workspaceURI.equals(SANDBOX_WORKSPACE_URI)) continue;
                String typeURI = solution.getResource("typeURI").getURI();
                boolean canUserAdd = solution.getLiteral("add").getBoolean();
                Workspace workspace = new Workspace(workspaceName, EIURI.create((String)workspaceURI), EIURI.create((String)typeURI), canUserAdd);
                workspaceList.add(workspace);
            }
            ArrayList<Workspace> arrayList = workspaceList;
            return arrayList;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            log.error((Object)("problem getting workspaces " + RestCommands.Listgraphs.getURL() + " Message from repo: " + this.getStringFromInputStream(method.getResponseBodyAsStream()) + "; Exception " + e));
            throw new EIDataToolsProviderException("Could not complete operation; repository message is: ");
        }
        finally {
            method.releaseConnection();
        }
    }

    @Override
    public User login(String userName, String password) throws Exception {
        User user;
        HttpClient client = this.makeHttpClient(userName, password);
        client.getParams().setParameter("accept", (Object)"application/sparql-results+xml");
        client.getParams().setAuthenticationPreemptive(true);
        if (isDebugEnabled) {
            log.debug((Object)("Trying to login at " + RestCommands.WhoAmI.getURL() + " with username " + userName));
        }
        if ((user = this.getUserInformation(null, client)).getUserName() == null) {
            log.error((Object)("Could not authenticate user: " + user.getUserName()));
            throw new EIDataToolsProviderException("Could not authenticate user. Re-enter username and/or password.");
        }
        return user;
    }

    @Override
    public void logout(Session session) throws Exception {
        if (!Session.isValid((Session)session)) {
            log.error((Object)"Invalid Session - request cannot be completed");
            throw new EIDataToolsProviderException("No session information was found.");
        }
        int status = 0;
        PostMethod method = new PostMethod(RestCommands.Logout.getURL());
        if (isDebugEnabled) {
            log.debug((Object)("Trying to logout at " + RestCommands.Logout.getURL()));
        }
        try {
            HttpClient client = this.getHttpClient(session);
            status = this.executeMethod(client, (HttpMethod)method);
        }
        catch (Exception e) {
            log.error((Object)("problem with logout  " + RestCommands.Logout.getURL() + " " + e));
            throw new EIDataToolsProviderException(RepositoryProviderMessages.getFailedMessage("logout", 0));
        }
        finally {
            method.releaseConnection();
        }
        if (status == 200) {
            if (isDebugEnabled) {
                log.debug((Object)"logout succeded");
            }
            this.clientMap.remove(session);
        } else if (status == 302) {
            if (isDebugEnabled) {
                log.debug((Object)"logout semi-succeded: status 302");
            }
            this.clientMap.remove(session);
        } else {
            log.info((Object)("Could not logout user: HTTP Status: " + status));
            this.clientMap.remove(session);
            throw new EIDataToolsProviderException("Could not logout user: HTTP Status: " + status);
        }
    }

    @Override
    public User whoami(Session session) throws Exception {
        User sessionToResponse;
        if (!Session.isValid((Session)session)) {
            log.info((Object)"Using null session.  Could not whoami user");
            return null;
        }
        HttpClient client = this.getHttpClient(session);
        if (client == null) {
            log.info((Object)"Using stale session.  Could not whoami user");
            return null;
        }
        client.getParams().setParameter("accept", (Object)"application/sparql-results+xml");
        if (isDebugEnabled) {
            log.debug((Object)("Trying to whoami at " + RestCommands.WhoAmI.getURL()));
        }
        if ((sessionToResponse = this.getUserInformation(session, client)).getUserName() == null) {
            log.info((Object)"Could not whoami user: http status:");
            return null;
        }
        return sessionToResponse;
    }

    @Override
    public EIInstance getEmptyEIInstance(Session session, EIURI classUri, EIEntity instanceEntity) throws Exception {
        if (!Session.isValid((Session)session)) {
            throw new EIDataToolsProviderException("No session information was found.");
        }
        return EIInstanceFactory.getInstance().createEmpty(classUri, instanceEntity);
    }

    @Override
    public EIInstance getEmptyEIInstance(Session session, EIURI classUri) throws Exception {
        if (!Session.isValid((Session)session)) {
            throw new EIDataToolsProviderException("No session information was found.");
        }
        List<EIURI> ids = this.getNewInstanceID(session, 1);
        if (isDebugEnabled) {
            log.debug((Object)("New instance ID is: " + ids.get(0)));
        }
        EIInstance instance = EIInstanceFactory.getInstance().createEmpty(classUri, EIEntity.create((EIURI)ids.get(0), (String)""));
        log.info((Object)("got new instance of class " + classUri + "; null class ? " + (instance.getClass() == null ? "yes" : "no")));
        if (isDebugEnabled) {
            log.debug((Object)("New instance is: " + instance));
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOnline() {
        int status = 0;
        boolean online = false;
        GetMethod method = new GetMethod(RestCommands.Online.getURL());
        HttpClient client = new HttpClient();
        client.setHttpConnectionManager((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
        if (isDebugEnabled) {
            log.debug((Object)("Trying to see if Repository is available: " + RestCommands.Online.getURL()));
        }
        try {
            status = this.executeMethod(client, (HttpMethod)method);
            if (status == 200 || status == 401) {
                online = true;
                if (isDebugEnabled) {
                    log.debug((Object)("Repository is available: " + RestCommands.Online.getURL() + " is available with status: " + status));
                }
            } else if (isDebugEnabled) {
                log.debug((Object)("Repository is unavailable: " + RestCommands.Online.getURL() + " is available with status: " + status));
            }
        }
        catch (Exception e) {
            log.error((Object)("problem checking online status of repository: " + RestCommands.Online.getURL() + " " + e));
        }
        finally {
            method.releaseConnection();
        }
        return online;
    }

    private synchronized String postQuery(Session session, String q) throws Exception {
        return this.postQuery(session, q, READ_VIEW);
    }

    private synchronized String postQuery(Session session, String q, String view) throws Exception {
        if (!Session.isValid((Session)session)) {
            log.error((Object)"Invalid Session - request cannot be completed");
            throw new EIDataToolsProviderException("No session information was found.");
        }
        if (q == null) {
            log.warn((Object)"Null query!");
            return null;
        }
        int status = 0;
        PostMethod method = new PostMethod(RestCommands.Query.getURL());
        if (isDebugEnabled) {
            log.debug((Object)("Trying to query: " + RestCommands.Query.getURL()));
        }
        this.setReadParameters(method);
        method.setParameter("view", view);
        method.setParameter("query", q);
        try {
            HttpClient client = this.getHttpClient(session);
            status = this.executeMethod(client, (HttpMethod)method);
            String resp = this.getStringFromInputStream(method.getResponseBodyAsStream());
            if (status == 200) {
                if (isDebugEnabled) {
                    log.debug((Object)("query sparql endpoint succeded with status: " + status));
                }
                String string = resp;
                return string;
            }
            log.error((Object)("query sparql endpoint  failed with status: " + status));
            log.error((Object)("Message from repository: " + resp));
            throw new EIDataToolsProviderException(RepositoryProviderMessages.getFailedMessage("query", status));
        }
        finally {
            method.releaseConnection();
        }
    }

    @Override
    public String query(Session session, String sparql) throws Exception {
        if (!Session.isValid((Session)session)) {
            log.error((Object)"Invalid Session - request cannot be completed");
            throw new EIDataToolsProviderException("No session information was found.");
        }
        return this.postQuery(session, sparql);
    }

    @Override
    public List<EIInstanceMinimal> EIQuery(Session session, String sparql) throws Exception {
        if (!Session.isValid((Session)session)) {
            log.error((Object)"Invalid Session - request cannot be completed");
            throw new EIDataToolsProviderException("No session information was found.");
        }
        if (isDebugEnabled) {
            log.debug((Object)("Sparql: " + sparql));
        }
        ResultSet resultSet = ResultSetFactory.fromXML((String)this.postQuery(session, sparql));
        return EIInstanceFactory.getInstance().create(resultSet);
    }

    @Override
    public List<EIInstanceMinimal> getFilterQuery(Session session, EIURI classUri, EIURI state, EIURI lab) throws Exception {
        return this.getFilterQuery(session, classUri, state, lab, false);
    }

    @Override
    public List<EIInstanceMinimal> getFilterQuery(Session session, EIURI classUri, EIURI state, EIURI lab, boolean strictOwnerFilter) throws Exception {
        if (!Session.isValid((Session)session)) {
            throw new EIDataToolsProviderException("No session information was found.");
        }
        return this.EIQuery(session, SPARQLQueryUtil.getInstance().getFilterQuery(session.getUserURI(), classUri, state, lab, strictOwnerFilter));
    }

    @Override
    public List<EIInstanceMinimal> referencedByQuery(Session session, EIURI resourceUri, boolean strictOwnerFilter) throws Exception {
        if (!Session.isValid((Session)session)) {
            throw new EIDataToolsProviderException("No session information was found.");
        }
        return this.EIQuery(session, SPARQLQueryUtil.getInstance().getReferencedByQuery(session.getUserURI(), resourceUri, strictOwnerFilter));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void uploadInstances(Session session, String rdf) throws Exception {
        if (!Session.isValid((Session)session)) {
            log.error((Object)"Invalid Session - request cannot be completed");
            throw new EIDataToolsProviderException("No session information was found.");
        }
        if (rdf == null) {
            log.warn((Object)"Trying to upload null rdf");
            return;
        }
        int status = 0;
        PostMethod method = new PostMethod(RestCommands.Upload.getURL());
        method.setParameter("format", "text/plain");
        method.setParameter("name", "http://eagle-i.org/ont/repo/1.0/NG_Published");
        method.setParameter("type", "published");
        method.setParameter("action", "add");
        method.setParameter("content", rdf);
        try {
            HttpClient client = this.getHttpClient(session);
            status = this.executeMethod(client, (HttpMethod)method);
            String resp = this.getStringFromInputStream(method.getResponseBodyAsStream());
            if (status == 200) {
                log.info((Object)("upload succeed with status: " + status + " response: " + resp));
            } else {
                log.error((Object)("upload sparql endpoint  failed with status: " + status + " response: " + resp));
            }
        }
        catch (Exception e) {
            log.error((Object)("problem with upload endpoint at URL  " + RestCommands.Upload.getURL() + " because " + e));
        }
        finally {
            method.releaseConnection();
        }
    }

    @Override
    public String claim(Session session, EIURI uri, String claimant) throws Exception {
        if (!Session.isValid((Session)session)) {
            throw new EIDataToolsProviderException("No session information was found.");
        }
        if (uri == null || claimant == null) {
            log.warn((Object)("null claim parameter, returning null: " + (uri == null ? "uri" : (claimant == null ? "claimant" : "huh?"))));
            return null;
        }
        int status = 0;
        PostMethod method = new PostMethod(RestCommands.Workflow.getURL());
        method.setParameter("uri", uri.toString());
        method.setParameter("format", FORMAT_VALUE);
        method.setParameter("claim", claimant);
        log.info((Object)("Trying to claim " + uri + " for " + claimant));
        try {
            HttpClient client = this.getHttpClient(session);
            status = this.executeMethod(client, (HttpMethod)method);
            String resp = this.getStringFromInputStream(method.getResponseBodyAsStream());
            if (status == 200) {
                log.info((Object)("claim succeded with status: " + status + " response: " + resp));
                String string = resp;
                return string;
            }
            log.error((Object)("claim failed with status: " + status + " response: " + resp));
            throw new EIDataToolsProviderException(RepositoryProviderMessages.getFailedMessage("claim", status));
        }
        finally {
            method.releaseConnection();
        }
    }

    @Override
    public String promote(Session session, EIURI uri, EIURI newState) throws Exception {
        if (!Session.isValid((Session)session)) {
            throw new EIDataToolsProviderException("No session information was found.");
        }
        if (uri == null) {
            log.warn((Object)"Trying to promote a null URI");
            return null;
        }
        int status = 0;
        PostMethod method = new PostMethod(RestCommands.Workflow.getURL());
        method.setParameter("uri", uri.toString());
        method.setParameter("format", FORMAT_VALUE);
        method.setParameter("promote", newState.toString());
        if (isDebugEnabled) {
            log.debug((Object)("Trying to get promote " + uri + " to state " + newState));
        }
        try {
            HttpClient client = this.getHttpClient(session);
            status = this.executeMethod(client, (HttpMethod)method);
            String resp = this.getStringFromInputStream(method.getResponseBodyAsStream());
            if (status == 200) {
                log.info((Object)("promote succeded with status: " + status + " response: " + resp));
                String string = newState.toString();
                return string;
            }
            log.error((Object)("promote failed with status: " + status + " response: " + resp));
            throw new EIDataToolsProviderException(RepositoryProviderMessages.getFailedMessage("promote", status));
        }
        finally {
            method.releaseConnection();
        }
    }

    public List<EIURI> getWFStatesList(Session session) throws Exception {
        if (!Session.isValid((Session)session)) {
            throw new EIDataToolsProviderException("No session information was found.");
        }
        String q = SPARQLQueryUtil.getInstance().getWFStatesQuery(session.getUserURI());
        if (isDebugEnabled) {
            log.debug((Object)("get wf states query: " + q));
        }
        String result = this.postQuery(session, q, "all");
        ResultSet resultSet = ResultSetFactory.fromXML((String)result);
        ArrayList<EIURI> states = new ArrayList<EIURI>();
        while (resultSet.hasNext()) {
            QuerySolution qs = resultSet.next();
            if (!qs.contains("state")) continue;
            states.add(EIURI.create((String)qs.getResource("state").getURI()));
        }
        return states;
    }

    @Override
    public String[] getWFStates(Session session) throws Exception {
        List<EIURI> states = this.getWFStatesList(session);
        return states.toArray(new String[states.size()]);
    }

    @Override
    public Map<EIEntity, String> retrieveLabels(Session session, List<EIEntity> entities) throws Exception {
        if (!Session.isValid((Session)session)) {
            throw new EIDataToolsProviderException("No session information was found.");
        }
        log.info((Object)"retrieving labels");
        HashMap<EIEntity, String> results = new HashMap<EIEntity, String>(entities.size());
        for (EIEntity entity : entities) {
            try {
                results.put(entity, this.retrieveLabel(session, entity.getURI()));
            }
            catch (EIDataToolsProviderException e) {
                int statusLoc = e.getMessage().indexOf("4");
                if (statusLoc < 0) {
                    throw e;
                }
                String statusString = e.getMessage().substring(statusLoc);
                if (!statusString.equals("400")) {
                    throw e;
                }
                log.warn((Object)("could not retrieve label for " + entity.getURI() + "; skipping"));
            }
        }
        String q = SPARQLQueryUtil.getInstance().getRetrieveLabelsQuery(entities);
        if (isDebugEnabled) {
            log.debug((Object)("retrieve labels query: " + q));
        }
        String labelsResult = this.postQuery(session, q, "all");
        if (isDebugEnabled) {
            log.debug((Object)("result " + labelsResult));
        }
        return results;
    }

    @Override
    public Map<EIURI, String> retrieveUriLabels(Session session, List<EIURI> uris) throws Exception {
        if (!Session.isValid((Session)session)) {
            throw new EIDataToolsProviderException("No session information was found.");
        }
        log.info((Object)"retrieving labels");
        HashMap<EIURI, String> results = new HashMap<EIURI, String>(uris.size());
        for (EIURI uri : uris) {
            results.put(uri, this.retrieveLabel(session, uri));
        }
        String q = SPARQLQueryUtil.getInstance().getRetrieveUriLabelsQuery(uris);
        if (isDebugEnabled) {
            log.debug((Object)("retrieve labels query: " + q));
        }
        String labelsResult = this.postQuery(session, q, "all");
        if (isDebugEnabled) {
            log.debug((Object)("result " + labelsResult));
        }
        return results;
    }

    @Override
    public String retrieveLabel(Session session, EIURI uri) throws Exception {
        if (!Session.isValid((Session)session)) {
            throw new EIDataToolsProviderException("No session information was found.");
        }
        String q = SPARQLQueryUtil.getInstance().getRetrieveLabelQuery(uri);
        if (isDebugEnabled) {
            log.debug((Object)("retrieve label query: " + q));
        }
        String result = this.postQuery(session, q, "all");
        if (isDebugEnabled) {
            log.debug((Object)("result " + result));
        }
        ResultSet resultSet = ResultSetFactory.fromXML((String)result);
        ArrayList<String> labels = new ArrayList<String>();
        while (resultSet.hasNext()) {
            QuerySolution qs = resultSet.next();
            if (!qs.contains("l")) continue;
            labels.add(qs.getLiteral("l").getString());
        }
        log.info((Object)("labels for " + uri.toString() + ": "));
        for (String label : labels) {
            log.info((Object)label);
        }
        return labels.isEmpty() ? "" : (String)labels.get(0);
    }

    private String getStringFromInputStream(InputStream in) throws IOException {
        if (in == null) {
            return null;
        }
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)in, (Writer)writer, (String)"UTF-8");
        return writer.toString();
    }

    static {
        WITDRAWN_WORKSPACE_URI = "http://eagle-i.org/ont/repo/1.0/NG_Withdrawn";
        SANDBOX_WORKSPACE_URI = "http://eagle-i.org/ont/repo/1.0/NG_Sandbox";
    }

    static enum LoginFields {
        USERNAME(0),
        SESSION(1),
        USER_URI(2),
        ERROR_MESSAGE(3),
        WF_STATE(3);

        private final int value;

        private LoginFields(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    static enum RestCommands {
        GetNewInstanceIDs("repository/new"),
        WhoAmI("repository/whoami"),
        Logout("repository/logout/"),
        GetInstance("i"),
        UpdateInstance("repository/update"),
        Query("repository/sparql"),
        Online(""),
        Upload("repository/graph"),
        Workflow("repository/fakeworkflow"),
        Listgraphs("/repository/listGraphs");

        private final String key;

        private RestCommands(String propKey) {
            this.key = propKey;
        }

        public String getURL() {
            return DEFAULT_REPOSITORY + this.key;
        }
    }
}

