/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.jena;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;

public class SPARQLQueryUtil {
    private static final Log logger = LogFactory.getLog(SPARQLQueryUtil.class);
    private static SPARQLQueryUtil instance;

    private SPARQLQueryUtil() {
    }

    public static SPARQLQueryUtil getInstance() {
        if (instance == null) {
            instance = new SPARQLQueryUtil();
        }
        return instance;
    }

    public String getEIResourcesByLabelQuery(EIURI rootURI, String label) {
        StringBuilder sparql = new StringBuilder();
        sparql.append("PREFIX rdf: <");
        sparql.append("http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        sparql.append("> ");
        sparql.append("PREFIX rdfs: <");
        sparql.append("http://www.w3.org/2000/01/rdf-schema#");
        sparql.append("> ");
        sparql.append("SELECT ?resource WHERE {?resource rdf:type <");
        sparql.append(rootURI.toString());
        sparql.append("> . ");
        sparql.append("?resource rdfs:label ?o ");
        sparql.append("FILTER regex(str(?o), \"" + label + "\", \"i\").}");
        return sparql.toString();
    }

    public String getWFStatesQuery(String user) {
        StringBuilder sparql = new StringBuilder();
        sparql.append("PREFIX repo: <");
        sparql.append("http://eagle-i.org/ont/repo/1.0/");
        sparql.append(">");
        sparql.append("SELECT DISTINCT ?state WHERE {?state repo:hasWriter ?role . <");
        sparql.append(user);
        sparql.append("> repo:hasRole ?role .}");
        return sparql.toString();
    }

    public String getRetrieveLabelQuery(EIURI uri) {
        StringBuilder sparql = new StringBuilder();
        sparql.append("PREFIX rdfs: <");
        sparql.append("http://www.w3.org/2000/01/rdf-schema#");
        sparql.append("> ");
        sparql.append("SELECT DISTINCT ?l WHERE {<");
        sparql.append(uri.toString());
        sparql.append("> rdfs:label ?l}");
        return sparql.toString();
    }

    public String getRetrieveLabelsQuery(List<EIEntity> entities) {
        StringBuilder sparql = new StringBuilder();
        sparql.append("PREFIX rdfs: <");
        sparql.append("http://www.w3.org/2000/01/rdf-schema#");
        sparql.append("> ");
        sparql.append("SELECT DISTINCT ?l WHERE {");
        int i = 0;
        for (EIEntity entity : entities) {
            sparql.append("{<");
            sparql.append(entity.getURI().toString());
            sparql.append("> rdfs:label ?l}");
            if (i < entities.size() - 1) {
                sparql.append(" UNION ");
            }
            ++i;
        }
        sparql.append("}");
        return sparql.toString();
    }

    public String getRetrieveUriLabelsQuery(List<EIURI> uris) {
        StringBuilder sparql = new StringBuilder();
        sparql.append("PREFIX rdfs: <");
        sparql.append("http://www.w3.org/2000/01/rdf-schema#");
        sparql.append("> ");
        sparql.append("SELECT DISTINCT ?l WHERE {");
        int i = 0;
        for (EIURI uri : uris) {
            sparql.append("{<");
            sparql.append(uri.toString());
            sparql.append("> rdfs:label ?l}");
            if (i < uris.size() - 1) {
                sparql.append(" UNION ");
            }
            ++i;
        }
        sparql.append("}");
        return sparql.toString();
    }

    @Deprecated
    public String getAllResourcesQuery(String user, boolean strictOwnerFilter) {
        return this.getFilterQuery(user, EIURI.NULL_EIURI, EIURI.NULL_EIURI, EIURI.NULL_EIURI, strictOwnerFilter);
    }

    public String getReferencedByQuery(String user, EIURI resourceUri, boolean strictOwnerFilter) {
        StringBuilder sparql = new StringBuilder();
        sparql.append(this.namespaces());
        sparql.append(this.selectClause());
        sparql.append(this.commonPattern());
        sparql.append(this.typePattern());
        sparql.append("?s ?anyPredicate <");
        sparql.append(resourceUri.toString());
        sparql.append("> . ");
        sparql.append(this.restrictionPattern(EIURI.NULL_EIURI, EIURI.NULL_EIURI, EIURI.NULL_EIURI, false));
        sparql.append(this.ownerPattern(user, strictOwnerFilter));
        sparql.append(this.closingClause());
        return sparql.toString();
    }

    public String getFilterQuery(String user, EIURI classUri, EIURI state, EIURI lab, boolean strictOwnerFilter) {
        StringBuilder sparql = new StringBuilder();
        sparql.append(this.namespaces());
        sparql.append(this.selectClause());
        sparql.append(this.commonPattern());
        sparql.append(this.typePattern());
        sparql.append(this.restrictionPattern(classUri, state, lab, true));
        sparql.append(this.ownerPattern(user, strictOwnerFilter));
        sparql.append(this.closingClause());
        return sparql.toString();
    }

    private String namespaces() {
        StringBuilder namespaces = new StringBuilder();
        namespaces.append("PREFIX dcterms: <");
        namespaces.append("http://purl.org/dc/terms/");
        namespaces.append("> ");
        namespaces.append("PREFIX rdf: <");
        namespaces.append("http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        namespaces.append("> ");
        namespaces.append("PREFIX rdfs: <");
        namespaces.append("http://www.w3.org/2000/01/rdf-schema#");
        namespaces.append("> ");
        namespaces.append("PREFIX repo: <");
        namespaces.append("http://eagle-i.org/ont/repo/1.0/");
        namespaces.append("> ");
        return namespaces.toString();
    }

    private String selectClause() {
        StringBuilder select = new StringBuilder();
        select.append("SELECT DISTINCT ");
        select.append("?s ?t ?l ?date ?owner ?state ?lab ?labName ");
        select.append("WHERE {");
        return select.toString();
    }

    private String commonPattern() {
        return "?s rdfs:label ?l . ?s dcterms:created ?date . ";
    }

    private String typePattern() {
        return "graph ?g{?s rdf:type ?t} filter(?g != repo:NG_Inferred) . ";
    }

    private String allTypesPattern(boolean excludeSomeTypes) {
        StringBuilder allTypes = new StringBuilder();
        allTypes.append("?s rdf:type ?rt . ");
        allTypes.append("?rt <http://eagle-i.org/ont/app/1.0/inClassGroup> <http://eagle-i.org/ont/app/1.0/ClassGroup/resourceRoot> ");
        if (excludeSomeTypes) {
            allTypes.append("filter(?rt != <");
            allTypes.append("http://purl.obolibrary.org/obo/OBI_0000245");
            allTypes.append("> && ?rt != <");
            allTypes.append("http://xmlns.com/foaf/0.1/Person");
            allTypes.append(">) .");
        }
        return allTypes.toString();
    }

    private String ownerPattern(String user, boolean strictOwnerFilter) {
        StringBuilder owner = new StringBuilder();
        if (strictOwnerFilter) {
            owner.append("?s repo:hasWorkflowOwner ?owner . FILTER(?owner = <");
        } else {
            owner.append("OPTIONAL {?s repo:hasWorkflowOwner ?owner} . FILTER(!bound(?owner) || ?owner = <");
        }
        owner.append(user);
        owner.append(">) . ");
        return owner.toString();
    }

    private String restrictionPattern(EIURI classUri, EIURI state, EIURI lab, boolean excludeSomeTypes) {
        StringBuilder graphPattern = new StringBuilder();
        if (!this.isNull(classUri)) {
            graphPattern.append("?s rdf:type <");
            graphPattern.append(classUri.toString());
            graphPattern.append("> .");
        } else {
            graphPattern.append(this.allTypesPattern(excludeSomeTypes));
        }
        if (!this.isNull(state)) {
            graphPattern.append("?s repo:hasWorkflowState <");
            graphPattern.append(state.toString());
            graphPattern.append("> . ?s repo:hasWorkflowState ?state .");
        } else {
            graphPattern.append("OPTIONAL {?s repo:hasWorkflowState ?state} . ");
        }
        if (!this.isNull(lab)) {
            graphPattern.append("?s ?labProperty ?lab . ?lab rdfs:label ?labName . ?labProperty <http://eagle-i.org/ont/app/1.0/inPropertyGroup> <http://eagle-i.org/ont/app/1.0/PropertyGroup/relatedLab> . filter(?lab = <");
            graphPattern.append(lab.toString());
            graphPattern.append(">) . ");
        } else {
            graphPattern.append("OPTIONAL {?s ?labProperty ?lab . ?labProperty <http://eagle-i.org/ont/app/1.0/inPropertyGroup> <http://eagle-i.org/ont/app/1.0/PropertyGroup/relatedLab> .");
            graphPattern.append("?lab a <http://purl.obolibrary.org/obo/ERO_0000001> . ?lab rdfs:label ?labName} . ");
        }
        return graphPattern.toString();
    }

    private String closingClause() {
        return "} order by repo:upperCaseStr(?l)";
    }

    private boolean isNull(EIURI uri) {
        return uri == null || uri.equals((Object)EIURI.NULL_EIURI) || "".equals(uri.toString());
    }
}

