/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.jena;

import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.datatools.model.DataToolsOntConstants;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstanceMinimal;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIURI;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class EIInstanceMinimalFactory {
    private static EIOntModel ontModel;
    private static final Log logger;
    private static final boolean isDebugEnabled;
    private static final EIInstanceMinimalFactory INSTANCE;

    public static EIInstanceMinimalFactory getInstance() {
        return INSTANCE;
    }

    private EIInstanceMinimalFactory() {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext(new String[]{"datatools-model-config.xml"});
        ontModel = (EIOntModel)context.getBean(EIOntModel.class);
    }

    public EIInstanceMinimal createEmptyMinimal(EIURI typeUri, EIEntity instanceEntity) {
        if (instanceEntity == null) {
            return null;
        }
        EIClass instanceClass = this.safeGetClass(typeUri);
        if (instanceClass == null) {
            return null;
        }
        String label = instanceClass.getEntity().getLabel();
        instanceClass.getEntity().setLabel(label);
        EIInstanceMinimal ei = EIInstanceMinimal.create((EIEntity)instanceClass.getEntity(), (EIEntity)instanceEntity);
        return ei;
    }

    public List<EIInstanceMinimal> create(ResultSet resultSet) {
        if (resultSet == null) {
            return Collections.EMPTY_LIST;
        }
        HashMap<EIURI, EIInstanceMinimal> instances = new HashMap<EIURI, EIInstanceMinimal>();
        ArrayList<EIInstanceMinimal> instanceList = new ArrayList<EIInstanceMinimal>();
        while (resultSet.hasNext()) {
            QuerySolution solution = resultSet.next();
            if (solution.contains("r_subject") && solution.contains("r_type") && solution.contains("r_label")) {
                EIInstanceMinimal ei;
                EIURI instanceUri = this.getUriFromSolution(solution, "r_subject");
                EIURI instanceType = this.getUriFromSolution(solution, "r_type");
                String label = this.getStringFromSolution(solution, "r_label");
                if (this.safeGetClass(instanceType) == null) {
                    if (!isDebugEnabled) continue;
                    logger.debug((Object)("Query solution without EIClass: " + solution));
                    continue;
                }
                if (!instances.containsKey(instanceUri)) {
                    ei = this.createEmptyMinimal(instanceType, EIEntity.create((EIURI)instanceUri, (String)label));
                    instances.put(instanceUri, ei);
                    instanceList.add(ei);
                } else {
                    ei = (EIInstanceMinimal)instances.get(instanceUri);
                    if (isDebugEnabled) {
                        logger.debug((Object)("Processing query solution for an already processed instance: " + ei));
                    }
                    ei.addEIType(EIEntity.create((EIURI)instanceType, (String)""));
                }
                ei.setWFOwner(this.getEntityFromSolution(solution, "r_owner", "r_ownerLabel"));
                ei.setWFState(this.getEntityFromSolution(solution, "r_state", ""));
                ei.setCreationDate(this.getStringFromSolution(solution, "r_created"));
                ei.setModifiedDate(this.getStringFromSolution(solution, "r_last_modified"));
                ei.setLab(this.getEntityFromSolution(solution, "r_lab", "r_labName"));
                continue;
            }
            if (!isDebugEnabled) continue;
            logger.debug((Object)("Query solution without type, label or subject: " + solution));
        }
        return instanceList;
    }

    private EIEntity getEntityFromSolution(QuerySolution solution, String uriVariable, String labelVariable) {
        if (solution.contains(uriVariable)) {
            EIURI uri = EIURI.create((String)solution.getResource(uriVariable).getURI());
            if ("r_state".equals(uriVariable)) {
                return DataToolsOntConstants.getStatusEntity((EIURI)uri);
            }
            String label = "<none>";
            if (solution.contains(labelVariable)) {
                label = solution.getLiteral(labelVariable).getString();
            }
            return EIEntity.create((EIURI)uri, (String)label);
        }
        return EIEntity.NULL_ENTITY;
    }

    private EIURI getUriFromSolution(QuerySolution solution, String variable) {
        if (solution.contains(variable)) {
            return EIURI.create((String)solution.getResource(variable).getURI());
        }
        return EIURI.NULL_EIURI;
    }

    private String getStringFromSolution(QuerySolution solution, String variable) {
        if (solution.contains(variable)) {
            return solution.getLiteral(variable).getString();
        }
        return "";
    }

    private EIClass safeGetClass(EIURI typeUri) {
        if (ontModel.isModelClassURI(typeUri.toString())) {
            return ontModel.getClass(typeUri);
        }
        return null;
    }

    static {
        logger = LogFactory.getLog(EIInstanceMinimalFactory.class);
        isDebugEnabled = logger.isDebugEnabled();
        INSTANCE = new EIInstanceMinimalFactory();
    }
}

