/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.jena;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.datatools.jena.SPARQLConstants;
import org.eaglei.model.EIURI;

public class SPARQLQueryUtil {
    private static final Log logger = LogFactory.getLog(SPARQLQueryUtil.class);
    private static SPARQLQueryUtil instance;

    private SPARQLQueryUtil() {
    }

    public static SPARQLQueryUtil getInstance() {
        if (instance == null) {
            instance = new SPARQLQueryUtil();
        }
        return instance;
    }

    public String getEIResourcesByLabelQuery(EIURI rootURI, String label) {
        StringBuilder sparql = new StringBuilder();
        sparql.append("PREFIX rdf: <");
        sparql.append("http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        sparql.append("> ");
        sparql.append("PREFIX rdfs: <");
        sparql.append("http://www.w3.org/2000/01/rdf-schema#");
        sparql.append("> ");
        sparql.append("SELECT ?resource WHERE {?resource a <");
        sparql.append(rootURI.toString());
        sparql.append("> . ");
        sparql.append("?resource <http://www.w3.org/2000/01/rdf-schema#label> ?o ");
        sparql.append("FILTER regex(str(?o), \"" + label + "\", \"i\").}");
        return sparql.toString();
    }

    @Deprecated
    public String getWFStatesQuery(String user) {
        StringBuilder sparql = new StringBuilder();
        sparql.append("PREFIX repo: <");
        sparql.append("http://eagle-i.org/ont/repo/1.0/");
        sparql.append(">");
        sparql.append("SELECT DISTINCT ?");
        sparql.append("r_state");
        sparql.append(" WHERE {?");
        sparql.append("r_state");
        sparql.append(" repo:hasWriter ?role . <");
        sparql.append(user);
        sparql.append("> repo:hasRole ?role .}");
        return sparql.toString();
    }

    public String getRetrieveLabelQuery(EIURI uri) {
        StringBuilder sparql = new StringBuilder();
        sparql.append("PREFIX rdfs: <");
        sparql.append("http://www.w3.org/2000/01/rdf-schema#");
        sparql.append("> ");
        sparql.append("SELECT DISTINCT ?");
        sparql.append("r_label");
        sparql.append(" WHERE {<");
        sparql.append(uri.toString());
        sparql.append("> <http://www.w3.org/2000/01/rdf-schema#label> ?");
        sparql.append("r_label");
        sparql.append("}");
        return sparql.toString();
    }

    @Deprecated
    public String getAllResourcesQuery(String user, boolean strictOwnerFilter) {
        return this.getFilterQuery(user, EIURI.NULL_EIURI, EIURI.NULL_EIURI, EIURI.NULL_EIURI, strictOwnerFilter);
    }

    @Deprecated
    public String getReferencedByQuery(String user, EIURI resourceUri, boolean strictOwnerFilter) {
        StringBuilder sparql = new StringBuilder();
        sparql.append(this.namespaces());
        sparql.append(this.selectClause());
        sparql.append(this.commonPattern());
        sparql.append(this.typePattern());
        sparql.append(this.referencedByPattern(resourceUri));
        sparql.append(this.typeRestrictionPattern(EIURI.NULL_EIURI, false));
        sparql.append(this.stateRestrictionPattern(EIURI.NULL_EIURI));
        sparql.append(this.labRestrictionPattern(EIURI.NULL_EIURI));
        sparql.append(this.ownerRestrictionPattern(EIURI.create((String)user), strictOwnerFilter));
        sparql.append(this.closingClause());
        return sparql.toString();
    }

    public String referencedByPattern(EIURI resourceUri) {
        StringBuilder sparql = new StringBuilder();
        sparql.append("?");
        sparql.append("r_subject");
        sparql.append(" ?anyPredicate <");
        sparql.append(resourceUri.toString());
        sparql.append("> . ");
        return sparql.toString();
    }

    @Deprecated
    public String getFilterQuery(String user, EIURI classUri, EIURI state, EIURI lab, boolean strictOwnerFilter) {
        StringBuilder sparql = new StringBuilder();
        sparql.append(this.namespaces());
        sparql.append(this.selectClause());
        sparql.append(this.commonPattern());
        sparql.append(this.typePattern());
        sparql.append(this.typeRestrictionPattern(classUri, true));
        sparql.append(this.stateRestrictionPattern(state));
        sparql.append(this.labRestrictionPattern(lab));
        sparql.append(this.ownerRestrictionPattern(EIURI.create((String)user), strictOwnerFilter));
        sparql.append(this.closingClause());
        return sparql.toString();
    }

    @Deprecated
    private String namespaces() {
        StringBuilder namespaces = new StringBuilder();
        namespaces.append("PREFIX dcterms: <");
        namespaces.append("http://purl.org/dc/terms/");
        namespaces.append("> ");
        namespaces.append("PREFIX rdf: <");
        namespaces.append("http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        namespaces.append("> ");
        namespaces.append("PREFIX rdfs: <");
        namespaces.append("http://www.w3.org/2000/01/rdf-schema#");
        namespaces.append("> ");
        namespaces.append("PREFIX repo: <");
        namespaces.append("http://eagle-i.org/ont/repo/1.0/");
        namespaces.append("> ");
        return namespaces.toString();
    }

    @Deprecated
    private String selectClause() {
        StringBuilder sparql = new StringBuilder();
        sparql.append("SELECT DISTINCT ");
        for (String variable : SPARQLConstants.resultSetVariables) {
            sparql.append("?");
            sparql.append(variable);
            sparql.append(" ");
        }
        sparql.append("WHERE {");
        return sparql.toString();
    }

    @Deprecated
    private String commonPattern() {
        StringBuilder sparql = new StringBuilder();
        sparql.append("?");
        sparql.append("r_subject");
        sparql.append(" <http://www.w3.org/2000/01/rdf-schema#label> ?");
        sparql.append("r_label");
        sparql.append(" . ?");
        sparql.append("r_subject");
        sparql.append(" dcterms:created ?");
        sparql.append("r_created");
        sparql.append(" . ");
        return sparql.toString();
    }

    @Deprecated
    private String typePattern() {
        return "graph ?g{?r_subject a ?r_type} filter(?g != repo:NG_Inferred) . ";
    }

    public String allTypesPattern(boolean excludeSomeTypes) {
        StringBuilder sparql = new StringBuilder();
        sparql.append("?");
        sparql.append("r_subject");
        sparql.append(" a ?rt . ");
        sparql.append("?rt <http://eagle-i.org/ont/app/1.0/inClassGroup> <http://eagle-i.org/ont/app/1.0/ClassGroup/resourceRoot> ");
        if (excludeSomeTypes) {
            sparql.append("filter(?rt != <");
            sparql.append("http://purl.obolibrary.org/obo/OBI_0000245");
            sparql.append("> && ?rt != <");
            sparql.append("http://xmlns.com/foaf/0.1/Person");
            sparql.append(">) .");
        }
        return sparql.toString();
    }

    public String includeOwnerLabel() {
        StringBuilder sparql = new StringBuilder();
        sparql.append("OPTIONAL{?").append("r_subject");
        sparql.append(" <http://eagle-i.org/ont/repo/1.0/hasWorkflowOwner> ?").append("r_owner");
        sparql.append(". ?").append("r_owner");
        sparql.append(" <http://www.w3.org/2000/01/rdf-schema#label> ?");
        sparql.append("r_ownerLabel").append("} . ");
        return sparql.toString();
    }

    public String getAllPossibleOwners() {
        StringBuilder sparql = new StringBuilder();
        sparql.append("SELECT DISTINCT ?").append("r_owner");
        sparql.append(" ?").append("r_ownerLabel");
        sparql.append(" WHERE { ?").append("r_subject");
        sparql.append(" <http://eagle-i.org/ont/repo/1.0/hasWorkflowOwner> ?").append("r_owner");
        sparql.append(". ?").append("r_owner");
        sparql.append(" <http://www.w3.org/2000/01/rdf-schema#label> ?");
        sparql.append("r_ownerLabel").append("}");
        return sparql.toString();
    }

    public String ownerRestrictionPattern(EIURI user, boolean strictOwnerFilter) {
        StringBuilder sparql = new StringBuilder();
        if (strictOwnerFilter) {
            sparql.append("?");
            sparql.append("r_subject");
            sparql.append(" <http://eagle-i.org/ont/repo/1.0/hasWorkflowOwner> ?");
            sparql.append("r_owner");
            sparql.append(". FILTER(?");
            sparql.append("r_owner");
            sparql.append("= <");
        } else {
            sparql.append("OPTIONAL {?");
            sparql.append("r_subject");
            sparql.append(" <http://eagle-i.org/ont/repo/1.0/hasWorkflowOwner> ?");
            sparql.append("r_owner");
            sparql.append("} . FILTER(!bound(?");
            sparql.append("r_owner");
            sparql.append(") || ?");
            sparql.append("r_owner");
            sparql.append(" = <");
        }
        sparql.append(user.toString());
        sparql.append(">) . ");
        return sparql.toString();
    }

    private String typeRestrictionPattern(EIURI classUri, boolean excludeSomeTypes) {
        StringBuilder sparql = new StringBuilder();
        if (!this.isNull(classUri)) {
            sparql.append("?");
            sparql.append("r_subject");
            sparql.append(" a <");
            sparql.append(classUri.toString());
            sparql.append("> .");
        } else {
            sparql.append(this.allTypesPattern(excludeSomeTypes));
        }
        return sparql.toString();
    }

    private String stateRestrictionPattern(EIURI state) {
        StringBuilder sparql = new StringBuilder();
        if (!this.isNull(state)) {
            sparql.append("?");
            sparql.append("r_subject");
            sparql.append(" repo:hasWorkflowState <");
            sparql.append(state.toString());
            sparql.append("> . ?");
            sparql.append("r_subject");
            sparql.append(" repo:hasWorkflowState ?");
            sparql.append("r_state");
            sparql.append(" . ");
        } else {
            sparql.append("OPTIONAL {?");
            sparql.append("r_subject");
            sparql.append(" repo:hasWorkflowState ?");
            sparql.append("r_state");
            sparql.append("} . ");
        }
        return sparql.toString();
    }

    public String labRestrictionPattern(EIURI lab) {
        StringBuilder sparql = new StringBuilder();
        if (!this.isNull(lab)) {
            sparql.append("?");
            sparql.append("r_subject");
            sparql.append(" ?labProperty ?");
            sparql.append("r_lab");
            sparql.append(" . ?");
            sparql.append("r_lab");
            sparql.append(" <http://www.w3.org/2000/01/rdf-schema#label> ?");
            sparql.append("r_labName");
            sparql.append(" . ?labProperty <http://eagle-i.org/ont/app/1.0/inPropertyGroup> <http://eagle-i.org/ont/app/1.0/PropertyGroup/relatedLab> . filter(?");
            sparql.append("r_lab");
            sparql.append(" = <");
            sparql.append(lab.toString());
            sparql.append(">) . ");
        } else {
            sparql.append("OPTIONAL {?");
            sparql.append("r_subject");
            sparql.append(" ?labProperty ?");
            sparql.append("r_lab");
            sparql.append(" . ?labProperty <http://eagle-i.org/ont/app/1.0/inPropertyGroup> <http://eagle-i.org/ont/app/1.0/PropertyGroup/relatedLab> . ?");
            sparql.append("r_lab");
            sparql.append(" a <");
            sparql.append("http://purl.obolibrary.org/obo/ERO_0000001");
            sparql.append("> . ?");
            sparql.append("r_lab");
            sparql.append(" <http://www.w3.org/2000/01/rdf-schema#label> ?");
            sparql.append("r_labName");
            sparql.append("} . ");
        }
        return sparql.toString();
    }

    public String getResourcesETLedFromFileQuery(String fileName) {
        StringBuilder sparql = new StringBuilder();
        sparql.append("PREFIX rdfs: <");
        sparql.append("http://www.w3.org/2000/01/rdf-schema#");
        sparql.append("> ");
        sparql.append("PREFIX rdf: <");
        sparql.append("http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        sparql.append("> ");
        sparql.append("PREFIX ei-dt: <");
        sparql.append("http://eagle-i.org/ont/datatools/1.0/");
        sparql.append("> ");
        sparql.append("SELECT ?resource WHERE {?resource  ei-dt:source_file  \"" + fileName + "\".}");
        return sparql.toString();
    }

    private String closingClause() {
        return "} order by repo:upperCaseStr(?r_label)";
    }

    private boolean isNull(EIURI uri) {
        return uri == null || uri.equals((Object)EIURI.NULL_EIURI) || "".equals(uri.toString());
    }

    public String modifiedDatePattern() {
        return " OPTIONAL {?r_subject <http://purl.org/dc/terms/modified> ?r_last_modified} .";
    }

    public String getModifiedDateQuery(EIURI uri) {
        return "SELECT ?r_last_modified WHERE { <" + uri + ">  <http://purl.org/dc/terms/modified> ?" + "r_last_modified" + " }";
    }

    public String additionalLabelsPattern() {
        StringBuilder sparql = new StringBuilder();
        sparql.append("OPTIONAL {?").append("r_state").append(" <http://www.w3.org/2000/01/rdf-schema#label> ?").append("r_stateLabel").append("} . ");
        sparql.append("OPTIONAL {?").append("r_type").append(" <http://www.w3.org/2000/01/rdf-schema#label> ?").append("r_typeLabel").append("} . ");
        return sparql.toString();
    }
}

