/**
 * The eagle-i consortium
 * Harvard University
 * Nov 4, 2010
 */
package org.eaglei.datatools.provider;

import java.util.List;
import java.util.Map;

import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;
import org.eaglei.security.Session;

/**
 * @author Daniela Bourges-Waldegg
 * 
 */
public interface CrudProvider {
	/*
	 * CRUD
	 */

	public static final EIEntity DEFAULT_WORKSPACE_ENTITY = EIEntity.create( "http://eagle-i.org/ont/repo/1.0/NG_DefaultWorkspace", "Default Workspace of resource descriptions" );

	public List<EIURI> getNewInstanceID(Session session, int count) throws Exception;

	public EIInstance getEmptyEIInstance(Session session, EIURI classUri, EIEntity instanceEntity) throws Exception;

	public EIInstance getEmptyEIInstance(Session session, EIURI classUri) throws Exception;

	public String getToken(Session session, EIInstance instance) throws Exception;;

	public Map<EIInstance, String> getTokens(Session session, List<EIInstance> instances) throws Exception;;

	public void updateInstance(Session session, EIInstance instance, String token) throws Exception;

	public void updateInstances(Session session, Map<EIInstance, String> instancesWithTokens) throws Exception;

	public void createInstance(Session session, EIInstance instance, EIEntity workspaceEntity) throws Exception;;

	public void createInstances(Session session, List<EIInstance> instances, EIEntity workspaceEntity) throws Exception;;

	public EIInstance deepCopy(Session session, EIURI originalUri) throws Exception;

	public void deleteInstance(Session session, EIURI instanceUri) throws Exception;
	
	public void deleteInstances(Session session, List<EIURI> instanceUris) throws Exception;
	
	public Map<EIURI, String> getModifiedDates(Session session, List<EIURI> uris) throws Exception;
}
