/**
 * The eagle-i consortium
 * Harvard University
 * Nov 4, 2010
 */
package org.eaglei.datatools.provider;

import java.util.List;

import org.eaglei.model.EIInstanceMinimal;
import org.eaglei.model.EIURI;
import org.eaglei.security.Session;

/**
 * @author Daniela Bourges-Waldegg
 * 
 */
public interface QueryProvider {
	/*
	 * Query Should favor EIQuery over the specific methods
	 */
	public List<EIInstanceMinimal> EIQuery(Session session, String sparql) throws Exception;

	public List<EIInstanceMinimal> listResourcesForObjectPropertyValue(final Session session, final EIURI classUri, final EIURI lab, final EIURI state, final boolean onlyLab) throws Exception;
		
	public String retrieveLabel(Session session, EIURI uri) throws Exception;

	/*
	 * free-form SPARQL query to this provider
	 */
	public String query(Session session, String sparql) throws Exception;
}
