/**
 * The eagle-i consortium
 * Harvard University
 * Dec 6, 2010
 */
package org.eaglei.datatools;
import static org.eaglei.datatools.jena.SPARQLConstants.*;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @author Daniela Bourges-Waldegg
 *
 */
public enum SortByProperties implements Serializable{
	label(LABEL_VARIABLE, "Resource Name", "name"), type(TYPE_LABEL_VARIABLE, "Type", "type"), date(CREATION_DATE_VARIABLE, "Date Added", "date"), status(STATE_LABEL_VARIABLE, "Status", "status");

	private String variable;
	private String parameterName;
	private String colName;
	private boolean ascending = true;
	private SortByProperties(String variable, String colName, String name) {
		this.variable = variable;
		this.colName = colName;
		this.parameterName = name;
	}
	public String getVariable() {
		return this.variable;
	}
	
	public String getColumnName() {
		return this.colName;
	}
	public String getParameterName() {
		return this.parameterName;
	}
	
	public void setAscending(boolean ascending) {
		this.ascending = ascending;
	}
	
	public boolean isAScending() {
		return this.ascending;
	}
	
	public static SortByProperties getOrderBy(String parameterName) {
		for( SortByProperties property : SortByProperties.values()) {
			if(property.getParameterName().equals(parameterName)) {
				return property;
			}
		}
		return null;
	}
	
	public static String[] getColumnNames() {
		List<String> colNames = new ArrayList<String>(SortByProperties.values().length);
		for( SortByProperties orderBy : SortByProperties.values()) {
			colNames.add( orderBy.getColumnName() );
		}
		return colNames.toArray(new String[colNames.size()]);
	}
	
}
