/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eaglei.datatools.WorkFlowTransition;
import org.eaglei.datatools.Workspace;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;
import org.eaglei.security.Session;

public class User
implements Serializable {
    private static final long serialVersionUID = 1L;
    private EIEntity userEntity;
    private Session session;
    private List<Workspace> workspaces;
    private List<WorkFlowTransition> allowedTransitions;
    private Map<EIURI, List<WorkFlowTransition>> workflowStateToAllowedTransitions;
    private static final EIURI DRAFT_URI = EIURI.create((String)"http://eagle-i.org/ont/repo/1.0/WFS_Draft");

    public User(String userName, EIURI userURI, List<WorkFlowTransition> allowedTransitions, List<Workspace> workspaces) {
        this.userEntity = EIEntity.create((EIURI)userURI, (String)userName);
        this.allowedTransitions = allowedTransitions;
        this.workflowStateToAllowedTransitions = this.fillMapWithList(allowedTransitions);
        this.workspaces = workspaces;
    }

    public User(String userName, EIURI userURI, List<WorkFlowTransition> allowedTransitions, List<Workspace> workspaces, Session session) {
        this(userName, userURI, allowedTransitions, workspaces);
        this.session = session;
    }

    private Map<EIURI, List<WorkFlowTransition>> fillMapWithList(List<WorkFlowTransition> allowedTransitions) {
        HashMap<EIURI, List<WorkFlowTransition>> mapToReturn = new HashMap<EIURI, List<WorkFlowTransition>>();
        for (WorkFlowTransition transition : allowedTransitions) {
            List<WorkFlowTransition> list;
            if (mapToReturn.get(transition.getFromStateURI()) != null) {
                list = (List)mapToReturn.get(transition.getFromStateURI());
                list.add(transition);
                continue;
            }
            list = new ArrayList<WorkFlowTransition>();
            list.add(transition);
            mapToReturn.put(transition.getFromStateURI(), list);
        }
        return mapToReturn;
    }

    private User() {
    }

    public String getUserName() {
        return this.userEntity.getLabel();
    }

    public EIURI getUserURI() {
        return this.userEntity.getURI();
    }

    public EIEntity getUserEntity() {
        return this.userEntity;
    }

    public List<Workspace> getWorkspaces() {
        return this.workspaces;
    }

    public List<WorkFlowTransition> getAllowedTransitions() {
        return this.allowedTransitions;
    }

    public Map<EIURI, List<WorkFlowTransition>> getMapOfFromStateToWorkFlowTransitions() {
        return this.workflowStateToAllowedTransitions;
    }

    public List<WorkFlowTransition> getAllowedTransitionsForState(EIURI wfStateUri) {
        return this.workflowStateToAllowedTransitions.get(wfStateUri);
    }

    public boolean canEdit(EIURI wfStateUri) {
        List<WorkFlowTransition> transitions = this.workflowStateToAllowedTransitions.get(wfStateUri);
        return transitions != null && transitions.size() != 0;
    }

    public Session getSession() {
        return this.session;
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof User) {
            User other = (User)o;
            return other.getUserEntity().equals((Object)this.getUserEntity());
        }
        return false;
    }

    public int hashCode() {
        return this.getUserEntity().hashCode();
    }
}

