package org.eaglei.datatools.jena;

import java.util.regex.Pattern;

import org.apache.commons.httpclient.methods.PostMethod;
import org.eaglei.model.jena.JenaEIInstanceFactory;
import org.eaglei.security.Session;
import org.eaglei.services.repository.AbstractRepositoryProvider;
import org.eaglei.services.repository.ProviderUtils;
import org.eaglei.services.repository.SecurityProvider;

import org.eaglei.services.repository.RepositoryProviderException;

import com.hp.hpl.jena.query.ResultSetFactory;

public class DataManagmentProvider extends AbstractRepositoryProvider {

	private final JenaEIInstanceFactory instanceFactory;

	private final FooRepositorySecurityProvider securityProvider;
	private final String[] graphString = new String[] { DatatoolsMetadataConstants.DatatoolsPublished, DatatoolsMetadataConstants.DatatoolsWithdrawn, DatatoolsMetadataConstants.DatatoolsMetadataWorkspace };

	public DataManagmentProvider(final JenaEIInstanceFactory instanceFactory, final SecurityProvider generalSecurityProvider) {
		this.instanceFactory = instanceFactory;
		securityProvider = new FooRepositorySecurityProvider( generalSecurityProvider );
	}

	public void replaceResource(Session session, String addNewObjectQuery, String deleteOldObjectQuery) throws RepositoryProviderException {

		for (String namedGraph : graphString) {
			String addTripleGraphContent = queryOnlyDataGraphsWithInferredFalse( session, addNewObjectQuery, namedGraph );
			addNewTripleToGraph( session, addTripleGraphContent, namedGraph );
			String removeTripleGraphContent = queryOnlyDataGraphsWithInferredFalse( session, deleteOldObjectQuery, namedGraph );
			deleteOldTripleFromGraph( session, removeTripleGraphContent, namedGraph );
		}

	}

	public void replaceResourceByRegex(Session session, String constructQryByRegex, String regex, String replaceRegex) throws RepositoryProviderException {
		for (String namedGraph : graphString) {
			String addTripleGraphContent = queryOnlyDataGraphsWithInferredFalse( session, constructQryByRegex, namedGraph );
			String regexReplacedGraph = doRegexOperationOnGraph( addTripleGraphContent, regex, replaceRegex );
			addNewTripleToGraph( session, regexReplacedGraph, namedGraph );
			String removeTripleGraphContent = queryOnlyDataGraphsWithInferredFalse( session, constructQryByRegex, namedGraph );
			deleteOldTripleFromGraph( session, removeTripleGraphContent, namedGraph );
		}
	}

	private String doRegexOperationOnGraph(final String graphContent, final String regex, final String replaceRegex) {
		java.util.regex.Pattern instancePattern = java.util.regex.Pattern.compile( regex, Pattern.CASE_INSENSITIVE );
		java.util.regex.Matcher match = instancePattern.matcher( graphContent );
		String resultGraph = match.replaceAll( replaceRegex );
		return resultGraph;
	}

	public void deleteTriple(Session session, String deleteTripleQuery) throws RepositoryProviderException {
		for (String namedGraph : graphString) {
			String removeTripleGraphContent = queryOnlyDataGraphsWithInferredFalse( session, deleteTripleQuery, namedGraph );
			deleteOldTripleFromGraph( session, removeTripleGraphContent, namedGraph );
		}

	}

	private void addNewTripleToGraph(Session session, String graphContent, String namedGraph) throws RepositoryProviderException {
		log.info( "in adding new triple To graph method " );
		final PostMethod method = getGraphMetod( graphContent, namedGraph );
		method.setParameter( "action", "add" );
		ProviderUtils.getHttpResponse( securityProvider.getHttpClient( session ), method );
		log.info( "added content to graph" );

	}

	private void deleteOldTripleFromGraph(Session session, String graphContent, String namedGraph) throws RepositoryProviderException {
		log.info( "deleting old triple from graph method " );
		final PostMethod method = getGraphMetod( graphContent, namedGraph );
		method.setParameter( "action", "delete" );
		ProviderUtils.getHttpResponse( securityProvider.getHttpClient( session ), method );
		log.info( "added content to graph" );
	}

	private PostMethod getGraphMetod(String garphContent, String namedGraph) {
		final PostMethod method = new PostMethod( RestCommands.Graph.getURL() );
		method.setParameter( "format", "text/plain" );
		method.setParameter( "name", namedGraph );
		method.setParameter( "content", garphContent );
		return method;
	}

	public String queryOnlyDataGraphsWithInferredFalse(Session session, String query, String namedGraph) throws RepositoryProviderException {
		log.info( "in addToGraph method " );
		final PostMethod method = new PostMethod( RestCommands.Query.getURL() );
		method.setParameter( "format", "text/plain" );
		method.setParameter( "default-graph-uri", namedGraph );
		method.setParameter( "query", query );
		method.setParameter( "inferred", "false" );
		log.info( "added content to graph" );
		return ProviderUtils.getHttpResponse( securityProvider.getHttpClient( session ), method );

	}

}
