/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.impl;

import com.hp.hpl.jena.db.impl.SpecializedGraph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Node_URI;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.server.UID;

public abstract class DBProp {
    protected SpecializedGraph graph = null;
    protected Node self = null;

    public DBProp(SpecializedGraph g) {
        this.graph = g;
        this.self = DBProp.generateNodeURI();
    }

    public DBProp(SpecializedGraph g, Node n) {
        this.graph = g;
        this.self = n;
    }

    public Node getNode() {
        return this.self;
    }

    protected static SpecializedGraph.CompletionFlag newComplete() {
        return new SpecializedGraph.CompletionFlag();
    }

    protected void putPropString(Node_URI predicate, String value) {
        this.putPropNode(predicate, Node.createLiteral(value));
    }

    protected void putPropNode(Node_URI predicate, Node node) {
        this.graph.add(Triple.create(this.self, predicate, node), DBProp.newComplete());
    }

    protected String getPropString(Node predicate) {
        Node n = this.getPropNode(predicate);
        return n == null ? null : n.getLiteralLexicalForm();
    }

    protected Node getPropNode(Node subject, Node predicate) {
        ExtendedIterator<Triple> it = this.graph.find(subject, predicate, Node.ANY, DBProp.newComplete());
        Node result = it.hasNext() ? ((Triple)it.next()).getObject() : null;
        it.close();
        return result;
    }

    protected Node getPropNode(Node predicate) {
        return this.getPropNode(this.self, predicate);
    }

    protected void remove() {
        SpecializedGraph.CompletionFlag complete = DBProp.newComplete();
        ExtendedIterator<Triple> it = this.graph.find(this.self, null, null, complete);
        while (it.hasNext()) {
            this.graph.delete((Triple)it.next(), complete);
        }
        it.close();
        this.self = null;
        this.graph = null;
    }

    void showGraph() {
        SpecializedGraph.CompletionFlag complete = DBProp.newComplete();
        ExtendedIterator<Triple> it = this.graph.find(this.self, null, null, complete);
        while (it.hasNext()) {
            System.err.println(">> " + it.next());
        }
    }

    public static ExtendedIterator<Triple> listTriples(SpecializedGraph g, Node self) {
        return g.find(self, null, null, DBProp.newComplete());
    }

    public static String generateUniqueID() {
        String hostname;
        UID uid = new UID();
        try {
            hostname = InetAddress.getLocalHost().getHostAddress().toString();
        }
        catch (UnknownHostException e) {
            hostname = "localhost";
        }
        return (hostname + uid.toString()).replace('.', '_').replace(':', '_').replace('-', '_');
    }

    public static Node generateNodeURI() {
        Object generateUniqueID = null;
        return Node.createURI("http://jena.hpl.hp.com/2003/04/DB#" + DBProp.generateUniqueID());
    }
}

