/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.impl;

import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.db.RDFRDBException;
import com.hp.hpl.jena.db.impl.DBPropGraph;
import com.hp.hpl.jena.db.impl.SpecializedGraph;
import com.hp.hpl.jena.db.impl.VarDesc;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import java.util.List;

public interface IRDBDriver {
    public void setConnection(IDBConnection var1);

    public IDBConnection getConnection();

    public SpecializedGraph getSystemSpecializedGraph(boolean var1);

    public List<SpecializedGraph> createSpecializedGraphs(String var1, Graph var2);

    public List<SpecializedGraph> recreateSpecializedGraphs(DBPropGraph var1);

    public void removeSpecializedGraphs(DBPropGraph var1, List<SpecializedGraph> var2);

    public boolean isDBFormatOK();

    public void setDatabaseProperties(Graph var1);

    public DBPropGraph getDefaultModelProperties();

    public String getDatabaseType();

    public void cleanDB();

    public void close() throws RDFRDBException;

    public void lockDB() throws RDFRDBException;

    public void unlockDB() throws RDFRDBException;

    public boolean tryLockDB() throws RDFRDBException;

    public boolean DBisLocked() throws RDFRDBException;

    public String createTable(int var1, boolean var2);

    public void deleteTable(String var1);

    public void abort() throws RDFRDBException;

    public void begin() throws RDFRDBException;

    public void commit() throws RDFRDBException;

    public boolean transactionsSupported();

    public int graphIdAlloc(String var1);

    public void graphIdDealloc(int var1);

    public int getInsertID(String var1);

    public String nodeToRDBString(Node var1, boolean var2);

    public Node RDBStringToNode(String var1);

    public String genSQLReifQualStmt();

    public String genSQLReifQualAnyObj(boolean var1);

    public String genSQLReifQualObj(char var1, boolean var2);

    public String genSQLQualConst(int var1, char var2, Node var3);

    public String genSQLReifQualConst(int var1, char var2, Node var3);

    public String genSQLQualParam(int var1, char var2);

    public String genSQLQualGraphId(int var1, int var2);

    public String genSQLStringMatch(int var1, char var2, String var3, String var4);

    public String genSQLStringMatchLHS(boolean var1, String var2);

    public String genSQLStringMatchLHS_IC(String var1);

    public String genSQLStringMatchOp(boolean var1, String var2);

    public String stringMatchAllChar();

    public String stringMatchEscapeChar();

    public String genSQLStringMatchRHS(boolean var1, boolean var2, String var3);

    public String genSQLStringMatchRHS_IC(String var1);

    public String genSQLStringMatchOp(String var1);

    public String genSQLStringMatchOp_IC(String var1);

    public boolean stringMatchNeedsEscape(String var1);

    public String addEscape(String var1);

    public String genSQLStringMatchEscape();

    public String genSQLLikeKW();

    public String genSQLEscapeKW();

    public String genSQLJoin(int var1, char var2, int var3, char var4);

    public String genSQLResList(int[] var1, VarDesc[] var2);

    public String genSQLFromList(int var1, String var2);

    public String genSQLSelectStmt(String var1, String var2, String var3);

    public int getLongObjectLengthMax();

    public int getLongObjectLength();

    public void setLongObjectLength(int var1);

    public int getIndexKeyLengthMax();

    public int getIndexKeyLength();

    public void setIndexKeyLength(int var1);

    public boolean getIsTransactionDb();

    public void setIsTransactionDb(boolean var1);

    public boolean getDoCompressURI();

    public void setDoCompressURI(boolean var1);

    public int getCompressURILength();

    public void setCompressURILength(int var1);

    public boolean getDoDuplicateCheck();

    public void setDoDuplicateCheck(boolean var1);

    public String getTableNamePrefix();

    public void setTableNamePrefix(String var1);

    public String getStoreWithModel();

    public void setStoreWithModel(String var1);

    public int getCompressCacheSize();

    public void setCompressCacheSize(int var1);

    public int getSystemTableCount();

    public String getSystemTableName(int var1);

    public static class GenSQLAnd {
        private boolean init = false;

        GenSQLAnd() {
        }

        String gen(String qual) {
            if (qual == "") {
                return "";
            }
            if (!this.init) {
                this.init = true;
                return qual;
            }
            return " AND " + qual;
        }
    }
}

