/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model;

import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.assembler.AssemblerHelp;
import com.hp.hpl.jena.db.DBConnection;
import com.hp.hpl.jena.db.GraphRDB;
import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.db.ModelRDB;
import com.hp.hpl.jena.db.impl.GraphRDBMaker;
import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.compose.Union;
import com.hp.hpl.jena.graph.impl.FileGraphMaker;
import com.hp.hpl.jena.graph.impl.SimpleGraphMaker;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.ProfileRegistry;
import com.hp.hpl.jena.ontology.impl.OntModelImpl;
import com.hp.hpl.jena.rdf.model.InfModel;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactoryBase;
import com.hp.hpl.jena.rdf.model.ModelMaker;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.impl.InfModelImpl;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import com.hp.hpl.jena.rdf.model.impl.ModelMakerImpl;
import com.hp.hpl.jena.rdf.model.impl.ModelReifier;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerRegistry;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.ReificationStyle;
import java.util.Set;

public class ModelFactory
extends ModelFactoryBase {
    public static final ReificationStyle Standard = ReificationStyle.Standard;
    public static final ReificationStyle Convenient = ReificationStyle.Convenient;
    public static final ReificationStyle Minimal = ReificationStyle.Minimal;

    private ModelFactory() {
    }

    public static PrefixMapping setDefaultModelPrefixes(PrefixMapping pm) {
        return ModelCom.setDefaultModelPrefixes(pm);
    }

    public static PrefixMapping getDefaultModelPrefixes() {
        return ModelCom.getDefaultModelPrefixes();
    }

    public static Model assembleModelFrom(Model singleRoot) {
        return ModelFactory.assembleModelFrom(AssemblerHelp.singleModelRoot(singleRoot));
    }

    public static Set<Resource> findAssemblerRoots(Model m) {
        return AssemblerHelp.findAssemblerRoots(m);
    }

    public static Model assembleModelFrom(Resource root) {
        return Assembler.general.openModel(root);
    }

    public static Model createDefaultModel() {
        return ModelFactory.createDefaultModel(Standard);
    }

    public static Model createDefaultModel(ReificationStyle style) {
        return new ModelCom(Factory.createGraphMem(style));
    }

    public static Model withHiddenStatements(Model m) {
        return ModelReifier.withHiddenStatements(m);
    }

    public static Model createNonreifyingModel() {
        return ModelFactory.createDefaultModel(Minimal);
    }

    public static Model createModelForGraph(Graph g) {
        return new ModelCom(g);
    }

    public static ModelMaker createFileModelMaker(String root) {
        return ModelFactory.createFileModelMaker(root, Standard);
    }

    public static ModelMaker createFileModelMaker(String root, ReificationStyle style) {
        return new ModelMakerImpl(new FileGraphMaker(root, style));
    }

    public static ModelMaker createMemModelMaker() {
        return ModelFactory.createMemModelMaker(Standard);
    }

    public static ModelMaker createMemModelMaker(ReificationStyle style) {
        return new ModelMakerImpl(new SimpleGraphMaker(style));
    }

    public static ModelMaker createModelRDBMaker(IDBConnection c) {
        return ModelFactory.createModelRDBMaker(c, Standard);
    }

    public static ModelMaker createModelRDBMaker(IDBConnection c, ReificationStyle style) {
        return new ModelRDBMaker(new GraphRDBMaker(c, style));
    }

    public static IDBConnection createSimpleRDBConnection(String url, String user, String password, String dbType) {
        return new DBConnection(url, user, password, dbType);
    }

    public static IDBConnection createSimpleRDBConnection() {
        return ModelFactory.createSimpleRDBConnection(ModelFactory.guessDBURL(), ModelFactory.guessDBUser(), ModelFactory.guessDBPassword(), ModelFactory.guessDBType());
    }

    public static InfModel createRDFSModel(Model model) {
        Reasoner reasoner = ReasonerRegistry.getRDFSReasoner();
        InfGraph graph = reasoner.bind(model.getGraph());
        return new InfModelImpl(graph);
    }

    public static InfModel createRDFSModel(Model schema, Model model) {
        Reasoner reasoner = ReasonerRegistry.getRDFSReasoner();
        InfGraph graph = reasoner.bindSchema(schema.getGraph()).bind(model.getGraph());
        return new InfModelImpl(graph);
    }

    public static InfModel createInfModel(Reasoner reasoner, Model model) {
        InfGraph graph = reasoner.bind(model.getGraph());
        return new InfModelImpl(graph);
    }

    public static InfModel createInfModel(Reasoner reasoner, Model schema, Model model) {
        InfGraph graph = reasoner.bindSchema(schema.getGraph()).bind(model.getGraph());
        return new InfModelImpl(graph);
    }

    public static InfModel createInfModel(InfGraph g) {
        return new InfModelImpl(g);
    }

    public static OntModel createOntologyModel() {
        return ModelFactory.createOntologyModel(ProfileRegistry.OWL_LANG);
    }

    public static OntModel createOntologyModel(String languageURI) {
        return ModelFactory.createOntologyModel(OntModelSpec.getDefaultSpec(languageURI), null);
    }

    public static OntModel createOntologyModel(OntModelSpec spec, ModelMaker maker, Model base) {
        OntModelSpec _spec = new OntModelSpec(spec);
        _spec.setImportModelMaker(maker);
        return ModelFactory.createOntologyModel(_spec, base);
    }

    public static OntModel createOntologyModel(OntModelSpec spec, Model base) {
        return new OntModelImpl(spec, base);
    }

    public static OntModel createOntologyModel(OntModelSpec spec) {
        return new OntModelImpl(spec);
    }

    public static Model createUnion(Model m1, Model m2) {
        return ModelFactory.createModelForGraph(new Union(m1.getGraph(), m2.getGraph()));
    }

    static class ModelRDBMaker
    extends ModelMakerImpl
    implements ModelMaker {
        public ModelRDBMaker(GraphRDBMaker gm) {
            super(gm);
        }

        @Override
        public Model makeModel(Graph graphRDB) {
            return new ModelRDB((GraphRDB)graphRDB);
        }
    }
}

