/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.jena;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.datatools.User;
import org.eaglei.datatools.WorkFlowTransition;
import org.eaglei.datatools.Workspace;
import org.eaglei.datatools.config.DatatoolsConfiguration;
import org.eaglei.datatools.provider.DatatoolsSecurityProvider;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;
import org.eaglei.security.Session;
import org.eaglei.services.repository.AbstractRepositoryProvider;
import org.eaglei.services.repository.RepositoryProviderException;
import org.eaglei.services.repository.SecurityProvider;

public class FooRepositorySecurityProvider
extends AbstractRepositoryProvider
implements DatatoolsSecurityProvider {
    private static final Log log = LogFactory.getLog(FooRepositorySecurityProvider.class);
    private SecurityProvider securityProvider;

    public FooRepositorySecurityProvider(SecurityProvider generalSecurityProvider) {
        this.securityProvider = generalSecurityProvider;
        try {
            DatatoolsConfiguration config = this.getConfiguration(null);
            DEFAULT_REPOSITORY_URL = config.getDatatoolsRepositoryURL();
            DEFAULT_REPOSITORY_URI = config.getDatatoolsRepositoryURI();
        }
        catch (RepositoryProviderException e) {
            throw new RuntimeException("Error generating Datatools client configuration", e);
        }
    }

    @Override
    public User login(String userName, String password) throws RepositoryProviderException {
        Session session = this.securityProvider.logIn(DEFAULT_REPOSITORY_URI, userName, password);
        return this.getUserInformation(session);
    }

    @Override
    public void logout(Session session) throws RepositoryProviderException {
        this.securityProvider.logOut(session.getSessionId());
    }

    @Override
    public boolean isOnline() {
        return this.securityProvider.isOnline(DEFAULT_REPOSITORY_URI);
    }

    @Override
    public List<Workspace> getWorkspaces(Session session) throws RepositoryProviderException {
        List workspaceMapList = this.securityProvider.getWorkspaces(DEFAULT_REPOSITORY_URI, session.getSessionId());
        ArrayList<Workspace> workspaceList = new ArrayList<Workspace>(workspaceMapList.size());
        for (HashMap workspaceMap : workspaceMapList) {
            String workspaceName = (String)workspaceMap.get("namedGraphLabel");
            String workspaceURI = (String)workspaceMap.get("namedGraphURI");
            String typeURI = (String)workspaceMap.get("typeURI");
            boolean canUserAdd = Boolean.valueOf((String)workspaceMap.get("add"));
            boolean canUserDelete = Boolean.valueOf((String)workspaceMap.get("remove"));
            Workspace newWorkspace = new Workspace(workspaceName, EIURI.create((String)workspaceURI), EIURI.create((String)typeURI), canUserAdd, canUserDelete);
            workspaceList.add(newWorkspace);
        }
        return workspaceList;
    }

    public DatatoolsConfiguration getConfiguration(String propFile) throws RepositoryProviderException {
        if (propFile == null && (propFile = System.getProperty("datatools.config.file")) == null) {
            propFile = "datatools.prop";
        }
        log.debug((Object)("Using properties file " + propFile));
        URL configURL = this.getClass().getClassLoader().getResource(propFile);
        if (configURL == null) {
            log.error((Object)("Could not locate " + propFile + " on classpath "));
            throw new RepositoryProviderException("Unable to locate property configuration file.");
        }
        try {
            File configFile = new File(configURL.toURI());
            return new DatatoolsConfiguration(configFile);
        }
        catch (IOException e) {
            log.error((Object)("Error loading configuration from " + configURL + " " + e));
            throw new RepositoryProviderException("IO Error loading configuration property file.", (Throwable)e);
        }
        catch (URISyntaxException e) {
            log.error((Object)("Error getting name of configuration file: " + configURL + " " + e));
            throw new RepositoryProviderException("Error parsing URI for configuration file.", (Throwable)e);
        }
    }

    private User getUserInformation(Session session) throws RepositoryProviderException {
        List<Object> states = new ArrayList();
        states = this.listWorkFlowTransitions(session, null);
        log.info((Object)("has number of wfsStates " + states.size()));
        List<Workspace> workspaceList = Collections.emptyList();
        return new User(session.getUserName(), EIURI.create((String)session.getUserURI()), states, workspaceList, session);
    }

    public void setDefaultRepositoryURL(String repoURL) {
        DEFAULT_REPOSITORY_URL = repoURL;
    }

    public void setDefaultRepositoryURI(String repoURI) {
        DEFAULT_REPOSITORY_URI = repoURI;
    }

    @Override
    public List<WorkFlowTransition> listWorkFlowTransitions(Session session, EIEntity workspaceEntity) throws RepositoryProviderException {
        List workFlowTransitionMapList = this.securityProvider.listWorkFlowTransitions(DEFAULT_REPOSITORY_URI, session.getSessionId(), workspaceEntity);
        ArrayList<WorkFlowTransition> transitionList = new ArrayList<WorkFlowTransition>(workFlowTransitionMapList.size());
        for (HashMap workFlowTransitionMap : workFlowTransitionMapList) {
            EIEntity transitionEntity = (EIEntity)workFlowTransitionMap.get("subject");
            EIEntity fromStateEntity = (EIEntity)workFlowTransitionMap.get("initial");
            EIEntity toStateEntity = (EIEntity)workFlowTransitionMap.get("final");
            WorkFlowTransition workFlowTransition = new WorkFlowTransition(transitionEntity, fromStateEntity, toStateEntity, true);
            transitionList.add(workFlowTransition);
        }
        log.info((Object)(transitionList.size() + " transitions were returned"));
        return transitionList;
    }

    @Override
    public User whoami(Session session) throws RepositoryProviderException {
        Session newSession = this.securityProvider.whoami(session.getSessionId());
        return this.getUserInformation(newSession);
    }

    public boolean isValid(String sessionId, boolean shouldThrow) throws RepositoryProviderException {
        return this.securityProvider.isValid(sessionId, shouldThrow);
    }

    public Session getSession(String sessionId) {
        return this.securityProvider.getSession(sessionId);
    }

    public HttpClient getHttpClient(Session session) {
        return this.securityProvider.getHttpClient(session);
    }
}

