package org.eaglei.datatools.provider;

import java.util.List;

import org.eaglei.datatools.jena.BulkCurationTriple;
import org.eaglei.model.EIInstanceMinimal;
import org.eaglei.model.EIURI;
import org.eaglei.security.Session;
import org.eaglei.services.repository.RepositoryProviderException;

public interface DataManagmentService {

	// TODO:way too many arguments need to minimize the args
	public List<BulkCurationTriple> getResourcesToRepair(Session session, EIURI typeURI, EIURI predicateURI, String objectString, Boolean isObjectLiteral) throws RepositoryProviderException;

	public List<BulkCurationTriple> getResourcesToRepairByRegex(Session session, EIURI typeURI, EIURI predicateURI, String regex) throws RepositoryProviderException;

	public Integer replaceObject(Session session, EIURI typeURI, EIURI predicateURI, String oldObjectString, Boolean isOldObjectLiteral, String newObjectString, Boolean isNewObjectLiteral) throws RepositoryProviderException;

	public Integer replacePredicate(Session session, EIURI typeURI, EIURI oldPredicateURI, EIURI newPredicateURI, String objectString, Boolean isObjectLiteral) throws RepositoryProviderException;

	// FIX:really too many args
	public Integer replaceObjectAndPredicate(Session session, EIURI typeURI, EIURI oldPredicateURI, EIURI newPredicateURI, String oldObjectString, Boolean isOldObjectLiteral, String newObjectString, Boolean isNewObjectLiteral) throws RepositoryProviderException;

	public Integer replaceObjectByRegex(Session session, EIURI typeURI, EIURI predicateURI, String regex, String replaceRegex) throws RepositoryProviderException;

	public Integer deleteTriple(Session session, EIURI typeURI, EIURI predicateURI, String objectString, Boolean isObjectLiteral) throws RepositoryProviderException;

	public Integer addTriple(Session session, EIURI typeURI, EIURI oldPredicateURI, EIURI newPredicateURI, String oldObjectString, Boolean isOldObjectLiteral, String newObjectString, Boolean isNewObjectLiteral) throws RepositoryProviderException;
}
