/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.jena;

import java.text.StringCharacterIterator;
import java.util.Arrays;
import java.util.List;
import org.eaglei.datatools.jena.QueryBuilder;
import org.eaglei.model.EIURI;

public class BulkCurationQueryBuilder
implements QueryBuilder {
    private static BulkCurationQueryBuilder queryBuilder;

    public static QueryBuilder getInstance() {
        if (queryBuilder == null) {
            queryBuilder = new BulkCurationQueryBuilder();
            return queryBuilder;
        }
        return queryBuilder;
    }

    private BulkCurationQueryBuilder() {
    }

    @Override
    public String diagnoseQuery(EIURI typeURI, EIURI predicateURI, String objectString, QueryBuilder.RDFobjectType objectType, String graph) {
        StringBuilder sparql = this.selectClauseWithPrefix();
        if (!this.isAllOption(typeURI)) {
            sparql.append(this.subjectTypeClause(typeURI));
        }
        sparql.append(" graph ?g{");
        sparql.append(this.typeAndLabelTriplePatterns());
        sparql.append(this.tripleForWhereCondition(predicateURI, objectString, objectType));
        sparql.append("}  filter(?g = <").append(graph).append(">) . ");
        if (this.isAllOption(typeURI)) {
            sparql.append(this.typeLabelTriple());
        }
        if (this.isAllOption(predicateURI)) {
            sparql.append(this.predicateLabelTriple());
        }
        if (this.isAllOptionObject(objectString)) {
            sparql.append(this.objectLabelTriple());
        }
        sparql.append("}");
        return sparql.toString();
    }

    @Override
    public String diagnoseQueryByRegex(EIURI typeURI, EIURI predicateURI, String regex, String graph) {
        StringBuilder sparql = this.selectClauseWithPrefix();
        if (!this.isAllOption(typeURI)) {
            sparql.append(this.subjectTypeClause(typeURI));
        }
        sparql.append(" graph ?g{");
        sparql.append(this.typeAndLabelTriplePatterns());
        sparql.append(this.tripleForWhereConditionWhenRegex(predicateURI, regex));
        sparql.append("}  filter(?g = <").append(graph).append(">) . ");
        if (this.isAllOption(typeURI)) {
            sparql.append(this.typeLabelTriple());
        }
        if (this.isAllOption(predicateURI)) {
            sparql.append(this.predicateLabelTriple());
        }
        sparql.append("}");
        return sparql.toString();
    }

    @Override
    public String diagnoseQueryByRegexForMetadata(EIURI predicateURI, String regex, String graph) {
        StringBuilder sparql = this.selectClauseWithPrefix();
        sparql.append(" graph ?gt{");
        sparql.append(" ?").append("r_subject").append(" a ?").append("r_type").append(". ");
        sparql.append("}  filter(?gt != <").append("http://eagle-i.org/ont/repo/1.0/NG_Inferred").append(">) . ");
        sparql.append(" ?").append("r_subject").append(" <http://www.w3.org/2000/01/rdf-schema#label> ?").append("r_label").append(". ");
        sparql.append(" graph ?g{");
        sparql.append(this.tripleForWhereConditionWhenRegex(predicateURI, regex));
        sparql.append("}  filter(?g = <").append(graph).append(">) . ");
        sparql.append(this.typeLabelTriple());
        if (this.isAllOption(predicateURI)) {
            sparql.append(this.predicateLabelTriple());
        }
        sparql.append("}");
        return sparql.toString();
    }

    @Override
    public String getQueryToDeleteTriplesByRegexForMetadata(EIURI predicateURI, String regex, String graph) {
        StringBuilder sparql = new StringBuilder();
        sparql.append(this.constructClause(predicateURI));
        sparql.append(this.whereString());
        sparql.append(this.graphClause(predicateURI, regex, graph));
        sparql.append("}");
        return sparql.toString();
    }

    private String predicateLabelTriple() {
        StringBuilder sparql = new StringBuilder();
        sparql.append(" optional{?").append("any_predicate").append(" <http://www.w3.org/2000/01/rdf-schema#label> ?").append("any_predicateLabel").append("}. ");
        return sparql.toString();
    }

    private String objectLabelTriple() {
        StringBuilder sparql = new StringBuilder();
        sparql.append(" optional{?").append("r_object").append(" <http://www.w3.org/2000/01/rdf-schema#label> ?").append("r_objectLabel").append("}. ");
        return sparql.toString();
    }

    private String typeLabelTriple() {
        StringBuilder sparql = new StringBuilder();
        sparql.append(" optional{?").append("r_type").append(" <http://www.w3.org/2000/01/rdf-schema#label> ?").append("r_typeLabel").append("}. ");
        return sparql.toString();
    }

    private String typeAndLabelTriplePatterns() {
        StringBuilder sparql = new StringBuilder();
        sparql.append(" ?").append("r_subject").append(" a ?").append("r_type").append(". ");
        sparql.append(" ?").append("r_subject").append(" <http://www.w3.org/2000/01/rdf-schema#label> ?").append("r_label").append(". ");
        return sparql.toString();
    }

    @Override
    public String getQueryToAddObject(EIURI typeURI, EIURI predicateURI, String oldObjectString, QueryBuilder.RDFobjectType oldObjectType, String newObjectString, QueryBuilder.RDFobjectType newObjectType, String graph) {
        StringBuilder sparql = new StringBuilder();
        sparql.append(this.constructClause(predicateURI, newObjectString, newObjectType));
        sparql.append(this.whereString());
        if (!this.isAllOption(typeURI)) {
            sparql.append(this.subjectTypeClause(typeURI));
        }
        sparql.append(this.graphClause(predicateURI, oldObjectString, graph, oldObjectType));
        sparql.append("}");
        return sparql.toString();
    }

    private String whereString() {
        return "  where {";
    }

    @Override
    public String getQueryToAddPredicate(EIURI typeURI, EIURI oldPredicateURI, EIURI newPredicateURI, String objectString, QueryBuilder.RDFobjectType objectType, String graph) {
        StringBuilder sparql = new StringBuilder();
        sparql.append(this.constructClause(newPredicateURI, objectString, objectType));
        sparql.append(this.whereString());
        if (!this.isAllOption(typeURI)) {
            sparql.append(this.subjectTypeClause(typeURI));
        }
        sparql.append(this.graphClause(oldPredicateURI, objectString, graph, objectType));
        sparql.append("}");
        return sparql.toString();
    }

    @Override
    public String getQueryToDeleteTriple(EIURI typeURI, EIURI predicateURI, String objectString, QueryBuilder.RDFobjectType objectType, String graph) {
        StringBuilder sparql = new StringBuilder();
        sparql.append(this.constructClause(predicateURI, objectString, objectType));
        sparql.append(this.whereString());
        if (!this.isAllOption(typeURI)) {
            sparql.append(this.subjectTypeClause(typeURI));
        }
        sparql.append(this.graphClause(predicateURI, objectString, graph, objectType));
        sparql.append("}");
        return sparql.toString();
    }

    @Override
    public String getQueryToAddPredicateAndObject(EIURI typeURI, EIURI oldPredicateURI, EIURI newPredicateURI, String oldObjectString, QueryBuilder.RDFobjectType oldObjectType, String newObjectString, QueryBuilder.RDFobjectType newObjectType, String graph) {
        StringBuilder sparql = new StringBuilder();
        sparql.append(this.constructClause(newPredicateURI, newObjectString, newObjectType));
        sparql.append(this.whereString());
        if (!this.isAllOption(typeURI)) {
            sparql.append(this.subjectTypeClause(typeURI));
        }
        sparql.append(this.graphClause(oldPredicateURI, oldObjectString, graph, oldObjectType));
        sparql.append("}");
        return sparql.toString();
    }

    @Override
    public String getConstructQueryByRegex(EIURI typeURI, EIURI predicateURI, String regex, String graph) {
        StringBuilder sparql = new StringBuilder();
        sparql.append(this.constructClause(predicateURI));
        sparql.append(this.whereString());
        if (!this.isAllOption(typeURI)) {
            sparql.append(this.subjectTypeClause(typeURI));
        }
        sparql.append(this.graphClause(predicateURI, regex, graph));
        sparql.append("}");
        return sparql.toString();
    }

    private String constructClause(EIURI predicate, String object, QueryBuilder.RDFobjectType objectType) {
        return "construct \t{?r_subject" + this.getPredicateParameter(predicate) + this.getObjectParameter(object, objectType) + "}";
    }

    private String constructClause(EIURI predicate) {
        return "construct \t{?r_subject" + this.getPredicateParameter(predicate) + "?" + "r_object" + "}";
    }

    private String subjectTypeClause(EIURI typeURI) {
        return "?r_subject a <" + typeURI + "> .";
    }

    private String graphClause(EIURI predicate, String object, String graph, QueryBuilder.RDFobjectType rdfType) {
        return " graph ?g {" + this.tripleForWhereCondition(predicate, object, rdfType) + "}  filter(?g = <" + graph + ">)";
    }

    private String graphClause(EIURI predicate, String regex, String graph) {
        return " graph ?g {" + this.tripleForWhereConditionWhenRegex(predicate, regex) + "}  filter(?g = <" + graph + ">)";
    }

    private String tripleForWhereCondition(EIURI predicate, String object, QueryBuilder.RDFobjectType objectType) {
        return " ?r_subject" + this.getPredicateParameter(predicate) + this.getObjectParameter(object, objectType) + ". ";
    }

    private String tripleForWhereConditionWhenRegex(EIURI predicate, String regex) {
        return " ?r_subject" + this.getPredicateParameter(predicate) + " ?" + "r_object" + " . filter regex(str(?" + "r_object" + "), \"" + BulkCurationQueryBuilder.forRegex(regex) + "\") ";
    }

    public static String forRegex(String aRegexFragment) {
        StringBuilder result = new StringBuilder();
        StringCharacterIterator iterator = new StringCharacterIterator(aRegexFragment);
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == '\\') {
                result.append("\\\\");
            } else {
                result.append(character);
            }
            character = iterator.next();
        }
        return result.toString();
    }

    private StringBuilder selectClauseWithPrefix() {
        StringBuilder sparql = new StringBuilder();
        sparql.append("SELECT ");
        List<String> resultVariables = Arrays.asList("r_subject", "r_type", "r_typeLabel", "r_label", "any_predicate", "any_predicateLabel", "r_object", "r_objectLabel");
        for (String variable : resultVariables) {
            sparql.append("?").append(variable).append(" ");
        }
        sparql.append("WHERE { ");
        return sparql;
    }

    private String getPredicateParameter(EIURI predicate) {
        if (this.isAllOption(predicate)) {
            return " ?any_predicate ";
        }
        return " <" + predicate.toString() + "> ";
    }

    private String getObjectParameter(String object, QueryBuilder.RDFobjectType objectType) {
        if (this.isAllOptionObject(object)) {
            return " ?r_object ";
        }
        if (objectType == QueryBuilder.RDFobjectType.objectIsLiteral) {
            return " \"" + object + "\" ";
        }
        return " <" + object + "> ";
    }

    private boolean isAllOption(EIURI parameter) {
        return parameter == null || EIURI.NULL_EIURI.equals((Object)parameter);
    }

    private boolean isAllOptionObject(String parameter) {
        return parameter == null;
    }

    public String objectLiteralWrappedinSTRfuntion(String objectLiteral) {
        return " str(\"" + objectLiteral + "\") ";
    }

    @Override
    public String getSanityCheckQuery(EIURI type, EIURI predicate, String object, QueryBuilder.RDFobjectType objectType) {
        StringBuilder sparql = new StringBuilder();
        sparql.append("SELECT ?").append("r_subject").append(" where {");
        if (!this.isAllOption(type)) {
            sparql.append(this.subjectTypeClause(type));
        }
        sparql.append("graph ?g{ ?").append("r_subject").append(this.getPredicateParameter(predicate)).append(this.getObjectParameter(object, objectType));
        sparql.append("} filter(?g != <http://eagle-i.org/ont/repo/1.0/NG_Inferred>)}");
        return sparql.toString();
    }
}

