/**
 * The eagle-i consortium
 * Harvard University
 * Apr 7, 2011
 */
package org.eaglei.datatools.jena;

import static org.eaglei.model.jena.SPARQLConstants.*;
import static org.eaglei.model.jena.SPARQLConstants.LABEL_VARIABLE;
import static org.eaglei.model.jena.SPARQLConstants.OBJECT_VARIABLE;
import static org.eaglei.model.jena.SPARQLConstants.SUBJECT_VARIABLE;
import static org.eaglei.model.jena.SPARQLConstants.TYPE_VARIABLE;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;
import org.eaglei.model.jena.SPARQLResultsUtil;

import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;

/**
 * @author Daniela Bourges-Waldegg
 *
 */
public class BulkCurationTripleFactory {


	public static List<BulkCurationTriple> getBulkCurationTriples(ResultSet results) {
		if ( results == null) {
			return Collections.emptyList();
		}
		List<BulkCurationTriple> triples = new ArrayList<BulkCurationTriple>();
		while ( results.hasNext() ) {
			final QuerySolution solution = results.next();
			if ( solution.contains( SUBJECT_VARIABLE ) && solution.contains( LABEL_VARIABLE ) ) {
				final EIEntity resource = SPARQLResultsUtil.getEntityFromSolution( solution, SUBJECT_VARIABLE, LABEL_VARIABLE );
				final EIEntity type = SPARQLResultsUtil.getEntityFromSolution( solution, TYPE_VARIABLE, TYPE_LABEL_VARIABLE);
				final EIEntity predicate = SPARQLResultsUtil.getEntityFromSolution( solution, ANY_PREDICATE_VARIABLE, ANY_PREDICATE_LABEL_VARIABLE );
				String literalObject = null;
				EIEntity resourceObject = EIEntity.NULL_ENTITY;
				if(solution.contains( OBJECT_VARIABLE)) {
					if (solution.get( OBJECT_VARIABLE).isLiteral()) {
						literalObject = SPARQLResultsUtil.getStringFromSolution( solution, OBJECT_VARIABLE );
					} else if (solution.get( OBJECT_VARIABLE ).isResource() ) {
						resourceObject = SPARQLResultsUtil.getEntityFromSolution( solution, OBJECT_VARIABLE, OBJECT_LABEL_VARIABLE );
					}
				}
				if( literalObject != null) {
					triples.add(new BulkCurationTriple(resource, type, predicate, literalObject));
				} else if( resourceObject != EIEntity.NULL_ENTITY) {
					triples.add(new BulkCurationTriple(resource, type, predicate, resourceObject));
				} else {
					triples.add(new BulkCurationTriple(resource, type, predicate));
				}
			}
		}
		return triples;
	}
}
