/**
 * 
 */
package org.eaglei.datatools.jena;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.security.Session;
import org.eaglei.services.repository.ProviderUtils;
import org.eaglei.services.repository.RepositoryProviderException;
import org.eaglei.services.repository.SecurityProvider;

import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;

/**
 * @author "Sravan Cheriyala" Started Apr 8, 2011
 */
public class TriplesCRUDService {
	private SecurityProvider securityProvider;
	private String repositoryURL;
	protected static final Log log = LogFactory.getLog( TriplesCRUDService.class );
	

	// FIXME:after consulting jason for making RestCommands in AbstractRepositoryProvider public ,then i need to remove this
	private enum RestCommands {
		// IMPORTANT logout needs a / at the end
		GetNewInstanceIDs("repository/new"), WhoAmI("repository/whoami"), Logout("repository/logout/"), GetInstance("repository/resource"), UpdateInstance("repository/update"), Query("repository/sparql"), Online(""), Graph("repository/graph"), FakeWorkflow(
				"repository/fakeworkflow"), Listgraphs("repository/listGraphs"), Claim("repository/workflow/claim"), Release("repository/workflow/release"), Transition("repository/workflow/push"), ListTransitions("repository/workflow/transitions"), ListResources(
				"repository/workflow/resources");

		private RestCommands(final String propKey) {
			key = propKey;
		}

		public String getKey() {
			return key;
		}

		private final String key;
	}


	public TriplesCRUDService(SecurityProvider securityProvider, String repositoryURL) {
		this.securityProvider = securityProvider;
		this.repositoryURL = repositoryURL;
	}

	public void addNewTriples(Session session, String tripleContent, String graph) throws RepositoryProviderException {
		if ( log.isDebugEnabled() ) {
			log.debug( "in adding new triple To graph method " );
		}
		final PostMethod method = getGraphHttpMethod( tripleContent, graph );
		method.setParameter( "action", "add" );
		ProviderUtils.getHttpResponse( checkValidSessionAndGetHttpClient( session ), method );
		log.info( "added new content to graph" );

	}

	public void deleteOldTriple(Session session, String tripleContent, String graph) throws RepositoryProviderException {
		if ( log.isDebugEnabled() ) {
			log.debug( "deleting old triple from graph method " );
		}
		final PostMethod method = getGraphHttpMethod( tripleContent, graph );
		method.setParameter( "action", "delete" );
		ProviderUtils.getHttpResponse( checkValidSessionAndGetHttpClient( session ), method );

		log.info( "deleted old content from graph" );
	}

	public String getTriplesToRepair(Session session, String query) throws RepositoryProviderException {

		if ( log.isDebugEnabled() ) {
			log.debug( "in httpRequestToGetTriplesToRepair method " );
		}
		return httpRequestToGetTriples( session, query, "text/plain" );

	}

	public String getTriplesToDisplay(Session session, String query) throws RepositoryProviderException {

		if ( log.isDebugEnabled() ) {
			log.debug( "in httpRequestToGetTriplesToDisplay display method " );
		}
		return httpRequestToGetTriples( session, query, "application/xml" );

	}

	public String httpRequestToGetTriples(Session session, String query, String format) throws RepositoryProviderException {
		final PostMethod method = new PostMethod( repositoryURL + RestCommands.Query.getKey() );
		method.setParameter( "format", format );
		method.setParameter( "query", query );
		method.setParameter( "view", "user" );
		// setGraphsParameter( method );
		return ProviderUtils.getHttpResponse( checkValidSessionAndGetHttpClient( session ), method );
	}

	public PostMethod getGraphHttpMethod(String garphContent, String graph) {
		final PostMethod method = new PostMethod( repositoryURL + RestCommands.Graph.getKey() );
		method.setParameter( "format", "text/plain" );
		method.setParameter( "content", garphContent );
		method.setParameter( "name", graph );
		return method;
	}

	public Integer getCountOfTriples(Session session, String query) throws RepositoryProviderException {
		final String results = getTriplesToDisplay( session, query );
		final ResultSet resultSet = ResultSetFactory.fromXML( results );
		int count = 0;
		while ( resultSet.hasNext() ) {
			resultSet.next();
			count++;
		}
		return new Integer( count );
	}

	private void setGraphsParameter(PostMethod method) {
		for (String graph : DataManagmentProvider.graphs) {
			method.setParameter( "default-graph-uri", graph );
		}
		method.setParameter( "default-graph-uri", DatatoolsMetadataConstants.Inferred );

	}

	private HttpClient checkValidSessionAndGetHttpClient(Session session) throws RepositoryProviderException {
		securityProvider.isValid( session.getSessionId(), true );
		return securityProvider.getHttpClient( session );
	}
}
