/**
 * The eagle-i consortium
 * Harvard University
 * Nov 4, 2010
 */
package org.eaglei.datatools.provider;

import java.util.List;
import java.util.Map;

import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;
import org.eaglei.security.Session;
import org.eaglei.services.repository.RepositoryProviderException;

/**
 * @author Daniela Bourges-Waldegg
 * 
 */
public interface CrudProvider {
	/*
	 * CRUD
	 */

	public static final EIEntity DEFAULT_WORKSPACE_ENTITY = EIEntity.create( "http://eagle-i.org/ont/repo/1.0/NG_DefaultWorkspace", "Default Workspace of resource descriptions" );

	public List<EIURI> getNewInstanceID(Session session, int count) throws RepositoryProviderException;

	public EIInstance getEmptyEIInstance(Session session, EIURI classUri, EIEntity instanceEntity) throws RepositoryProviderException;

	public EIInstance getEmptyEIInstance(Session session, EIURI classUri) throws RepositoryProviderException;

	public String getToken(Session session, EIInstance instance) throws RepositoryProviderException;;

	public Map<EIInstance, String> getTokens(Session session, List<EIInstance> instances) throws RepositoryProviderException;;

	public void updateInstance(Session session, EIInstance instance, String token) throws RepositoryProviderException;

	public void updateInstances(Session session, Map<EIInstance, String> instancesWithTokens) throws RepositoryProviderException;

	public void createInstance(Session session, EIInstance instance, EIEntity workspaceEntity) throws RepositoryProviderException;;

	public void createInstances(Session session, List<EIInstance> instances, EIEntity workspaceEntity) throws RepositoryProviderException;;

	public EIInstance deepCopy(Session session, EIURI originalUri) throws RepositoryProviderException;

	public void deleteInstance(Session session, EIURI instanceUri) throws RepositoryProviderException;
	
	public void deleteInstances(Session session, List<EIURI> instanceUris) throws RepositoryProviderException;
	
	public Map<EIURI, String> getModifiedDates(Session session, List<EIURI> uris) throws RepositoryProviderException;
}
