/**
 * The eagle-i consortium
 * Harvard University
 * Nov 4, 2010
 */
package org.eaglei.datatools.provider;

import java.util.List;

import org.eaglei.datatools.User;
import org.eaglei.datatools.WorkFlowTransition;
import org.eaglei.datatools.Workspace;
import org.eaglei.model.EIEntity;
import org.eaglei.security.Session;
import org.eaglei.services.repository.RepositoryProviderException;

/**
 * @author Daniela Bourges-Waldegg
 * 
 */
public interface DatatoolsSecurityProvider {
	public User login(final String userName, final String password) throws RepositoryProviderException;

	public void logout(final Session session) throws RepositoryProviderException;

	public User whoami(Session session) throws RepositoryProviderException;

	public boolean isOnline();

	public List<Workspace> getWorkspaces(Session session) throws RepositoryProviderException;
	
	public List<WorkFlowTransition> listWorkFlowTransitions(final Session session, final EIEntity workspaceEntity) throws RepositoryProviderException;
}
