/**
 * The eagle-i consortium
 * Harvard University
 * Nov 4, 2010
 */
package org.eaglei.datatools.provider;

import java.util.List;

import org.eaglei.model.EIInstanceMinimal;
import org.eaglei.model.EIURI;
import org.eaglei.security.Session;

/**
 * Minimal Repository interface to be used for Bulk operations,
 * String-based
 * 
 * @author Daniela Bourges-Waldegg
 * 
 */
public interface MinimalRepositoryProvider {
	//Free from SPARQL Query
	public String query(Session session, String sparql);
	public String getToken(Session session, EIURI instanceUri);
	public String createInstance(Session session, EIURI instanceUri, String instanceAsString, EIURI workspace);
	public String updateInstance(Session session, EIURI instanceUri, String instanceAsString);
	public String deleteInstance(Session session, EIURI instanceUri);
}
