/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.jena;

import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.datatools.jena.DataManagmentProvider;
import org.eaglei.security.Session;
import org.eaglei.services.repository.ProviderUtils;
import org.eaglei.services.repository.RepositoryProviderException;
import org.eaglei.services.repository.SecurityProvider;

public class TriplesCRUDService {
    private SecurityProvider securityProvider;
    private String repositoryURL;
    protected static final Log log = LogFactory.getLog(TriplesCRUDService.class);

    public TriplesCRUDService(SecurityProvider securityProvider, String repositoryURL) {
        this.securityProvider = securityProvider;
        this.repositoryURL = repositoryURL;
    }

    public void addNewTriples(Session session, String tripleContent, String graph) throws RepositoryProviderException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"in adding new triple To graph method ");
        }
        PostMethod method = this.getGraphHttpMethod(tripleContent, graph);
        method.setParameter("action", "add");
        ProviderUtils.getHttpResponse((HttpClient)this.checkValidSessionAndGetHttpClient(session), (HttpMethod)method);
        log.info((Object)"added new content to graph");
    }

    public void deleteOldTriple(Session session, String tripleContent, String graph) throws RepositoryProviderException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"deleting old triple from graph method ");
        }
        PostMethod method = this.getGraphHttpMethod(tripleContent, graph);
        method.setParameter("action", "delete");
        ProviderUtils.getHttpResponse((HttpClient)this.checkValidSessionAndGetHttpClient(session), (HttpMethod)method);
        log.info((Object)"deleted old content from graph");
    }

    public String getTriplesToRepair(Session session, String query) throws RepositoryProviderException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"in httpRequestToGetTriplesToRepair method ");
        }
        return this.httpRequestToGetTriples(session, query, "text/plain");
    }

    public String getTriplesToDisplay(Session session, String query) throws RepositoryProviderException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"in httpRequestToGetTriplesToDisplay display method ");
        }
        return this.httpRequestToGetTriples(session, query, "application/xml");
    }

    public String httpRequestToGetTriples(Session session, String query, String format) throws RepositoryProviderException {
        PostMethod method = new PostMethod(this.repositoryURL + RestCommands.Query.getKey());
        method.setParameter("format", format);
        method.setParameter("query", query);
        method.setParameter("view", "user");
        return ProviderUtils.getHttpResponse((HttpClient)this.checkValidSessionAndGetHttpClient(session), (HttpMethod)method);
    }

    public PostMethod getGraphHttpMethod(String garphContent, String graph) {
        PostMethod method = new PostMethod(this.repositoryURL + RestCommands.Graph.getKey());
        method.setParameter("format", "text/plain");
        method.setParameter("content", garphContent);
        method.setParameter("name", graph);
        return method;
    }

    public Integer getCountOfTriples(Session session, String query) throws RepositoryProviderException {
        String results = this.getTriplesToDisplay(session, query);
        ResultSet resultSet = ResultSetFactory.fromXML((String)results);
        int count = 0;
        while (resultSet.hasNext()) {
            resultSet.next();
            ++count;
        }
        return new Integer(count);
    }

    private void setGraphsParameter(PostMethod method) {
        for (String graph : DataManagmentProvider.graphs) {
            method.setParameter("default-graph-uri", graph);
        }
        method.setParameter("default-graph-uri", "http://eagle-i.org/ont/repo/1.0/NG_Inferred");
    }

    private HttpClient checkValidSessionAndGetHttpClient(Session session) throws RepositoryProviderException {
        this.securityProvider.isValid(session.getSessionId(), true);
        return this.securityProvider.getHttpClient(session);
    }

    private static enum RestCommands {
        GetNewInstanceIDs("repository/new"),
        WhoAmI("repository/whoami"),
        Logout("repository/logout/"),
        GetInstance("repository/resource"),
        UpdateInstance("repository/update"),
        Query("repository/sparql"),
        Online(""),
        Graph("repository/graph"),
        FakeWorkflow("repository/fakeworkflow"),
        Listgraphs("repository/listGraphs"),
        Claim("repository/workflow/claim"),
        Release("repository/workflow/release"),
        Transition("repository/workflow/push"),
        ListTransitions("repository/workflow/transitions"),
        ListResources("repository/workflow/resources");

        private final String key;

        private RestCommands(String propKey) {
            this.key = propKey;
        }

        public String getKey() {
            return this.key;
        }
    }
}

