package org.eaglei.datatools.etl.server;

/**
 * @author Sravan Kumar Cheriyala
 * 
 * This class have method which constructs SPARQL Query given the RDF Model
 */
import static org.eaglei.datatools.model.DataToolsOntConstants.RDFS_URI;
import static org.eaglei.datatools.model.DataToolsOntConstants.RDF_URI;

import java.text.CharacterIterator;
import java.text.StringCharacterIterator;

import org.eaglei.datatools.jena.RESTRepositoryProvider;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;

public class ETLSPARQLQueryUtil {
	/**
	 * Returns the a sparql query that asks the repo for the URI of a resource
	 * of Model
	 * 
	 * @throws Exception
	 * 
	 */
	public static String getEIResourcesByAllPropertiesQuery(Model rdfModel, String session) throws Exception {
		final StringBuilder sparql = new StringBuilder();
		EIInstance instance = null;
		sparql.append("PREFIX rdf: <");
		sparql.append(RDF_URI);
		sparql.append("> ");
		sparql.append("PREFIX rdfs: <");
		sparql.append(RDFS_URI);
		sparql.append("> ");
		sparql.append("SELECT ?resource WHERE {");
		String query = getEIResourcesByOnlyTypeANDRdfsLabel(rdfModel);
		RESTRepositoryProvider provider = (RESTRepositoryProvider) RDFtoRepoService.getInstance(RdfMaker.repo).getRepositoryProvider();
		String result = provider.query(session, query);
		String[] resultAry = getInstanceURI(result);
		if (resultAry != null) {
			instance = provider.getInstance(session, EIURI.create(resultAry[0]));
		}
		StmtIterator stmtIterator = rdfModel.listStatements();
		int i = 0;
		while (stmtIterator.hasNext()) {
			Statement stmtMap = stmtIterator.nextStatement();
			Resource subjectMap = stmtMap.getSubject();
			Property predicateMap = stmtMap.getPredicate();
			RDFNode objectMap = stmtMap.getObject();
			if (instance != null) {
				if (objectMap.isLiteral()) {
					if (!instance.getDatatypeProperties().toString().contains(objectMap.toString()) && !instance.getInstanceLabel().contains(objectMap.toString().replace("^^http://www.w3.org/2001/XMLSchema#string", ""))) {
						continue;
					}
				} else {
					if (!instance.getObjectProperties().toString().contains(objectMap.toString()) && !instance.getInstanceType().toString().contains(objectMap.toString())) {
						continue;
					}
				}
			}
			sparql.append("?resource <" + predicateMap.getURI() + "> ");
			if (objectMap.isResource()) {
				Resource objResource = (Resource) objectMap;
				sparql.append("	 <" + objResource.getURI() + "> . ");
			} else {
				//sparql.append("?o" + i + " FILTER regex(str(?o" + i + "), \"" + forRegex(objectMap.toString()).split("\\^\\^")[0].replace("", "\"").replace("", "\"").replace("\"", "\\\"").trim() + "\", \"i\").");
				//to pass the build
				sparql.append("?o" + i + " FILTER regex(str(?o" + i + "), \"^" + forRegex(objectMap.toString()).split("\\^\\^")[0].replace("\"", "\\\"").trim() + "$\", \"i\").");
			}
			i++;
		}
		sparql.append("}");
		return sparql.toString();
	}
	/**
	 * Returns the a sparql query that asks the repo for the URI of a resource
	 * of Model
	 * 
	 */
	public static String getEIResourcesQueryButnotWithPassProperty(Model rdfModel, Property property) {
		final StringBuilder sparql = new StringBuilder();
		sparql.append("PREFIX rdf: <");
		sparql.append(RDF_URI);
		sparql.append("> ");
		sparql.append("PREFIX rdfs: <");
		sparql.append(RDFS_URI);
		sparql.append("> ");
		sparql.append("SELECT ?resource WHERE {");
		StmtIterator stmtIterator = rdfModel.listStatements();
		int i = 0;
		while (stmtIterator.hasNext()) {
			Statement stmtMap = stmtIterator.nextStatement();
			Resource subjectMap = stmtMap.getSubject();
			Property predicateMap = stmtMap.getPredicate();
			RDFNode objectMap = stmtMap.getObject();
			if (predicateMap.toString().equals(property.toString())) {
				continue;
			}
			sparql.append("?resource <" + predicateMap.getURI() + "> ");
			if (objectMap.isResource()) {
				Resource objResource = (Resource) objectMap;
				sparql.append("	 <" + objResource.getURI() + "> . ");
			} else {
				//sparql.append("?o" + i + " FILTER regex(str(?o" + i + "), \"" + forRegex(objectMap.toString()).split("\\^\\^")[0].replace("", "\"").replace("", "\"").replace("\"", "\\\"").trim() + "\", \"i\").");
				//to pass the build
				sparql.append("?o" + i + " FILTER regex(str(?o" + i + "), \"^" + forRegex(objectMap.toString()).split("\\^\\^")[0].replace("\"", "\\\"").trim() + "$\", \"i\").");
			}
			i++;
		}
		sparql.append("}");
		return sparql.toString();
	}
	/**
	 * Returns the a sparql query that asks the repo for the URI of a resource
	 * of Model ,It builds query of properties containing only rdfs:type and
	 * rdfs:lable as predicate
	 * 
	 */
	public static String getEIResourcesByOnlyTypeANDRdfsLabel(Model rdfModel) {
		final StringBuilder sparql = new StringBuilder();
		sparql.append("PREFIX rdf: <");
		sparql.append(RDF_URI);
		sparql.append("> ");
		sparql.append("PREFIX rdfs: <");
		sparql.append(RDFS_URI);
		sparql.append("> ");
		sparql.append("SELECT ?resource WHERE {");
		StmtIterator stmtIterator = rdfModel.listStatements();
		while (stmtIterator.hasNext()) {
			Statement stmtMap = stmtIterator.nextStatement();
			Resource subjectMap = stmtMap.getSubject();
			Property predicateMap = stmtMap.getPredicate();
			RDFNode objectMap = stmtMap.getObject();
			if (predicateMap.getURI().equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#type") || predicateMap.getURI().equals("http://www.w3.org/2000/01/rdf-schema#label")) {
				sparql.append("?resource <" + predicateMap.getURI() + "> ");
				if (objectMap.isResource()) {
					Resource objResource = (Resource) objectMap;
					sparql.append("	 <" + objResource.getURI() + "> . ");
				} else {
					//		sparql.append("?o FILTER regex(str(?o), \"" + forRegex(objectMap.toString()).split("\\^\\^")[0].replace("", "\"").replace("", "\"").replace("\"", "\\\"") + "\", \"i\").");
					sparql.append("?o FILTER regex(str(?o), \"^" + forRegex(objectMap.toString()).split("\\^\\^")[0].replace("\"", "\\\"") + "$\", \"i\").");
				}
			}
		}
		sparql.append("}");
		return sparql.toString();
	}
	public static String forRegex(String aRegexFragment) {
		final StringBuilder result = new StringBuilder();
		final StringCharacterIterator iterator = new StringCharacterIterator(aRegexFragment);
		char character = iterator.current();
		while (character != CharacterIterator.DONE) {
			/*
			 * All literals need to have backslashes doubled.
			 */
			if (character == '.') {
				result.append("\\\\.");
			} else if (character == '\\') {
				result.append("\\\\\\");
			} else if (character == '?') {
				result.append("\\\\?");
			} else if (character == '*') {
				result.append("\\\\*");
			} else if (character == '+') {
				result.append("\\\\+");
			} else if (character == '&') {
				result.append("\\\\&");
			} else if (character == ':') {
				result.append("\\\\:");
			} else if (character == '{') {
				result.append("\\\\{");
			} else if (character == '}') {
				result.append("\\\\}");
			} else if (character == '[') {
				result.append("\\\\[");
			} else if (character == ']') {
				result.append("\\\\]");
			} else if (character == '(') {
				result.append("\\\\(");
			} else if (character == ')') {
				result.append("\\\\)");
			} else if (character == '^') {
				result.append("^");
			} else if (character == '$') {
				result.append("\\\\$");
			} else {
				//the char is not a special one
				//add it to the result as is
				result.append(character);
			}
			character = iterator.next();
		}
		return result.toString();
	}
	/**
	 * get instance URI from the returned xml
	 * 
	 * @param xmlString
	 * @return
	 */
	public static String[] getInstanceURI(final String xmlString) {
		if (xmlString != null) {
			java.util.regex.Pattern instancePattern = java.util.regex.Pattern.compile("<uri>([^<]*?)</uri>");
			java.util.regex.Matcher match = instancePattern.matcher(xmlString);
			String[] instanceStr = null;
			while (match.find()) {
				int count = match.groupCount();
				instanceStr = new String[count];
				for (int i = 1; i <= count; i++) {
					instanceStr[i - 1] = match.group(i);
				}
			}
			return instanceStr;
		} else {
			return null;
		}
	}
}
