/*
 * The MIT License
 *
 * Copyright 2007 Lushan Han and UMBC Ebiquity Research Group.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

package org.eaglei.datatools.etl.utils;


public class Configure {
	
	public final static char DELIMIT = ',';
	public final static String BASE = "http://baseURI";
	public final static String MAP_BASE = "http://mapBaseURI";
	public final static String EX = "Ex:";
	public final static long MAX_SIZE = 10*1000*1000;  //10M
	public final static long PRETTY_SIZE = 5000;  //row*column
    public final static String contentTypeAppN3        = "application/n3" ;
    public final static String contentTypeTurtle       = "application/turtle" ;
    public final static String contentTypeRDFXML       = "application/rdf+xml" ;
    public final static String contentTypeNTriples     = "application/n-triples" ;
    public final static String contentTypeXML          = "text/xml" ;
    public final static String contentTypeResultsXML   = "application/sparql-results+xml" ;
    public final static String contentTypeTextPlain    = "text/plain" ;
    public final static String contentTypeHTML    	   = "text/html" ;
    public final static String contentTypeTextN3       = "text/n3" ;
	
	public final static String[][] metaArray = 
		{	{"type", "rdf:type"},
		    {"title", "dc:title"},
			{"creator", "dc:creator"},
			{"date", "dc:date"},
			{"comment", "rdfs:comment"},
			{"version", "owl:versionInfo"},
			{"map file", "rdf123:hasMap"}
		};
	
	public final static String[][] prefixArray = 
	{	{"rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#"},
	    {"rdfs", "http://www.w3.org/2000/01/rdf-schema#"},
	    {"owl", "http://www.w3.org/2002/07/owl#"},
		{"foaf", "http://xmlns.com/foaf/0.1/"},
		{"rdf123", "http://rdf123.umbc.edu/ns/"},
		{"dc", "http://purl.org/dc/elements/1.1/"},
		{"sioc", "http://rdfs.org/sioc/ns#"},
		{"vcard", "http://www.w3.org/2001/vcard-rdf/3.0#"},
		{"swrc", "http://swrc.ontoware.org/ontology#"}
	};

    public static int baseRow = 0;
    public static int baseCol = 0;

}
