/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.interim.cores;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Mapping {
    private MappingType type;
    private SourceType sourceType;
    private String sourceID;
    private String targetNS;
    private String targetID;
    private String targetRangeURI;
    private List<Mapping> mappings;
    private Map<String, String> lookup;
    private Map<String, String> rangeLookup;

    public Mapping(MappingType type, SourceType sourceType, String sourceID, String targetNS, String targetID) {
        this.type = type;
        this.sourceType = sourceType;
        this.sourceID = sourceID;
        this.targetNS = targetNS;
        this.targetID = targetID;
    }

    public Mapping(String sourceID, String targetNS, String targetID) {
        this(MappingType.PROPERTY, SourceType.COLUMN, sourceID, targetNS, targetID);
    }

    public Mapping(String sourceID, String targetNS, String targetID, String targetRangeURI) {
        this(MappingType.PROPERTY, SourceType.COLUMN, sourceID, targetNS, targetID);
        this.setTargetRangeURI(targetRangeURI);
    }

    public String getTargetUri() {
        if (this.targetNS.endsWith("/") || this.targetNS.endsWith("#")) {
            return this.targetNS + this.targetID;
        }
        return this.targetNS + "/" + this.targetID;
    }

    public String getTargetUri(String sourceID) {
        if (this.lookup != null) {
            return this.lookup.get(sourceID);
        }
        return null;
    }

    public void addMapping(Mapping mapping) {
        if (this.mappings == null) {
            this.mappings = new ArrayList<Mapping>();
        }
        if (this.lookup == null) {
            this.lookup = new HashMap<String, String>();
        }
        if (this.rangeLookup == null) {
            this.rangeLookup = new HashMap<String, String>();
        }
        this.mappings.add(mapping);
        this.lookup.put(mapping.getSourceID(), mapping.getTargetUri());
        this.rangeLookup.put(mapping.getSourceID(), mapping.getTargetRangeURI());
    }

    public void addMapping(String sourceID, String targetNS, String targetID) {
        this.addMapping(new Mapping(sourceID, targetNS, targetID));
    }

    public void addMapping(String sourceID, String targetNS, String targetID, String targetRangeURI) {
        Mapping m = new Mapping(sourceID, targetNS, targetID);
        m.setTargetRangeURI(targetRangeURI);
        this.addMapping(m);
    }

    public List<Mapping> getMappings() {
        return this.mappings;
    }

    public MappingType getType() {
        return this.type;
    }

    public SourceType getSourceType() {
        return this.sourceType;
    }

    public String getSourceID() {
        return this.sourceID;
    }

    public String getTargetNS() {
        return this.targetNS;
    }

    public String getTargetID() {
        return this.targetID;
    }

    public String toString() {
        return "Mapping [type=" + (Object)((Object)this.type) + ", sourceType=" + (Object)((Object)this.sourceType) + ", sourceID=" + this.sourceID + ", targetNS=" + this.targetNS + ", targetID=" + this.targetID + ", targetRangeURI=" + this.targetRangeURI + ", mappings=" + this.mappings + "]";
    }

    public String getTargetRangeURI() {
        return this.targetRangeURI;
    }

    public String getTargetRangeURI(String sourceID) {
        if (this.rangeLookup != null) {
            return this.rangeLookup.get(sourceID);
        }
        return null;
    }

    private void setTargetRangeURI(String targetRangeURI) {
        this.targetRangeURI = targetRangeURI;
    }

    public static enum SourceType {
        TAB,
        COLUMN;

    }

    public static enum MappingType {
        CLASS,
        PROPERTY;

    }
}

