/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.etl.server;

import com.hp.hpl.jena.rdf.model.Model;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.datatools.config.DatatoolsConfiguration;
import org.eaglei.datatools.jena.RESTRepositoryProvider;
import org.eaglei.datatools.jena.RESTRepositoryProviderFactory;
import org.eaglei.datatools.provider.RepositoryProvider;
import org.eaglei.model.EIURI;
import org.eaglei.security.Session;

public class RDFtoRepoService {
    private static RDFtoRepoService instance = null;
    private DatatoolsConfiguration config;
    RESTRepositoryProvider repoProvider;
    private static final String DEFAULT_CONFIGURATION = "etl-datatools.prop";
    private static final Log logger = LogFactory.getLog(RDFtoRepoService.class);
    private String token;

    private RDFtoRepoService(String file) throws Exception {
        this.config = this.getConfiguration(file);
        this.repoProvider = (RESTRepositoryProvider)new RESTRepositoryProviderFactory().createRepositoryProvider(this.config);
    }

    private RDFtoRepoService() throws Exception {
        this.config = this.getConfiguration();
        this.repoProvider = (RESTRepositoryProvider)new RESTRepositoryProviderFactory().createRepositoryProvider(this.config);
    }

    public RepositoryProvider getRepositoryProvider() {
        return this.repoProvider;
    }

    public DatatoolsConfiguration getDatatoolsConfiguration() {
        return this.config;
    }

    public static RDFtoRepoService getInstance(String file) throws Exception {
        if (instance == null) {
            instance = new RDFtoRepoService(file);
        }
        return instance;
    }

    public static RDFtoRepoService getInstance() throws Exception {
        if (instance == null) {
            instance = new RDFtoRepoService();
        }
        return instance;
    }

    public boolean pushtoRepo(Model rdfModel, Session session, String uri, String promoteParameter) throws Exception {
        StringWriter swriter = new StringWriter();
        rdfModel.write((Writer)swriter, "RDF/XML");
        this.repoProvider.createInstance(session, swriter.toString(), uri, RESTRepositoryProvider.DEFAULT_WORKSPACE_ENTITY);
        this.token = this.repoProvider.updateInstance(session, swriter.toString(), uri, null);
        this.repoProvider.updateInstance(session, swriter.toString(), uri, this.token);
        if (promoteParameter.equalsIgnoreCase("publish")) {
            this.repoProvider.promote(session, EIURI.create((String)uri), EIURI.create((String)"http://eagle-i.org/ont/repo/1.0/WFS_Curation"));
            this.repoProvider.promote(session, EIURI.create((String)uri), EIURI.create((String)"http://eagle-i.org/ont/repo/1.0/WFS_Published"));
        } else if (promoteParameter.equalsIgnoreCase("curation")) {
            this.repoProvider.promote(session, EIURI.create((String)uri), EIURI.create((String)"http://eagle-i.org/ont/repo/1.0/WFS_Curation"));
        } else if (promoteParameter.equalsIgnoreCase("draft")) {
            this.repoProvider.claim(session, EIURI.create((String)uri), "nobody");
        }
        return true;
    }

    public List<EIURI> getNewInstancesFromRepo(Session session, int countofInstances) throws Exception {
        return this.repoProvider.getNewInstanceID(session, countofInstances);
    }

    public RepositoryProvider setPropertyFilePathAndgetNewRepoProvider(String configFilePath) throws Exception {
        File configFile = new File(configFilePath);
        logger.debug((Object)("loading configuration file: " + configFile));
        this.config = new DatatoolsConfiguration(configFile);
        this.repoProvider = (RESTRepositoryProvider)new RESTRepositoryProviderFactory().createRepositoryProvider(this.config);
        return this.repoProvider;
    }

    private DatatoolsConfiguration getConfiguration(String DEFAULT_CONFIGURATION) throws Exception {
        try {
            File configFile = new File(DEFAULT_CONFIGURATION);
            logger.debug((Object)("loading configuration file: " + configFile));
            return new DatatoolsConfiguration(configFile);
        }
        catch (Exception e) {
            logger.error((Object)("Error loading configuration from " + DEFAULT_CONFIGURATION + " " + e));
            throw new Exception(e);
        }
    }

    private DatatoolsConfiguration getConfiguration() throws Exception {
        URL configURL = this.getClass().getClassLoader().getResource(DEFAULT_CONFIGURATION);
        if (configURL == null) {
            logger.error((Object)"Could not locate etl-datatools.prop on classpath");
            throw new Exception("Could not locate etl-datatools.prop on classpath");
        }
        try {
            File configFile = new File(configURL.toURI());
            logger.debug((Object)("loading configuration file: " + configFile));
            return new DatatoolsConfiguration(configFile);
        }
        catch (Exception e) {
            logger.error((Object)("Error loading configuration from etl-datatools.prop " + e));
            throw new Exception(e);
        }
    }
}

