/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.etl.server;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.table.DefaultTableModel;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.eaglei.datatools.User;
import org.eaglei.datatools.etl.server.ETLSPARQLQueryUtil;
import org.eaglei.datatools.etl.server.RDFtoRepoService;
import org.eaglei.datatools.etl.server.RowConfiguration;
import org.eaglei.datatools.etl.utils.BasicUtils;
import org.eaglei.datatools.etl.utils.Configure;
import org.eaglei.datatools.etl.utils.JenaUtils;
import org.eaglei.datatools.etl.utils.Rdf123Expression;
import org.eaglei.datatools.excel.ExcelParserException;
import org.eaglei.datatools.excel.ExcelUtils;
import org.eaglei.datatools.jena.EIInstanceFactory;
import org.eaglei.datatools.jena.RESTRepositoryProvider;
import org.eaglei.datatools.model.AnnotationFormModel;
import org.eaglei.datatools.provider.EIDataToolsProviderException;
import org.eaglei.datatools.provider.RepositoryProvider;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIURI;
import org.eaglei.security.Session;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class RdfMaker {
    private static final long serialVersionUID = 1L;
    private static Model prefixModel = null;
    Model mapModel = null;
    private static HashMap predefinedMetaMap = null;
    private int count = 0;
    HashMap<String, String> globalColumnsHash;
    private static Logger logger = Logger.getLogger(RdfMaker.class);
    public static String repo;
    public static String log;
    public static String directory;
    public static String oputputdirectory;
    public static String mapDirectory;
    public static String promoteParameter;
    public static String currentlyProcessingFile;
    private static RDFtoRepoService rdftorepo;
    public String order;
    RepositoryProvider provider;
    public static String maps;
    private Session session;
    private PrintWriter outputPrinter;
    private AnnotationFormModel anntModel;
    private Map<String, String> dcCreatorMap = RowConfiguration.getdcCreatorFromRepoFile(repo);
    List<EIURI> eiurilst = null;

    public static void main(String[] args) throws Exception {
        block14: {
            promoteParameter = "CURATION";
            directory = "";
            try {
                if (args.length <= 0) break block14;
                for (int i = 0; i < args.length - 1; ++i) {
                    if (args[i].equals("-d")) {
                        directory = args[++i];
                        continue;
                    }
                    if (args[i].equals("-o")) {
                        oputputdirectory = args[++i];
                        continue;
                    }
                    if (args[i].equals("-r")) {
                        repo = args[++i];
                        continue;
                    }
                    if (args[i].equals("-l")) {
                        log = args[++i];
                        continue;
                    }
                    if (args[i].equals("-m")) {
                        maps = args[++i];
                        continue;
                    }
                    if (!args[i].equals("-p") || (promoteParameter = args[++i]).equalsIgnoreCase("publish") || promoteParameter.equalsIgnoreCase("curation") || promoteParameter.equalsIgnoreCase("draft")) continue;
                    logger.info((Object)"Parameter supplied for promote is not recognized..data  will be promoted to Curation by default");
                    promoteParameter = "curation";
                }
                if (directory == null) {
                    logger.error((Object)"Excel Files location is not provided ,this input is mandatory");
                    System.exit(2);
                }
                if (repo == null) {
                    logger.error((Object)"Repository is not provided ,this input is mandatory");
                    System.exit(2);
                }
                if (maps == null) {
                    logger.error((Object)"Maps location are not provided ,this input is mandatory");
                    System.exit(2);
                }
                if (log != null) {
                    FileAppender appender = null;
                    try {
                        appender = new FileAppender((Layout)new PatternLayout(), log);
                    }
                    catch (Exception e) {
                        logger.error((Object)"Cannot create Log file..ignoring");
                    }
                    logger.addAppender((Appender)appender);
                }
                ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext(new String[]{"datatools-model-config.xml"});
                AnnotationFormModel anntModel = (AnnotationFormModel)context.getBean(AnnotationFormModel.class);
                EIOntModel datatoolsEIOntModel = (EIOntModel)context.getBean(EIOntModel.class);
                RdfMaker rdfmaker = new RdfMaker(anntModel);
                rdfmaker.rdfToRepoByExcelStream(directory, maps);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error((Object)e);
                logger.error((Object)"Exiting System");
                System.exit(2);
            }
        }
    }

    public int getCount() {
        return this.count;
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public RdfMaker(AnnotationFormModel anntModel) throws Exception {
        this.anntModel = anntModel;
        int count = Configure.prefixArray.length;
        HashMap<String, String> predefinedPrefixes = new HashMap<String, String>();
        for (int row = 0; row < count; ++row) {
            predefinedPrefixes.put(Configure.prefixArray[row][0], Configure.prefixArray[row][1]);
        }
        prefixModel = ModelFactory.createDefaultModel();
        prefixModel.setNsPrefixes(predefinedPrefixes);
        count = Configure.metaArray.length;
        try {
            rdftorepo = RDFtoRepoService.getInstance(repo);
        }
        catch (FileNotFoundException fe) {
            logger.error((Object)"Repository information file not found");
            logger.error((Object)fe);
            throw fe;
        }
        this.provider = rdftorepo.getRepositoryProvider();
        Map<String, String> credentialMap = RowConfiguration.getCredentialsForRepo(repo);
        User strAry = this.provider.login(credentialMap.get("user"), credentialMap.get("password"));
        if (strAry == null) {
            logger.error((Object)"Could not authenticate please check username,password and Repository URL...Exiting System");
            System.exit(2);
        }
        this.setSession(strAry.getSession());
        mapDirectory = maps;
    }

    public boolean rdfToRepoByExcelStream(String excelFolder, String mapFolder) throws Exception {
        String[] lstFiles;
        HashMap<String, InputStream> mapIns = new HashMap<String, InputStream>();
        File excelDirectory = new File(excelFolder);
        if (!excelDirectory.isDirectory()) {
            logger.error((Object)(excelFolder + " is not a directory...exiting"));
            System.exit(2);
        }
        for (String str : lstFiles = excelDirectory.list()) {
            try {
                String[] lstMapFiles;
                BufferedInputStream is;
                Map<String, DefaultTableModel> defaultModelMap;
                File dirfile;
                if (!str.contains(".xlsx") && !str.contains(".xls")) {
                    if (str.contains(".svn")) continue;
                    File strFIle = new File(excelFolder + "/" + str);
                    if (strFIle.isDirectory()) {
                        this.rdfToRepoByExcelStream(excelFolder + "/" + str, mapFolder);
                    } else {
                        logger.info((Object)(str + "is not Excel file ...Ignoring"));
                        continue;
                    }
                }
                if ((dirfile = new File(excelFolder + "/" + str)).isDirectory()) {
                    logger.info((Object)(excelFolder + "/" + str + "is directory ...Ignoring"));
                    continue;
                }
                logger.info((Object)("processing file :" + excelFolder + "/" + str));
                currentlyProcessingFile = str;
                if (oputputdirectory != null) {
                    FileOutputStream fvec = new FileOutputStream(oputputdirectory + "/" + str + ".rdf");
                    this.outputPrinter = new PrintWriter(fvec);
                }
                if ((defaultModelMap = this.ExcelToTableModel(is = new BufferedInputStream(new FileInputStream(excelFolder + "/" + str)))) == null) continue;
                File mapdirectory = null;
                mapdirectory = new File(mapDirectory);
                for (String mapstr : lstMapFiles = mapdirectory.list()) {
                    if (mapstr.contains(".svn")) continue;
                    try {
                        FileInputStream fis = new FileInputStream(mapDirectory + "/" + mapstr);
                        mapIns.put(mapstr.replace(".rdf", ""), fis);
                    }
                    catch (FileNotFoundException e) {
                        logger.error((Object)e);
                        throw e;
                    }
                }
                Map<String, Model> retMap = this.generateRDFGraph(defaultModelMap, mapIns);
                if (this.outputPrinter != null) {
                    this.outputPrinter.close();
                }
                mapDirectory = maps;
            }
            catch (FileNotFoundException e) {
                logger.error((Object)e);
                throw e;
            }
        }
        return true;
    }

    public Map<String, Model> generateRDFGraph(Map<String, DefaultTableModel> tableModelMap, Map<String, InputStream> mapStreamMap) throws Exception {
        String[] keySetAry = this.order.split("#");
        HashMap<String, Model> retMap = new HashMap<String, Model>();
        int loopVar = 0;
        for (String keyStr : keySetAry) {
            logger.info((Object)("Processing " + keyStr));
            DefaultTableModel tableModel = tableModelMap.get(keyStr.toUpperCase());
            if (tableModel == null) {
                logger.info((Object)(keyStr + " havent got anyrow skipping..."));
                continue;
            }
            InputStream mapStream = mapStreamMap.get(keyStr.toLowerCase());
            if (mapStream == null) continue;
            String base = rdftorepo.getDatatoolsConfiguration().getDatatoolsRepositoryNamespace();
            String syntax = "RDF/XML";
            this.mapModel = ModelFactory.createDefaultModel();
            this.mapModel.read(mapStream, null, syntax);
            this.mapModel.removeNsPrefix("");
            boolean hasRowHead = true;
            int startRow = Configure.baseRow;
            int endRow = tableModel.getRowCount() - 1;
            int startCol = 1;
            Rdf123Expression rdf123Exp = new Rdf123Expression(tableModel, this.mapModel.getNsPrefixMap(), startCol, base);
            if (hasRowHead) {
                ++startRow;
            }
            if (endRow - startRow >= 1) {
                this.eiurilst = rdftorepo.getNewInstancesFromRepo(this.session, endRow - startRow + 1);
            }
            this.count = 0;
            for (int row = startRow; row <= endRow; ++row) {
                HashMap<String, String[]> mapInstanceExp = new HashMap<String, String[]>();
                int columnCount = tableModel.getColumnCount();
                int columnsFilled = 0;
                for (int column = 0; column <= columnCount - 1; ++column) {
                    if (tableModel.getValueAt(row, column) == null || tableModel.getValueAt(row, column).equals("")) continue;
                    ++columnsFilled;
                }
                if (columnsFilled <= 0) continue;
                HashSet<String> subjectSet = new HashSet<String>();
                StmtIterator subIter = this.mapModel.listStatements();
                while (subIter.hasNext()) {
                    Statement stmtMap = subIter.nextStatement();
                    Resource subjectMap = stmtMap.getSubject();
                    if (subjectMap.getURI().equals("Ex:e+$0")) continue;
                    subjectSet.add(subjectMap.getURI());
                }
                Iterator setIter = subjectSet.iterator();
                while (setIter.hasNext()) {
                    Model tempModel = ModelFactory.createDefaultModel();
                    String subjectExpression = (String)setIter.next();
                    this.recursiveLoopAndMakeRdf(this.mapModel, tempModel, base, rdf123Exp, row, mapInstanceExp, subjectSet, subjectExpression, null);
                }
                StmtIterator mapIter = this.mapModel.listStatements();
                Model rdfModel = null;
                rdfModel = ModelFactory.createDefaultModel();
                rdfModel.setNsPrefixes(this.mapModel.getNsPrefixMap());
                Resource subject = null;
                while (mapIter.hasNext()) {
                    String result;
                    String[] strAry;
                    Statement stmtMap = mapIter.nextStatement();
                    Resource subjectMap = stmtMap.getSubject();
                    Property predicateMap = stmtMap.getPredicate();
                    RDFNode objectMap = stmtMap.getObject();
                    if (!subjectMap.getURI().equals("Ex:e+$0")) continue;
                    if (this.evaluateExpression(rdf123Exp, row, subjectMap.toString()) == null && !subjectMap.toString().startsWith("Ex:ont")) {
                        mapInstanceExp.remove(subjectMap.toString());
                        continue;
                    }
                    RDFNode[] objectAry = new RDFNode[20];
                    if (subjectMap.isAnon()) {
                        subject = rdfModel.createResource(new AnonId(subjectMap.getId().toString() + row));
                    } else if (subjectMap.getURI().startsWith("Ex:") && subjectMap.getURI().startsWith("Ex:e")) {
                        if (subjectMap.getURI().startsWith("Ex:e+$0")) {
                            if (this.eiurilst != null && mapInstanceExp.get("Ex:e+$0") == null) {
                                EIURI eiuri = this.eiurilst.get(this.count);
                                subject = rdfModel.createResource(eiuri.toString());
                                this.putInMap(mapInstanceExp, "Ex:e+$0", subject.getURI());
                            } else {
                                strAry = (String[])mapInstanceExp.get("Ex:e+$0");
                                subject = rdfModel.createResource(strAry[0]);
                            }
                        } else if (!subjectMap.getURI().startsWith("Ex:e") && !subjectMap.getURI().matches("Ex:ont") || subjectMap.getURI().startsWith("Ex:")) {
                            result = rdf123Exp.evaluate(subjectMap.getURI().substring("Ex:".length()), row);
                            if (result == null) continue;
                            if (!BasicUtils.isValidURL(result)) {
                                if (!JenaUtils.isValidRDFId(result) && !JenaUtils.isValidRDFId(result = result.replace(' ', '_'))) continue;
                                result = this.toURI(base, result);
                            }
                            subject = rdfModel.createResource(result);
                        } else {
                            subject = subjectMap;
                        }
                    }
                    Property predicate = this.getPredicate(rdfModel, rdf123Exp, predicateMap, row);
                    if (mapInstanceExp.get(objectMap.toString()) != null) {
                        strAry = (String[])mapInstanceExp.get(objectMap.toString());
                        int i = 0;
                        objectAry = new RDFNode[strAry.length + 1];
                        for (String str : strAry) {
                            objectAry[i] = rdfModel.createResource(str);
                            ++i;
                        }
                    } else if (objectMap.toString().matches("Ex:ont\\+\\$\\d+")) {
                        if (predicateMap.equals(RDF.type)) {
                            String rootURI = this.getObjectFromModelBySubjectAndType(this.mapModel, objectMap.toString());
                            if (rootURI != null) {
                                Resource typeObject = rdfModel.createResource(rootURI);
                                objectAry[0] = typeObject;
                                predicate = RDF.type;
                            }
                        } else {
                            result = this.evaluateExpression(rdf123Exp, row, objectMap.toString());
                            Literal node = this.mapModel.createTypedLiteral(result, (RDFDatatype)XSDDatatype.XSDstring);
                            objectAry[0] = node;
                            predicate = rdfModel.createProperty("http://eagle-i.org/ont/datatools/1.0/temp");
                        }
                    } else {
                        objectAry = this.getObject(rdfModel, rdf123Exp, objectMap, mapInstanceExp, row, subjectMap.toString());
                    }
                    for (RDFNode objectNode : objectAry) {
                        if (objectNode == null) continue;
                        rdfModel.add(subject, predicate, objectNode);
                    }
                }
                this.addSourcefileTriple(rdfModel, subject);
                EIURI eiuri = this.eiurilst.get(this.count);
                logger.info((Object)("pushing " + keyStr + " instance into repo"));
                StringWriter swriter = new StringWriter();
                rdfModel.write((Writer)swriter, "N-TRIPLE");
                if (oputputdirectory != null) {
                    this.outputPrinter.println(swriter.toString());
                }
                try {
                    String query = ETLSPARQLQueryUtil.getEIResourcesByOnlyTypeANDRdfsLabel(rdfModel);
                    String instance = this.provider.query(this.session, query.replace("\n", " ").replace("\r", " "));
                    String[] instanceURI = ETLSPARQLQueryUtil.getInstanceURI(instance);
                    if (query != null && (instanceURI == null || !query.contains("ERO_0000001") && !query.contains("ERO_0000002"))) {
                        rdftorepo.pushtoRepo(rdfModel, this.getSession(), eiuri.toString(), promoteParameter);
                    }
                }
                catch (EIDataToolsProviderException ex) {
                    logger.error((Object)ex.getMessage());
                    logger.error((Object)("the offending instnace is " + swriter.toString()));
                    logger.info((Object)"skiping...");
                }
                logger.info((Object)(keyStr + " instance pushed into repo"));
                ++this.count;
                ++loopVar;
            }
            if (this.count % 50 != 0) continue;
            System.gc();
        }
        return retMap;
    }

    private String recursiveLoopAndMakeRdf(Model mapModel, Model rdfModel, String base, Rdf123Expression rdf123Exp, int row, Map<String, String[]> mapInstanceExp, Set<String> subjectSet, String subjectExpression, String semiColonSplitLabel) throws Exception {
        boolean somethingAdded = false;
        StmtIterator subNodes = mapModel.listStatements();
        Resource subject = null;
        List<EIURI> lstEIURI = rdftorepo.getNewInstancesFromRepo(this.session, 1);
        EIURI neweiuri = lstEIURI.get(0);
        subject = rdfModel.createResource(neweiuri.toString());
        while (subNodes.hasNext()) {
            String labelBySubjectExp;
            Property predicate;
            RDFNode[] objectAry = new RDFNode[20];
            Statement stmtMap = subNodes.nextStatement();
            Resource subjectMap = stmtMap.getSubject();
            Property predicateMap = stmtMap.getPredicate();
            RDFNode objectMap = stmtMap.getObject();
            if (!subjectMap.getURI().equals(subjectExpression)) continue;
            if (this.evaluateExpression(rdf123Exp, row, subjectMap.toString()) == null && !subjectExpression.startsWith("Ex:ont")) {
                mapInstanceExp.remove(subjectExpression);
                continue;
            }
            if (!(objectMap instanceof Resource) && predicateMap.equals(RDFS.label)) {
                Literal objectLiteral = (Literal)objectMap;
                String result = semiColonSplitLabel != null ? semiColonSplitLabel : this.evaluateExpression(rdf123Exp, row, objectLiteral.getString());
                String returnedStr = this.getTypeFromModelByObject(mapModel, subjectExpression);
                if (returnedStr != null && returnedStr.contains("http://purl.org/dc/terms/")) {
                    result = this.wrapUsersofdcCreator(result);
                }
                if (result != null && rdfModel != null && result.contains(";") && !rdfModel.toString().contains("http://xmlns.com/foaf/0.1/Person")) {
                    RDFNode[] subobjectAry = new RDFNode[20];
                    subobjectAry[0] = mapModel.createResource(this.getObjectFromModelBySubjectAndType(mapModel, subjectExpression));
                    if (!predicateMap.equals(RDFS.label)) continue;
                    for (String str : result.split(";")) {
                        Model subtempModel = ModelFactory.createDefaultModel();
                        this.recursiveLoopAndMakeRdf(mapModel, subtempModel, base, rdf123Exp, row, mapInstanceExp, subjectSet, subjectExpression, str.replace('\n', ' ').trim());
                    }
                    continue;
                }
                if (result == null) continue;
                predicate = this.getPredicate(rdfModel, rdf123Exp, predicateMap, row);
                if (subjectSet.toString().contains(objectMap.toString()) && mapInstanceExp.get(objectMap.toString()) == null) {
                    Model subtempModel = ModelFactory.createDefaultModel();
                    String retResource = this.recursiveLoopAndMakeRdf(mapModel, subtempModel, base, rdf123Exp, row, mapInstanceExp, subjectSet, objectMap.toString(), null);
                    if (retResource == null) continue;
                    Resource object = rdfModel.createResource(retResource);
                    objectAry[0] = object;
                } else {
                    Literal object = rdfModel.createTypedLiteral(result, (RDFDatatype)XSDDatatype.XSDstring);
                    objectAry[0] = object;
                }
                for (RDFNode objectNode : objectAry) {
                    if (objectNode == null) continue;
                    somethingAdded = true;
                    rdfModel.add(subject, predicate, objectNode);
                }
                continue;
            }
            if (semiColonSplitLabel == null && (labelBySubjectExp = this.getLabelBySubjectExpression(mapModel, row, rdf123Exp, subjectExpression)) != null && labelBySubjectExp.contains(";") && !rdfModel.toString().contains("http://xmlns.com/foaf/0.1/Person")) continue;
            predicate = this.getPredicate(rdfModel, rdf123Exp, predicateMap, row);
            if (subjectSet.toString().contains(objectMap.toString()) && mapInstanceExp.get(objectMap.toString()) == null) {
                Model subtempModel = ModelFactory.createDefaultModel();
                String retResource = this.recursiveLoopAndMakeRdf(mapModel, subtempModel, base, rdf123Exp, row, mapInstanceExp, subjectSet, objectMap.toString(), null);
                if (retResource == null) continue;
                Resource object = rdfModel.createResource(retResource);
                objectAry[0] = object;
            } else {
                objectAry = this.getObject(rdfModel, rdf123Exp, objectMap, mapInstanceExp, row, subjectExpression);
            }
            for (RDFNode objectNode : objectAry) {
                if (objectNode == null) continue;
                somethingAdded = true;
                rdfModel.add(subject, predicate, objectNode);
            }
        }
        if (somethingAdded) {
            this.checkExpressionAndMakeSubjectResource(mapModel, base, rdf123Exp, row, mapInstanceExp, rdfModel, subject, subjectExpression);
        }
        if (mapInstanceExp.get(subjectExpression) != null) {
            return mapInstanceExp.get(subjectExpression)[0];
        }
        return null;
    }

    private Property[] checkOntologyMakeObjectAndPredicate(Model mapModel, Model rdfModel, Rdf123Expression rdf123Exp, int row, Map<String, String[]> mapInstanceExp, Property predicate, RDFNode[] objectAry, String objectResourceURI) throws Exception {
        boolean retBoolean = true;
        Property predicateRDFType = null;
        if (predicate != null) {
            retBoolean = this.ontProcess(mapModel, rdfModel, rdf123Exp, row, mapInstanceExp, objectAry, objectResourceURI);
        }
        if (!retBoolean && predicate != null) {
            predicate = rdfModel.createProperty("http://eagle-i.org/ont/datatools/1.0/temp");
            predicateRDFType = RDF.type;
        }
        return new Property[]{predicate, predicateRDFType};
    }

    private boolean checkExpressionAndMakeSubjectResource(Model mapModel, String base, Rdf123Expression rdf123Exp, int row, Map<String, String[]> mapInstanceExp, Model tempModel, Resource subject, String subjectExpression) throws Exception {
        if (subjectExpression.matches("Ex:e\\+\\$\\d+") && !subjectExpression.startsWith("Ex:e+$0")) {
            String query = "";
            if (tempModel.toString().contains("http://xmlns.com/foaf/0.1/Person")) {
                query = ETLSPARQLQueryUtil.getEIResourcesByOnlyTypeANDRdfsLabel(tempModel);
                logger.debug((Object)query);
                String instance = this.provider.query(this.session, query.replace("\n", " ").replace("\r", " "));
                String[] instanceURI = ETLSPARQLQueryUtil.getInstanceURI(instance);
                this.pushIntoRepo(tempModel, mapInstanceExp, subject, subjectExpression, instanceURI);
                if (instanceURI != null) {
                    this.updateInstanceIfAdditionalDatafound(instanceURI[0], tempModel, subjectExpression);
                }
            } else {
                query = ETLSPARQLQueryUtil.getEIResourcesByAllPropertiesQuery(tempModel, this.getSession());
                logger.debug((Object)query);
                String instance = this.provider.query(this.session, query.replace("\n", " ").replace("\r", " "));
                String[] instanceURI = ETLSPARQLQueryUtil.getInstanceURI(instance);
                this.pushIntoRepo(tempModel, mapInstanceExp, subject, subjectExpression, instanceURI);
            }
            return true;
        }
        if (subjectExpression.matches("Ex:e\\+ont\\+\\$\\d+")) {
            String query = ETLSPARQLQueryUtil.getEIResourcesByAllPropertiesQuery(tempModel, this.getSession());
            logger.debug((Object)query);
            String instance = this.provider.query(this.session, query.replace("\n", " ").replace("\r", " "));
            String[] instanceURI = ETLSPARQLQueryUtil.getInstanceURI(instance);
            if (instanceURI != null) {
                this.putInMap(mapInstanceExp, subjectExpression, instanceURI[0]);
            } else {
                String[] strAry = this.getLabelAndRootURI(tempModel, row, rdf123Exp);
                String ontologyURI = this.checkOntology(rdf123Exp, row, strAry[0], strAry[1], mapModel);
                if (ontologyURI != null) {
                    this.putInMap(mapInstanceExp, subjectExpression, ontologyURI.toString());
                } else {
                    this.pushIntoRepo(tempModel, mapInstanceExp, subject, subjectExpression, ontologyURI);
                }
            }
            return true;
        }
        if (subjectExpression.startsWith("Ex:ont")) {
            String[] strAry = this.getLabelAndRootURI(tempModel, row, rdf123Exp);
            String strLabel = strAry[0];
            if (strLabel != null) {
                String instanceURI;
                if (strLabel.equalsIgnoreCase("Protocol")) {
                    strLabel = "Technique";
                }
                if (strLabel.equalsIgnoreCase("core facility")) {
                    strLabel = "Core Laboratory";
                }
                if (strLabel.equalsIgnoreCase("research facility")) {
                    strLabel = "Laboratory";
                }
                if (strLabel.equalsIgnoreCase("laboratory")) {
                    strLabel = "Laboratory";
                }
                if ((instanceURI = this.checkOntology(rdf123Exp, row, strLabel, strAry[1], mapModel)) == null) {
                    this.pushIntoRepo(tempModel, mapInstanceExp, subject, subjectExpression, strAry[1]);
                } else {
                    this.pushIntoRepo(tempModel, mapInstanceExp, subject, subjectExpression, instanceURI);
                }
                return true;
            }
            this.pushIntoRepo(tempModel, mapInstanceExp, subject, subjectExpression, strAry[1]);
            return true;
        }
        if (!subjectExpression.startsWith("Ex:e") && !subjectExpression.matches("Ex:ont") || subjectExpression.startsWith("Ex:")) {
            String result = rdf123Exp.evaluate(subjectExpression.substring("Ex:".length()), row);
            if (result != null) {
                if (!BasicUtils.isValidURL(result)) {
                    if (!JenaUtils.isValidRDFId(result) && !JenaUtils.isValidRDFId(result = result.replace(' ', '_'))) {
                        return false;
                    }
                    result = this.toURI(base, result);
                }
                subject = tempModel.createResource(result);
                this.putInMap(mapInstanceExp, subjectExpression, subject.getURI());
                return true;
            }
            return false;
        }
        return false;
    }

    private void pushIntoRepo(Model rdfModel, Map<String, String[]> mapInstanceExp, Resource subject, String subjectExpression, String[] instanceURI) throws Exception {
        if (instanceURI != null) {
            this.putInMap(mapInstanceExp, subjectExpression, instanceURI[0]);
        } else if (instanceURI == null) {
            StringWriter swriter = new StringWriter();
            rdfModel.write((Writer)swriter, "N-TRIPLE");
            if (oputputdirectory != null) {
                this.outputPrinter.println(swriter.toString());
            }
            this.addSourcefileTriple(rdfModel, subject);
            rdftorepo.pushtoRepo(rdfModel, this.getSession(), subject.getURI(), promoteParameter);
            this.putInMap(mapInstanceExp, subjectExpression, subject.getURI());
        }
    }

    private void pushIntoRepo(Model rdfModel, Map<String, String[]> mapInstanceExp, Resource subject, String subjectExpression, String instanceURI) throws Exception {
        if (instanceURI != null && mapInstanceExp.get(subjectExpression) == null) {
            this.putInMap(mapInstanceExp, subjectExpression, instanceURI);
        } else {
            this.putInMap(mapInstanceExp, subjectExpression, subject.getURI());
            StringWriter swriter = new StringWriter();
            rdfModel.write((Writer)swriter, "N-TRIPLE");
            if (oputputdirectory != null) {
                this.outputPrinter.println(swriter.toString());
            }
            this.addSourcefileTriple(rdfModel, subject);
            rdftorepo.pushtoRepo(rdfModel, this.getSession(), subject.getURI(), promoteParameter);
        }
    }

    private void addSourcefileTriple(Model rdfModel, Resource subject) {
        Property filePredicate = rdfModel.createProperty("http://eagle-i.org/ont/datatools/1.0/source_file");
        Literal fileObject = rdfModel.createLiteral(currentlyProcessingFile);
        rdfModel.add(subject, filePredicate, (RDFNode)fileObject);
    }

    private void putInMap(Map<String, String[]> mapInstanceExp, String key, String value) {
        String[] strAry = mapInstanceExp.get(key);
        if (strAry != null) {
            String[] newStrAry = new String[strAry.length + 1];
            int i = 0;
            String[] arr$ = strAry;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String str;
                newStrAry[i] = str = arr$[i$];
                ++i;
            }
            newStrAry[i] = value;
            mapInstanceExp.put(key, newStrAry);
        } else {
            mapInstanceExp.put(key, new String[]{value});
        }
    }

    private RDFNode[] getObject(Model rdfModel, Rdf123Expression rdf123Exp, RDFNode objectMap, Map<String, String[]> mapInstanceExp, int row, String subjectExpression) throws Exception {
        RDFNode[] objectAry = new RDFNode[30];
        if (objectMap instanceof Resource) {
            Resource objectResource = (Resource)objectMap;
            if (objectResource.isAnon()) {
                Resource object = rdfModel.createResource(new AnonId(objectResource.getId().toString() + row));
                objectAry[0] = object;
            } else if (objectResource.getURI().startsWith("Ex:e")) {
                if ((objectResource.getURI().matches("Ex:e\\+\\$\\d") || objectResource.getURI().matches("Ex:e\\+ont\\+\\$\\d+")) && !objectResource.getURI().matches("Ex:e\\+\\$0")) {
                    this.checkMapGetRdfNode(rdfModel, objectAry, mapInstanceExp, objectResource);
                } else if (objectResource.getURI().matches("Ex:e\\+\\$0")) {
                    if (this.eiurilst != null && mapInstanceExp.get("Ex:e+$0") == null) {
                        EIURI eiuri = this.eiurilst.get(this.count);
                        Resource object = rdfModel.createResource(eiuri.toString());
                        objectAry[0] = object;
                        this.putInMap(mapInstanceExp, "Ex:e+$0", eiuri.toString());
                    } else {
                        String[] strAry = mapInstanceExp.get("Ex:e+$0");
                        Resource object = rdfModel.createResource(strAry[0]);
                        objectAry[0] = object;
                    }
                }
            } else {
                Resource object = rdfModel.createResource(objectResource.getURI());
                objectAry[0] = object;
            }
        } else {
            Literal objectLiteral = (Literal)objectMap;
            RDFDatatype dataType = objectLiteral.getDatatype();
            if (dataType == null) {
                if (objectLiteral.getString().startsWith("Ex:")) {
                    String result = this.evaluateExpression(rdf123Exp, row, objectLiteral.getString());
                    String returnedStr = this.getTypeFromModelByObject(this.mapModel, subjectExpression);
                    if (returnedStr != null && returnedStr.contains("http://purl.org/dc/terms/")) {
                        result = this.wrapUsersofdcCreator(result);
                    }
                    if (result != null) {
                        Literal object = rdfModel.createTypedLiteral(result, (RDFDatatype)XSDDatatype.XSDstring);
                        objectAry[0] = object;
                    }
                } else {
                    RDFNode object;
                    objectAry[0] = object = objectMap;
                }
            } else {
                RDFNode object;
                objectAry[0] = object = objectMap;
            }
        }
        return objectAry;
    }

    private String wrapUsersofdcCreator(String result) throws ConfigurationException {
        if (this.dcCreatorMap.get(result.replace(" ", "")) != null) {
            return this.dcCreatorMap.get(result.replace(" ", ""));
        }
        return result;
    }

    private String evaluateExpression(Rdf123Expression rdf123Exp, int row, String objectString) throws Exception {
        String localName = objectString.substring("Ex:".length());
        if (localName.endsWith("^^string")) {
            String expression = localName.substring(0, localName.length() - 8);
            String result = rdf123Exp.evaluate(expression, row);
            if (result != null) {
                return result;
            }
            return null;
        }
        if (localName.endsWith("^^decimal")) {
            String expression = localName.substring(0, localName.length() - 9);
            String result = rdf123Exp.evaluate(expression, row);
            if (result != null) {
                return result;
            }
            return null;
        }
        if (localName.endsWith("^^integer")) {
            String expression = localName.substring(0, localName.length() - 9);
            String result = rdf123Exp.evaluate(expression, row);
            if (result != null) {
                return result;
            }
            return null;
        }
        if (localName.endsWith("^^float")) {
            String expression = localName.substring(0, localName.length() - 7);
            String result = rdf123Exp.evaluate(expression, row);
            if (result != null) {
                return result;
            }
            return null;
        }
        if (localName.endsWith("^^boolean")) {
            String expression = localName.substring(0, localName.length() - 9);
            String result = rdf123Exp.evaluate(expression, row);
            if (result != null) {
                return result;
            }
            return null;
        }
        if (localName.endsWith("^^time")) {
            String expression = localName.substring(0, localName.length() - 6);
            String result = rdf123Exp.evaluate(expression, row);
            if (result != null) {
                return result;
            }
            return null;
        }
        if (localName.endsWith("^^anyURI")) {
            String expression = localName.substring(0, localName.length() - 8);
            String result = rdf123Exp.evaluate(expression, row);
            if (result != null) {
                return result;
            }
            return null;
        }
        if (localName.endsWith("^^double")) {
            String expression = localName.substring(0, localName.length() - 8);
            String result = rdf123Exp.evaluate(expression, row);
            if (result != null) {
                return result;
            }
            return null;
        }
        if (localName.endsWith("^^int")) {
            String expression = localName.substring(0, localName.length() - 5);
            String result = rdf123Exp.evaluate(expression, row);
            if (result != null) {
                return result;
            }
            return null;
        }
        if (localName.endsWith("^^long")) {
            String expression = localName.substring(0, localName.length() - 6);
            String result = rdf123Exp.evaluate(expression, row);
            if (result != null) {
                return result;
            }
            return null;
        }
        if (localName.endsWith("^^short")) {
            String expression = localName.substring(0, localName.length() - 7);
            String result = rdf123Exp.evaluate(expression, row);
            if (result != null) {
                return result;
            }
            return null;
        }
        if (localName.endsWith("^^positiveInteger")) {
            String expression = localName.substring(0, localName.length() - 17);
            String result = rdf123Exp.evaluate(expression, row);
            if (result != null) {
                return result;
            }
            return null;
        }
        if (localName.endsWith("^^negativeInteger")) {
            String expression = localName.substring(0, localName.length() - 17);
            String result = rdf123Exp.evaluate(expression, row);
            if (result != null) {
                return result;
            }
            return null;
        }
        if (localName.endsWith("^^byte")) {
            String expression = localName.substring(0, localName.length() - 6);
            String result = rdf123Exp.evaluate(expression, row);
            if (result != null) {
                return result;
            }
            return null;
        }
        if (localName.endsWith("^^dateTime")) {
            String expression = localName.substring(0, localName.length() - 10);
            String result = rdf123Exp.evaluate(expression, row);
            if (result != null) {
                return result;
            }
            return null;
        }
        if (localName.endsWith("^^token")) {
            String expression = localName.substring(0, localName.length() - 7);
            String result = rdf123Exp.evaluate(expression, row);
            if (result != null) {
                return result;
            }
            return null;
        }
        if (localName.endsWith("^^language")) {
            String expression = localName.substring(0, localName.length() - 10);
            String result = rdf123Exp.evaluate(expression, row);
            if (result != null) {
                return result;
            }
            return null;
        }
        if (localName.endsWith("^^date")) {
            String expression = localName.substring(0, localName.length() - 6);
            String result = rdf123Exp.evaluate(expression, row);
            if (result != null) {
                return result;
            }
            return null;
        }
        if (localName.matches("\\$\\d+")) {
            String expression = localName;
            String result = rdf123Exp.evaluate(expression, row);
            if (result != null) {
                if (BasicUtils.isValidURL(result)) {
                    return result;
                }
                return result;
            }
            return null;
        }
        if (localName.matches("e\\+\\$\\d+")) {
            String expression = localName.split("\\+")[1];
            String result = rdf123Exp.evaluate(expression, row);
            if (result != null) {
                if (BasicUtils.isValidURL(result)) {
                    return result;
                }
                return result;
            }
            return null;
        }
        if (localName.matches("e\\+ont\\+\\$\\d+")) {
            String expression = localName.split("\\+")[2];
            String result = rdf123Exp.evaluate(expression, row);
            if (result != null) {
                if (BasicUtils.isValidURL(result)) {
                    return result;
                }
                return result;
            }
            return null;
        }
        if (localName.matches("ont\\+\\$\\d+")) {
            String expression = localName.split("\\+")[1];
            String result = rdf123Exp.evaluate(expression, row);
            if (result != null) {
                if (BasicUtils.isValidURL(result)) {
                    return result;
                }
                return result;
            }
            return null;
        }
        return objectString;
    }

    private void checkMapGetRdfNode(Model rdfModel, RDFNode[] objectAry, Map<String, String[]> mapInstanceExp, Resource objectResource) throws Exception {
        String[] strEiURIAry = mapInstanceExp.get(objectResource.getURI());
        if (strEiURIAry != null) {
            int i = 0;
            for (String strEIURI : strEiURIAry) {
                Resource object = rdfModel.createResource(strEIURI);
                objectAry[i] = object;
                ++i;
            }
        }
    }

    private Property getPredicate(Model rdfModel, Rdf123Expression rdf123Exp, Property predicateMap, int row) throws Exception {
        if (predicateMap.getURI().startsWith("Ex:")) {
            String result = rdf123Exp.evaluate(predicateMap.getURI().substring("Ex:".length()), row);
            if (result != null) {
                result.replace('$', ' ');
            }
            if (result != null) {
                return rdfModel.createProperty(result);
            }
            return null;
        }
        return predicateMap;
    }

    private boolean ontProcess(Model mapModel, Model rdfModel, Rdf123Expression rdf123Exp, int row, Map<String, String[]> mapInstanceExp, RDFNode[] objectAry, String objectResourceURI) throws Exception {
        String[] strAry = this.getLabelAndRootURI(rdfModel, row, rdf123Exp);
        String rootURI = strAry[1];
        String subclassLabel = strAry[0];
        if (subclassLabel == null) {
            return false;
        }
        if (subclassLabel.equalsIgnoreCase("core facility")) {
            subclassLabel = "core laboratory";
        }
        if (subclassLabel.equalsIgnoreCase("research facility")) {
            subclassLabel = "laboratory";
        }
        if (subclassLabel.equalsIgnoreCase("laboratory")) {
            subclassLabel = "laboratory";
        }
        String result = this.checkOntology(rdf123Exp, row, subclassLabel, rootURI, mapModel);
        logger.debug((Object)("Result from onlology :" + result));
        boolean retBoolean = false;
        if (result != null) {
            Resource object = rdfModel.createResource(result);
            objectAry[0] = object;
            retBoolean = true;
            return retBoolean;
        }
        this.putInMap(mapInstanceExp, objectResourceURI, "http://eagle-i.org/ont/dt/temporary/" + subclassLabel);
        Literal object = rdfModel.createLiteral(subclassLabel);
        objectAry[0] = object;
        retBoolean = false;
        return retBoolean;
    }

    private String checkOntology(Rdf123Expression rdf123Exp, int row, String label, String URI2, Model mapModel) throws Exception {
        String result = null;
        if (label != null) {
            result = this.anntModel.findSubclassByLabel(URI2, label.replace("  ", " ").trim());
        }
        return result;
    }

    public Map<String, DefaultTableModel> ExcelToTableModel(InputStream excelInputStream) throws Exception {
        Workbook wb;
        boolean TypeCellNum = false;
        try {
            wb = WorkbookFactory.create((InputStream)excelInputStream);
        }
        catch (FileNotFoundException e) {
            throw new ExcelParserException(e);
        }
        catch (InvalidFormatException e) {
            logger.error((Object)("Expecting an Excel file.." + (Object)((Object)e) + "Ignoring...."));
            return null;
        }
        catch (IOException e) {
            logger.error((Object)("IOExpecting an Excel file.." + e + "Ignoring...."));
            return null;
        }
        HashMap<String, DefaultTableModel> tableModelMap = new HashMap<String, DefaultTableModel>();
        int numBerOFSheets = wb.getNumberOfSheets();
        boolean globalColumns = false;
        String[] globalColumnsAry = null;
        String[] strGlobalColumnsOrderAry = null;
        for (int sheetNum = 0; sheetNum <= numBerOFSheets - 1; ++sheetNum) {
            Row row;
            int row2;
            Sheet sheet = wb.getSheetAt(sheetNum);
            logger.info((Object)("Reading " + sheet.getSheetName()));
            int rowcount = sheet.getLastRowNum();
            if (rowcount == 0) {
                logger.info((Object)"no Rows in sheet...ignoring");
                continue;
            }
            if (sheet.getRow(1) == null) continue;
            int colcount = sheet.getRow(1).getLastCellNum();
            double startRow = 0.0;
            double endRow = 0.0;
            int rowheadStart = 0;
            int k = 0;
            int headerRow = 0;
            endRow = sheet.getPhysicalNumberOfRows();
            boolean formVersionFound = false;
            if (sheet.getSheetName().equalsIgnoreCase("lab")) {
                int universityCellNum = 0;
                block5: while ((double)k <= endRow - 1.0) {
                    Row row3 = sheet.getRow(k);
                    Iterator cellIter = row3.cellIterator();
                    int cellNum = 0;
                    while (cellIter.hasNext()) {
                        Cell cell = (Cell)cellIter.next();
                        if (cell.getStringCellValue().contains("FORM VERSION")) {
                            universityCellNum = cellNum;
                            mapDirectory = mapDirectory + "/" + cell.getStringCellValue().split("FORM VERSION")[0].toLowerCase().trim();
                            formVersionFound = true;
                            headerRow = k;
                        }
                        if ((formVersionFound && cellNum == universityCellNum && k == headerRow + 1 || cell.getStringCellValue().matches("v\\d+")) && !cell.getStringCellValue().equals("")) {
                            mapDirectory = mapDirectory + "_" + cell.getStringCellValue().toLowerCase();
                            break block5;
                        }
                        ++cellNum;
                    }
                    ++k;
                }
            }
            Map<String, String> rowConfigMap = RowConfiguration.getRowInfoMap(mapDirectory, sheet.getSheetName());
            startRow = Integer.parseInt(rowConfigMap.get("startrow"));
            rowheadStart = Integer.parseInt(rowConfigMap.get("rowheadstart"));
            this.order = rowConfigMap.get("order");
            String strGlobalColumns = rowConfigMap.get("globalcolumnsorderinexcel");
            String strGlobalColumnsOrder = rowConfigMap.get("globalcolumnsorderintoCSV");
            if (strGlobalColumns != null && !globalColumns) {
                globalColumns = true;
                globalColumnsAry = strGlobalColumns.split("#");
                strGlobalColumnsOrderAry = strGlobalColumnsOrder.split("#");
                this.globalColumnsHash = new HashMap();
            }
            if (!this.order.toLowerCase().contains(sheet.getSheetName().toLowerCase())) continue;
            DefaultTableModel tableModel = new DefaultTableModel(rowcount + 1, colcount + 4);
            for (row2 = Configure.baseRow; row2 < rowcount; ++row2) {
                tableModel.setValueAt(String.valueOf(row2 + 1), row2, 0);
            }
            for (row2 = Configure.baseRow; row2 < rowcount; ++row2) {
                for (int col = Configure.baseCol; col < colcount + 1; ++col) {
                    tableModel.setValueAt(new String(""), row2, col);
                }
            }
            Iterator rowIter = sheet.rowIterator();
            if (rowIter.hasNext()) {
                Row row4 = (Row)rowIter.next();
                Iterator cellIter = row4.cellIterator();
                while (cellIter.hasNext()) {
                    Cell cell = (Cell)cellIter.next();
                    int rowNum = row4.getRowNum();
                    int colNum = cell.getColumnIndex();
                }
            }
            if (globalColumns && !sheet.getSheetName().equalsIgnoreCase("lab")) {
                tableModel.setColumnCount(tableModel.getColumnCount() + strGlobalColumnsOrderAry.length + 1);
            }
            int i = (int)startRow - 1;
            while ((double)i <= endRow - 1.0 && (row = sheet.getRow(i)) != null) {
                if (ExcelUtils.isBlankRow(row)) {
                    ++i;
                    continue;
                }
                Iterator cellIter = row.cellIterator();
                boolean rowProcessed = false;
                for (int tempLoop = 0; cellIter.hasNext() && tempLoop < colcount; ++tempLoop) {
                    Cell cell = (Cell)cellIter.next();
                    if (sheet.getSheetName().equalsIgnoreCase("lab") && globalColumns && tempLoop <= globalColumnsAry.length - 1) {
                        this.globalColumnsHash.put(globalColumnsAry[tempLoop], cell.getStringCellValue());
                    }
                    int rowNum = row.getRowNum();
                    int colNum = globalColumns && rowheadStart > 0 && rowNum >= rowheadStart && globalColumnsAry[0] != null && !sheet.getSheetName().equalsIgnoreCase("lab") ? cell.getColumnIndex() + strGlobalColumnsOrderAry.length : cell.getColumnIndex();
                    this.addCell(tableModel, cell, rowNum, colNum);
                }
                if (globalColumns && globalColumnsAry[0] != null && !sheet.getSheetName().equalsIgnoreCase("lab")) {
                    if (i == rowheadStart && globalColumnsAry.length > 0) {
                        int y = 0;
                        for (String s : globalColumnsAry) {
                            this.addCell(tableModel, s, i, y);
                            ++y;
                        }
                    } else if (i > rowheadStart && this.globalColumnsHash != null) {
                        int y = 0;
                        for (String strColumn : strGlobalColumnsOrderAry) {
                            this.addCell(tableModel, this.globalColumnsHash.get(strColumn), i, y);
                            ++y;
                        }
                    }
                }
                ++i;
            }
            tableModelMap.put(sheet.getSheetName(), tableModel);
        }
        return tableModelMap;
    }

    private void addCell(DefaultTableModel tableModel, Cell cell, int rowNum, int colNum) {
        try {
            tableModel.setValueAt(cell.getStringCellValue() + "", rowNum, colNum + Configure.baseCol);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw e;
        }
        catch (Exception e) {
            tableModel.setValueAt((int)cell.getNumericCellValue() + "", rowNum, colNum + Configure.baseCol);
        }
    }

    private void addCell(DefaultTableModel tableModel, String cellValue, int rowNum, int colNum) {
        tableModel.setValueAt(cellValue, rowNum, colNum + Configure.baseCol);
    }

    private String toURI(String base, String localname) {
        if (base.endsWith("/")) {
            return base + localname;
        }
        return base + "#" + localname;
    }

    public String[] getLabelAndRootURI(Model tempModel, int row, Rdf123Expression rdf123Exp) throws Exception {
        StmtIterator stmtIterator = tempModel.listStatements();
        String[] retString = new String[2];
        while (stmtIterator.hasNext()) {
            Statement stmtMap = stmtIterator.nextStatement();
            Resource subjectMap = stmtMap.getSubject();
            Property predicateMap = stmtMap.getPredicate();
            RDFNode objectMap = stmtMap.getObject();
            if (predicateMap.getURI().equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#type")) {
                retString[1] = objectMap.toString();
            }
            if (!predicateMap.getURI().equals("http://www.w3.org/2000/01/rdf-schema#label")) continue;
            if (!objectMap.isResource()) {
                String result;
                Literal objectLiteral = (Literal)objectMap;
                retString[0] = result = this.evaluateExpression(rdf123Exp, row, objectLiteral.getString());
                continue;
            }
            logger.error((Object)"its wrong");
        }
        return retString;
    }

    public String getLabelBySubjectExpression(Model tempModel, int row, Rdf123Expression rdf123Exp, String subjectExpression) throws Exception {
        StmtIterator stmtIterator = tempModel.listStatements();
        String retString = new String();
        while (stmtIterator.hasNext()) {
            String result;
            Statement stmtMap = stmtIterator.nextStatement();
            Resource subjectMap = stmtMap.getSubject();
            Property predicateMap = stmtMap.getPredicate();
            RDFNode objectMap = stmtMap.getObject();
            if (!subjectExpression.equals(subjectMap.toString()) || !predicateMap.getURI().equals("http://www.w3.org/2000/01/rdf-schema#label")) continue;
            Literal objectLiteral = (Literal)objectMap;
            retString = result = this.evaluateExpression(rdf123Exp, row, objectLiteral.getString());
        }
        return retString;
    }

    public String getObjectFromModelBySubjectAndType(Model rdfModel, String subjectExpression) {
        StmtIterator stmtIterator = rdfModel.listStatements();
        while (stmtIterator.hasNext()) {
            Statement stmtMap = stmtIterator.nextStatement();
            Resource subjectMap = stmtMap.getSubject();
            Property predicateMap = stmtMap.getPredicate();
            RDFNode objectMap = stmtMap.getObject();
            if (!subjectMap.toString().equals(subjectExpression) || !predicateMap.getURI().equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#type")) continue;
            return objectMap.toString();
        }
        return null;
    }

    public String getTypeFromModelByObject(Model rdfModel, String objectExpression) {
        StmtIterator stmtIterator = rdfModel.listStatements();
        while (stmtIterator.hasNext()) {
            Statement stmtMap = stmtIterator.nextStatement();
            Resource subjectMap = stmtMap.getSubject();
            Property predicateMap = stmtMap.getPredicate();
            RDFNode objectMap = stmtMap.getObject();
            if (!objectMap.toString().equals(objectExpression)) continue;
            return predicateMap.toString();
        }
        return null;
    }

    public void updateInstanceIfAdditionalDatafound(String instanceID, Model modelFromExcel, String subjectExpression) throws Exception {
        if (modelFromExcel == null) {
            return;
        }
        if (subjectExpression == null) {
            return;
        }
        if (instanceID == null) {
            return;
        }
        boolean foundNewResource = false;
        Resource subjectMap = modelFromExcel.createResource(instanceID);
        EIInstance instance = this.provider.getInstance(this.session, EIURI.create((String)instanceID));
        if (instance == null) {
            return;
        }
        Model modelFromRepo = EIInstanceFactory.getInstance().convertToJenaModel(instance);
        Model newModelofExtraData = ModelFactory.createDefaultModel();
        StmtIterator stmtIterator = modelFromExcel.listStatements();
        while (stmtIterator.hasNext()) {
            RDFNode objectMap;
            Statement stmtMap = stmtIterator.nextStatement();
            Property predicateMap = stmtMap.getPredicate();
            if (modelFromRepo.contains(subjectMap, predicateMap, objectMap = stmtMap.getObject()) || predicateMap.toString().contains("ERO_0000024") || instance.getReadOnlyResourceProperties().toString().contains(objectMap.toString())) continue;
            newModelofExtraData.add(subjectMap, predicateMap, objectMap);
            foundNewResource = true;
        }
        if (foundNewResource) {
            StmtIterator stmtFromExcelIterator = modelFromExcel.listStatements();
            while (stmtFromExcelIterator.hasNext()) {
                RDFNode objectMap;
                Statement stmtMap = stmtFromExcelIterator.nextStatement();
                Property predicateMap = stmtMap.getPredicate();
                if (newModelofExtraData.contains(subjectMap, predicateMap, objectMap = stmtMap.getObject()) || predicateMap.toString().contains("ERO_0000024")) continue;
                newModelofExtraData.add(subjectMap, predicateMap, objectMap);
            }
            StmtIterator stmtFromRepoIterator = modelFromRepo.listStatements();
            while (stmtFromRepoIterator.hasNext()) {
                Statement stmtMap = stmtFromRepoIterator.nextStatement();
                Property predicateMap = stmtMap.getPredicate();
                RDFNode objectMap = stmtMap.getObject();
                if (!predicateMap.toString().contains("ERO_0000024")) continue;
                newModelofExtraData.add(subjectMap, predicateMap, objectMap);
            }
            try {
                StringWriter swriter = new StringWriter();
                newModelofExtraData.write((Writer)swriter, "RDF/XML");
                logger.info((Object)("updating instance " + subjectMap));
                RESTRepositoryProvider restProvider = (RESTRepositoryProvider)this.provider;
                String token = restProvider.updateInstance(this.session, swriter.toString(), instanceID, null);
                restProvider.updateInstance(this.session, swriter.toString(), instanceID, token);
            }
            catch (EIDataToolsProviderException ei) {
                ei.printStackTrace();
            }
        }
    }
}

