/**
 * eagle-i Project
 * Harvard University
 * Apr 25, 2010
 */
package org.eaglei.datatools.interim.cores;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author Daniela Bourges-Waldegg
 *
 */
public class Mapping {
	public enum MappingType {CLASS, PROPERTY};
	public enum SourceType {TAB, COLUMN};
	
	private MappingType type;
	private SourceType sourceType;
	private String sourceID;
	private String targetNS;
	private String targetID;
	private String targetRangeURI; 
	private List<Mapping> mappings;
	//For getting a global view of all the mappings contained
	private Map <String, String> lookup;
	private Map <String, String> rangeLookup;
	public Mapping(MappingType type, SourceType sourceType, String sourceID, String targetNS, String targetID){
		this.type = type;
		this.sourceType = sourceType;
		this.sourceID = sourceID;
		this.targetNS = targetNS;
		this.targetID = targetID;
	}
	
	public Mapping(String sourceID, String targetNS, String targetID) {
		this(MappingType.PROPERTY, SourceType.COLUMN, sourceID, targetNS, targetID);
	}
	
	public Mapping(String sourceID, String targetNS, String targetID, String targetRangeURI) {
		this(MappingType.PROPERTY, SourceType.COLUMN, sourceID, targetNS, targetID);
		this.setTargetRangeURI(targetRangeURI);
	}
	
	
	public String getTargetUri() {
		if(targetNS.endsWith("/") || targetNS.endsWith("#"))
			return targetNS + targetID;
		else
			return targetNS + "/" + targetID;
	}	
	
	public String getTargetUri(String sourceID) {
		if(lookup != null)
			return(lookup.get(sourceID));
		else return null;
	}
	
	public void addMapping(Mapping mapping) {
		//Let's do this lazily
		if(mappings == null) mappings = new ArrayList<Mapping>();
		if(lookup == null) lookup = new HashMap<String, String>();
		if(rangeLookup == null) rangeLookup = new HashMap<String, String>();
		mappings.add(mapping);
		lookup.put(mapping.getSourceID(), mapping.getTargetUri());
		rangeLookup.put(mapping.getSourceID(), mapping.getTargetRangeURI());
	}
	
	public void addMapping(String sourceID, String targetNS, String targetID) {
		addMapping(new Mapping(sourceID, targetNS, targetID));
	}
	
	public void addMapping(String sourceID, String targetNS, String targetID, String targetRangeURI) {
		Mapping m = new Mapping(sourceID, targetNS, targetID);
		m.setTargetRangeURI(targetRangeURI);
		addMapping(m);
	}
	
	public List<Mapping> getMappings() {
		return mappings;
	}

	/**
	 * @return the type
	 */
	public MappingType getType() {
		return type;
	}

	/**
	 * @return the sourceType
	 */
	public SourceType getSourceType() {
		return sourceType;
	}

	/**
	 * @return the sourceID
	 */
	public String getSourceID() {
		return sourceID;
	}

	/**
	 * @return the targetNS
	 */
	public String getTargetNS() {
		return targetNS;
	}

	/**
	 * @return the targetID
	 */
	public String getTargetID() {
		return targetID;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "Mapping [type=" + type + 
		", sourceType=" + sourceType + 
		", sourceID=" + sourceID + 
		", targetNS=" + targetNS + 
		", targetID=" + targetID +
		", targetRangeURI=" + targetRangeURI +
		", mappings=" + mappings + 
		"]";
	}

	/**
	 * @return the targetRangeURI
	 */
	public String getTargetRangeURI() {
		return targetRangeURI;
	}
	
	public String getTargetRangeURI(String sourceID) {
		if(rangeLookup != null)
			return rangeLookup.get(sourceID);
		else return null;
	}

	/**
	 * @param targetRangeURI the targetRangeURI to set
	 */
	private void setTargetRangeURI(String targetRangeURI) {
		this.targetRangeURI = targetRangeURI;
	}
	
	
}
