/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.etl.server;

import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.eaglei.datatools.etl.server.RdfMaker;
import org.eaglei.datatools.model.AnnotationFormModel;
import org.eaglei.model.jena.JenaEIInstanceFactory;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class ETLEntryPoint {
    private static Logger logger = Logger.getLogger(ETLEntryPoint.class);
    private static String log;
    private static String repoConfigFileLocation;
    private static String mapsParentDirectoryPath;
    private static String excelFilesdirectoryPath;
    private static String outputdirectoryFile;
    private static String promoteParameter;
    private static String errorFileDirecotry;

    public static void main(String[] args) {
        ETLEntryPoint.setPromoteParameter("CURATION");
        ETLEntryPoint.setDirectory("");
        try {
            if (args.length > 0) {
                ETLEntryPoint.fillInputs(args);
                ETLEntryPoint.checkInputs();
                ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext(new String[]{"datatools-model-config.xml"});
                AnnotationFormModel anntModel = (AnnotationFormModel)context.getBean(AnnotationFormModel.class);
                JenaEIInstanceFactory instanceFactory = (JenaEIInstanceFactory)context.getBean(JenaEIInstanceFactory.class);
                RdfMaker rdfmaker = new RdfMaker(anntModel, instanceFactory);
                rdfmaker.rdfToRepoByExcelStream(excelFilesdirectoryPath, mapsParentDirectoryPath);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            logger.error((Object)"Exiting System");
            System.exit(2);
        }
    }

    private static void checkInputs() {
        if (ETLEntryPoint.getDirectory() == null) {
            logger.error((Object)"Excel Files location is not provided ,this input is mandatory");
            System.exit(2);
        }
        if (ETLEntryPoint.getRepoConfigFile() == null) {
            logger.error((Object)"Repository is not provided ,this input is mandatory");
            System.exit(2);
        }
        if (ETLEntryPoint.getMaps() == null) {
            logger.error((Object)"Maps location are not provided ,this input is mandatory");
            System.exit(2);
        }
        if (ETLEntryPoint.getLog() != null) {
            FileAppender appender = null;
            try {
                appender = new FileAppender((Layout)new PatternLayout(), log);
            }
            catch (Exception e) {
                logger.error((Object)"Cannot create Log file..ignoring");
            }
            logger.addAppender((Appender)appender);
        }
    }

    private static void fillInputs(String[] args) {
        for (int i = 0; i < args.length - 1; ++i) {
            if (args[i].equals("-d")) {
                ETLEntryPoint.setDirectory(args[++i]);
                continue;
            }
            if (args[i].equals("-o")) {
                ETLEntryPoint.setOutputdirectory(args[++i]);
                continue;
            }
            if (args[i].equals("-r")) {
                ETLEntryPoint.setRepoConfigFile(args[++i]);
                continue;
            }
            if (args[i].equals("-l")) {
                ETLEntryPoint.setLog(args[++i]);
                continue;
            }
            if (args[i].equals("-m")) {
                ETLEntryPoint.setMaps(args[++i]);
                continue;
            }
            if (args[i].equals("-p")) {
                ETLEntryPoint.setPromoteParameter(args[++i]);
                ETLEntryPoint.checkIfPromoteParameterIsCorrect();
                continue;
            }
            if (!args[i].equals("-e")) continue;
            ETLEntryPoint.setErrorFileDirecotry(args[++i]);
        }
    }

    private static void checkIfPromoteParameterIsCorrect() {
        if (!(ETLEntryPoint.getPromoteParameter().equalsIgnoreCase("publish") || ETLEntryPoint.getPromoteParameter().equalsIgnoreCase("curation") || ETLEntryPoint.getPromoteParameter().equalsIgnoreCase("draft"))) {
            logger.info((Object)"Parameter supplied for promote is not recognized..data  will be promoted to Curation by default");
            ETLEntryPoint.setPromoteParameter("curation");
        }
    }

    public static String getRepoConfigFile() {
        return repoConfigFileLocation;
    }

    public static void setRepoConfigFile(String repoConfigFileLocation) {
        ETLEntryPoint.repoConfigFileLocation = repoConfigFileLocation;
    }

    public static String getDirectory() {
        return excelFilesdirectoryPath;
    }

    public static void setDirectory(String directory) {
        excelFilesdirectoryPath = directory;
    }

    public static String getOutputdirectory() {
        return outputdirectoryFile;
    }

    public static void setOutputdirectory(String oputputdirectory) {
        outputdirectoryFile = oputputdirectory;
    }

    public static String getPromoteParameter() {
        return promoteParameter;
    }

    public static void setPromoteParameter(String promoteParameter) {
        ETLEntryPoint.promoteParameter = promoteParameter;
    }

    public static String getMaps() {
        return mapsParentDirectoryPath;
    }

    public static void setMaps(String maps) {
        mapsParentDirectoryPath = maps;
    }

    public static String getLog() {
        return log;
    }

    public static void setLog(String log) {
        ETLEntryPoint.log = log;
    }

    public static String getErrorFileDirecotry() {
        return errorFileDirecotry;
    }

    public static void setErrorFileDirecotry(String errorFileDirecotry) {
        ETLEntryPoint.errorFileDirecotry = errorFileDirecotry;
    }
}

