/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.etl.server;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.table.DefaultTableModel;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.eaglei.datatools.etl.server.EIFileParser;
import org.eaglei.datatools.etl.server.ExcelAbstractions;
import org.eaglei.datatools.etl.server.RowConfiguration;
import org.eaglei.datatools.etl.utils.Configure;
import org.eaglei.datatools.excel.ExcelParserException;
import org.eaglei.datatools.excel.ExcelUtils;

public class ExcelFileParser
extends EIFileParser<Map<String, ExcelAbstractions.ExcelTab>> {
    private static Logger logger = Logger.getLogger(ExcelFileParser.class);
    private static String FORM_VERSION_STRING = "FORM VERSION";
    private Map<String, Integer> numberOfRowsReadFromTabs;
    private String mapsParentDirecotryPath;
    private String[] tabOrder;
    private String[] globalColumnsOrderInExcel;
    private String[] globalColumnsOrderInCSV;
    private boolean globalColumns;
    private Sheet LAB_SHEET;
    private ExcelFileMetaData fileMetaData;

    public ExcelFileParser(String mapsParentDirecotryPath) {
        this.mapsParentDirecotryPath = mapsParentDirecotryPath;
        this.numberOfRowsReadFromTabs = new HashMap<String, Integer>();
        this.fileMetaData = new ExcelFileMetaData();
    }

    @Override
    public Map<String, ExcelAbstractions.ExcelTab> toCSV(InputStream excelInputStream) throws ConfigurationException, IOException, ParseException {
        Workbook wb = this.getWorkbookOfExcel(excelInputStream);
        HashMap<String, ExcelAbstractions.ExcelTab> ExcelTabNameToTabDataMap = new HashMap<String, ExcelAbstractions.ExcelTab>();
        this.LAB_SHEET = wb.getSheet("lab");
        String mapDirecotryPath = this.readMapDirectoryPathFromFile();
        this.setMapDirecotryPath(mapDirecotryPath);
        this.readConfigPropertiesOfFile();
        if (this.globalColumnsOrderInExcel != null && this.globalColumnsOrderInExcel.length > 1) {
            this.globalColumns = true;
        }
        HashMap<String, String> globalColumnsHash = new HashMap<String, String>();
        for (String sheetName : this.tabOrder) {
            Sheet sheet = wb.getSheet(sheetName);
            this.fileMetaData.sheetNameToSheetMetaData.put(sheetName, this.readSheetMetaData(sheet));
            if (sheet == null) {
                logger.info((Object)(sheetName + " is not present in excel tab ...continuing onto next tab"));
                continue;
            }
            logger.info((Object)("Reading " + sheet.getSheetName()));
            int rowcount = sheet.getLastRowNum();
            if (rowcount == 0) {
                logger.info((Object)"no Rows in sheet...ignoring");
                continue;
            }
            if (sheet.getRow(1) == null) continue;
            int colcount = sheet.getRow(1).getLastCellNum();
            double startRow = 0.0;
            double endRow = 0.0;
            int rowheadStart = 0;
            endRow = sheet.getPhysicalNumberOfRows();
            TabConfigProperites properties = this.readConfigPropertiesForTab(sheet);
            startRow = properties.getStartRow();
            ExcelAbstractions excelAbstractions = ExcelAbstractions.getInstance();
            excelAbstractions.getClass();
            ExcelAbstractions.ExcelTabData tabData = excelAbstractions.new ExcelAbstractions.ExcelTabData(1, colcount + 4);
            if (this.globalColumns && !sheet.getSheetName().equalsIgnoreCase("lab")) {
                tabData.setColumnCount(tabData.getColumnCount() + this.globalColumnsOrderInCSV.length + 1);
            }
            int i = (int)startRow - 1;
            int rowCount = 0;
            while ((double)i <= endRow - 1.0) {
                Row row = sheet.getRow(i);
                if (row == null) {
                    ++i;
                    continue;
                }
                if (ExcelUtils.isBlankRow(row)) {
                    ++i;
                    continue;
                }
                tabData.setRowCount(rowCount + 1);
                Iterator cellIter = row.cellIterator();
                int colNum = 0;
                for (int tempLoop = 0; cellIter.hasNext() && tempLoop < colcount; ++tempLoop) {
                    Cell cell = (Cell)cellIter.next();
                    if (sheet.getSheetName().equalsIgnoreCase("lab") && this.globalColumns && tempLoop <= this.globalColumnsOrderInExcel.length - 1) {
                        globalColumnsHash.put(this.globalColumnsOrderInExcel[tempLoop], cell.getStringCellValue());
                    }
                    int rowNum = rowCount;
                    colNum = this.globalColumns && rowNum >= rowheadStart && this.globalColumnsOrderInExcel[0] != null && !sheet.getSheetName().equalsIgnoreCase("lab") ? cell.getColumnIndex() + this.globalColumnsOrderInCSV.length : cell.getColumnIndex();
                    this.addCell((DefaultTableModel)tabData, cell, rowNum, colNum);
                }
                this.addGlobalColumnsToRow(globalColumnsHash, sheet, rowheadStart, tabData, i, rowCount);
                ++i;
                ++rowCount;
            }
            this.numberOfRowsReadFromTabs.put(sheet.getSheetName(), rowCount);
            ExcelAbstractions excelAbstractions2 = ExcelAbstractions.getInstance();
            excelAbstractions2.getClass();
            ExcelAbstractions.ExcelTab excelTab = excelAbstractions2.new ExcelAbstractions.ExcelTab(sheet.getSheetName(), tabData);
            ExcelTabNameToTabDataMap.put(sheet.getSheetName().toUpperCase(), excelTab);
        }
        return ExcelTabNameToTabDataMap;
    }

    private void addGlobalColumnsToRow(HashMap<String, String> globalColumnsHash, Sheet sheet, int rowheadStart, ExcelAbstractions.ExcelTabData tabData, int i, int rowCount) throws UnsupportedEncodingException {
        block2: {
            block3: {
                if (!this.globalColumns || this.globalColumnsOrderInExcel[0] == null || sheet.getSheetName().equalsIgnoreCase("lab")) break block2;
                if (i != rowheadStart || this.globalColumnsOrderInExcel.length <= 0) break block3;
                int y = 0;
                for (String s : this.globalColumnsOrderInCSV) {
                    this.addCell((DefaultTableModel)tabData, s, rowCount, y);
                    ++y;
                }
                break block2;
            }
            if (i <= rowheadStart || globalColumnsHash == null) break block2;
            int y = 0;
            for (String strColumn : this.globalColumnsOrderInCSV) {
                this.addCell((DefaultTableModel)tabData, globalColumnsHash.get(strColumn).toString(), rowCount, y);
                ++y;
            }
        }
    }

    private Workbook getWorkbookOfExcel(InputStream excelInputStream) {
        Workbook wb;
        try {
            wb = WorkbookFactory.create((InputStream)excelInputStream);
        }
        catch (FileNotFoundException e) {
            throw new ExcelParserException(e);
        }
        catch (InvalidFormatException e) {
            logger.error((Object)("Expecting an Excel file.." + (Object)((Object)e) + "Ignoring...."));
            throw new ExcelParserException(e);
        }
        catch (IOException e) {
            logger.error((Object)("IOExpecting an Excel file.." + e + "Ignoring...."));
            throw new ExcelParserException(e);
        }
        return wb;
    }

    @Override
    protected String readMapDirectoryPathFromFile() throws ParseException {
        return this.readMapDirectoryPathFromFile(this.LAB_SHEET);
    }

    private String readMapDirectoryPathFromFile(Sheet sheet) throws ParseException {
        String mapDirectoryName = "";
        String mapDirectoryVersion = "";
        boolean formVersionColumnFound = false;
        Row headerow = this.getHeaderRow(sheet);
        Iterator cellIter = headerow.cellIterator();
        int cellNum = 0;
        while (cellIter.hasNext()) {
            Row valueRow;
            Cell valuecell;
            Cell cell = (Cell)cellIter.next();
            if (cell.getStringCellValue().contains(FORM_VERSION_STRING)) {
                mapDirectoryName = cell.getStringCellValue().split(FORM_VERSION_STRING)[0].toLowerCase().trim();
                formVersionColumnFound = true;
            }
            if (formVersionColumnFound && !(valuecell = (valueRow = sheet.getRow(headerow.getRowNum() + 1)).getCell(cellNum)).getStringCellValue().equals("")) {
                mapDirectoryVersion = valuecell.getStringCellValue().toLowerCase();
                break;
            }
            ++cellNum;
        }
        return this.mapsParentDirecotryPath + "/" + mapDirectoryName + "_" + mapDirectoryVersion;
    }

    private Row getHeaderRow(Sheet sheet) throws ParseException {
        double endRow = 0.0;
        int k = 0;
        endRow = sheet.getPhysicalNumberOfRows();
        while ((double)k <= endRow - 1.0) {
            Row row = sheet.getRow(k);
            Iterator cellIter = row.cellIterator();
            while (cellIter.hasNext()) {
                Cell cell = (Cell)cellIter.next();
                if (!cell.getStringCellValue().contains(FORM_VERSION_STRING)) continue;
                return row;
            }
            ++k;
        }
        throw new ParseException("Header row not found in this Excel File", 0);
    }

    private SheetMetaData readSheetMetaData(Sheet sheet) throws ParseException {
        HashMap<String, Integer> columnNameToNumberMap = new HashMap<String, Integer>();
        SheetMetaData sheetMetaData = new SheetMetaData();
        int i = 1;
        if (this.globalColumns && !sheet.getSheetName().equalsIgnoreCase("lab")) {
            for (String globalColumnName : this.globalColumnsOrderInCSV) {
                columnNameToNumberMap.put(globalColumnName, i);
                ++i;
            }
        }
        Row headerow = this.getHeaderRow(sheet);
        Iterator cellIter = headerow.cellIterator();
        while (cellIter.hasNext()) {
            Cell cell = (Cell)cellIter.next();
            columnNameToNumberMap.put(cell.getStringCellValue(), i);
            ++i;
        }
        sheetMetaData.columnNameToRowNumberMap = columnNameToNumberMap;
        return sheetMetaData;
    }

    @Override
    protected void readConfigPropertiesOfFile() throws IOException, ConfigurationException {
        Map<String, String> rowConfigMap = RowConfiguration.getFormatingInfoOfFile(this.getMapDirecotryPath());
        String order = rowConfigMap.get("order");
        this.tabOrder = order.split("#");
        if (rowConfigMap.get("globalcolumnsorderinexcel") != null) {
            this.globalColumnsOrderInExcel = rowConfigMap.get("globalcolumnsorderinexcel").split("#");
        }
        if (rowConfigMap.get("globalcolumnsorderintoCSV") != null) {
            this.globalColumnsOrderInCSV = rowConfigMap.get("globalcolumnsorderintoCSV").split("#");
        }
    }

    protected TabConfigProperites readConfigPropertiesForTab(Sheet sheet) throws ConfigurationException {
        Map<String, String> rowConfigMap = RowConfiguration.getFormatingInfoOfRow(this.getMapDirecotryPath(), sheet.getSheetName());
        int startRow = Integer.parseInt(rowConfigMap.get("startrow"));
        return new TabConfigProperites(startRow, sheet.getSheetName());
    }

    private void addCell(DefaultTableModel tableModel, Cell cell, int rowNum, int colNum) {
        try {
            tableModel.setValueAt(new String(cell.getStringCellValue().replaceAll("_x[^_]*?_", "").getBytes(), "utf-8") + "", rowNum, colNum + Configure.baseCol);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw e;
        }
        catch (Exception e) {
            tableModel.setValueAt((int)cell.getNumericCellValue() + "", rowNum, colNum + Configure.baseCol);
        }
    }

    private void addCell(DefaultTableModel tableModel, String cellValue, int rowNum, int colNum) throws UnsupportedEncodingException {
        tableModel.setValueAt(new String(cellValue.replaceAll("_x[^_]*?_", "").getBytes(), "utf-8"), rowNum, colNum + Configure.baseCol);
    }

    public String[] getTabOrder() {
        return this.tabOrder;
    }

    public void setTabOrder(String[] tabOrder) {
        this.tabOrder = tabOrder;
    }

    public Map<String, Integer> getNumberOfRowsReadFromTabs() {
        return this.numberOfRowsReadFromTabs;
    }

    public EIFileParser.FileMetaData getMetaData() {
        return this.fileMetaData;
    }

    public class SheetMetaData {
        private Map<String, Integer> columnNameToRowNumberMap;

        public int getColumnNumberByColumnName(String columnName) {
            return this.columnNameToRowNumberMap.get(columnName);
        }

        public Map<String, Integer> getMapofColumnNameAndNumber() {
            return this.columnNameToRowNumberMap;
        }
    }

    public class ExcelFileMetaData
    implements EIFileParser.FileMetaData {
        private Map<String, SheetMetaData> sheetNameToSheetMetaData = new HashMap<String, SheetMetaData>();

        public SheetMetaData getSheetMetaData(String sheetName) {
            return this.sheetNameToSheetMetaData.get(sheetName);
        }
    }

    private class TabConfigProperites {
        int startRow;
        String tabName;

        TabConfigProperites(int startRow, String tabName) {
            this.startRow = startRow;
            this.tabName = tabName;
        }

        public int getStartRow() {
            return this.startRow;
        }

        public String getTabName() {
            return this.tabName;
        }
    }
}

