/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.etl.server;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eaglei.datatools.etl.server.ExcelAbstractions;
import org.eaglei.datatools.etl.server.Expression;
import org.eaglei.datatools.etl.server.ObjectLiteralExpression;
import org.eaglei.datatools.etl.server.OntologyExpression;
import org.eaglei.datatools.etl.server.RDFtoRepoService;
import org.eaglei.datatools.etl.server.RdfMaker;
import org.eaglei.datatools.etl.server.RdfMakerUtil;
import org.eaglei.datatools.etl.server.ResourceExpression;
import org.eaglei.datatools.etl.server.SemiColonExpresson;
import org.eaglei.datatools.etl.utils.Rdf123Expression;
import org.eaglei.datatools.model.AnnotationFormModel;

public class MapInterpreter
extends Expression<Statement[]> {
    private List<Expression> expressionList = new ArrayList<Expression>();
    private RDFtoRepoService rdftorepo = RdfMaker.getRdftorepo();
    private Model mapModel;
    private static Logger logger = Logger.getLogger(MapInterpreter.class);
    private Rdf123Expression rdf123Exp = null;
    public static final String PRIMARY_INSTANCE_EXPRESSION_MATCHER = "Ex:e+$0";
    private String expressionString;
    private Statement expressionStatement;
    private AnnotationFormModel anntModel;
    Resource mainNodesubject;

    public MapInterpreter(Model mapModel, ExcelAbstractions.ExcelTabData tabData, AnnotationFormModel anntModel) throws IOException {
        this.mapModel = mapModel;
        this.expressionString = PRIMARY_INSTANCE_EXPRESSION_MATCHER;
        this.anntModel = anntModel;
        this.expressionStatement = null;
        String base = this.rdftorepo.getDatatoolsConfiguration().getDatatoolsRepositoryNamespace();
        this.rdf123Exp = new Rdf123Expression(tabData, mapModel.getNsPrefixMap(), 1, base);
        this.evaluatePrimaryInstance(mapModel, tabData);
    }

    public MapInterpreter(Model primaryMapModel, Model secondaryModel, ExcelAbstractions.ExcelTabData tabData, String expressionString, Statement expressionStatement, AnnotationFormModel anntModel) throws IOException {
        this.mapModel = primaryMapModel;
        this.expressionString = expressionString;
        this.expressionStatement = expressionStatement;
        this.anntModel = anntModel;
        String base = this.rdftorepo.getDatatoolsConfiguration().getDatatoolsRepositoryNamespace();
        this.rdf123Exp = new Rdf123Expression(tabData, this.mapModel.getNsPrefixMap(), 1, base);
        this.evaluateSecondaryInstance(secondaryModel, tabData);
    }

    private void evaluatePrimaryInstance(Model mapModel, ExcelAbstractions.ExcelTabData tabData) {
        Model modelTocreateStatments = ModelFactory.createDefaultModel();
        this.mainNodesubject = RdfMakerUtil.getNewResourcesFromRepository(modelTocreateStatments, this.rdftorepo);
        StmtIterator subIter = mapModel.listStatements();
        while (subIter.hasNext()) {
            Statement stmtMap = subIter.nextStatement();
            Resource subjectMap = stmtMap.getSubject();
            RDFNode objectMap = stmtMap.getObject();
            Property property = stmtMap.getPredicate();
            Statement expToURIStatementMap = modelTocreateStatments.createStatement(this.mainNodesubject, property, objectMap);
            if (!subjectMap.getURI().equals(PRIMARY_INSTANCE_EXPRESSION_MATCHER)) continue;
            this.prepareExpressionStack(mapModel, tabData, expToURIStatementMap, objectMap);
        }
    }

    private void evaluateSecondaryInstance(Model submapModel, ExcelAbstractions.ExcelTabData tabData) {
        StmtIterator subIter = submapModel.listStatements();
        while (subIter.hasNext()) {
            Statement stmtMap = subIter.nextStatement();
            RDFNode objectMap = stmtMap.getObject();
            this.prepareExpressionStack(this.mapModel, tabData, stmtMap, objectMap);
        }
    }

    private void prepareExpressionStack(Model mapModel, ExcelAbstractions.ExcelTabData tabData, Statement stmtMap, RDFNode objectMap) {
        if (objectMap.toString().startsWith("Ex:e+$")) {
            ResourceExpression resourceExpression = new ResourceExpression(objectMap.toString(), this.rdf123Exp, tabData, stmtMap, mapModel, this.anntModel);
            this.expressionList.add(resourceExpression);
        } else if (objectMap.toString().startsWith("Ex:$")) {
            ObjectLiteralExpression objectExpression = new ObjectLiteralExpression(objectMap.toString(), this.rdf123Exp, stmtMap);
            this.expressionList.add(objectExpression);
        } else if (objectMap.toString().startsWith("Ex:ont+$")) {
            OntologyExpression ontologyExpression = new OntologyExpression(objectMap.toString(), this.rdf123Exp, stmtMap, mapModel, this.anntModel, tabData);
            this.expressionList.add(ontologyExpression);
        } else if (objectMap.toString().startsWith("Ex:emb")) {
            EmbeddedClassExpression embeddedClassExpression = new EmbeddedClassExpression(objectMap.toString(), tabData, stmtMap, mapModel);
            this.expressionList.add(embeddedClassExpression);
        } else {
            PlainStatementExpression plainStatementExpression = new PlainStatementExpression(stmtMap);
            this.expressionList.add(plainStatementExpression);
        }
    }

    @Override
    public Statement[] interpret(int row) {
        ArrayList<Statement> statementList = new ArrayList<Statement>();
        for (Expression expression : this.expressionList) {
            if (RdfMaker.stringToResourceMap.keySet().contains(expression.getExpressionString())) {
                Statement expressionStatement = expression.getExpressionStatement();
                List<Resource> lstResource = RdfMaker.stringToResourceMap.get(expression.getExpressionString());
                Model modelTocreateStatments = ModelFactory.createDefaultModel();
                for (Resource resource : lstResource) {
                    Statement newStatement = this.getExpressionStatement() == null ? modelTocreateStatments.createStatement(this.getMainSubject(), expressionStatement.getPredicate(), (RDFNode)resource) : modelTocreateStatments.createStatement((Resource)this.getExpressionStatement().getObject(), expressionStatement.getPredicate(), (RDFNode)resource);
                    statementList.add(newStatement);
                }
                continue;
            }
            Statement[] statementAry = (Statement[])expression.interpret(row);
            if (!(expression instanceof ObjectLiteralExpression || expression instanceof PlainStatementExpression || expression.getExpressionString().equals(PRIMARY_INSTANCE_EXPRESSION_MATCHER))) {
                for (Statement statement : statementAry) {
                    if (!statement.getPredicate().equals(expression.getExpressionStatement().getPredicate())) continue;
                    MapInterpreter.putInMap(RdfMaker.stringToResourceMap, expression.getExpressionString(), (Resource)statement.getObject());
                }
            }
            if (statementAry == null) continue;
            statementList.addAll(Arrays.asList(statementAry));
        }
        if (this.mainNodesubject != null) {
            return this.replaceMainNodeExpressionByMainNodeSubject(statementList);
        }
        return statementList.toArray(new Statement[statementList.size()]);
    }

    private Statement[] replaceMainNodeExpressionByMainNodeSubject(List<Statement> statementList) {
        Statement[] statementAryToReturn = new Statement[statementList.size()];
        int i = 0;
        for (Statement stmt : statementList) {
            Statement changedStatement;
            statementAryToReturn[i] = stmt.getObject().toString().equals(PRIMARY_INSTANCE_EXPRESSION_MATCHER) ? (changedStatement = stmt.changeObject((RDFNode)this.getMainSubject())) : stmt;
            ++i;
        }
        return statementAryToReturn;
    }

    public Resource getMainSubject() {
        return this.mainNodesubject;
    }

    @Override
    public String getExpressionString() {
        return this.expressionString;
    }

    @Override
    public Statement getExpressionStatement() {
        return this.expressionStatement;
    }

    private static void putInMap(Map<String, List<Resource>> mapInstanceExp, String key, Resource value) {
        List<Resource> strAry = mapInstanceExp.get(key);
        if (strAry != null) {
            strAry.add(value);
        } else {
            ArrayList<Resource> list = new ArrayList<Resource>();
            list.add(value);
            mapInstanceExp.put(key, list);
        }
    }

    class PlainStatementExpression
    extends Expression<Statement[]> {
        private Statement mapStatement;
        private Model mapModel;

        public PlainStatementExpression(Statement mapStatement) {
            this.mapStatement = mapStatement;
        }

        @Override
        public Statement[] interpret(int row) {
            return new Statement[]{this.mapStatement};
        }

        @Override
        public String getExpressionString() {
            return this.mapStatement.getObject().toString();
        }

        @Override
        public Statement getExpressionStatement() {
            return this.mapStatement;
        }
    }

    class EmbeddedClassExpression
    extends Expression<Statement[]> {
        public static final String EMBEDDED_CLASS_EXPRESSION_MATCHER = "Ex:emb";
        private String embeddedClassExpression;
        private ExcelAbstractions.ExcelTabData tabData;
        private Statement mapStatement;
        private Model mapModel;

        public EmbeddedClassExpression(String embeddedClassExpression, ExcelAbstractions.ExcelTabData tabData, Statement mapStatement, Model mapModel) {
            this.embeddedClassExpression = embeddedClassExpression;
            this.tabData = tabData;
            this.mapStatement = mapStatement;
            this.mapModel = mapModel;
        }

        @Override
        public Statement[] interpret(int row) {
            try {
                Model subNodeModel = RdfMakerUtil.getsubModelByExpression(this.embeddedClassExpression, this.mapModel);
                SemiColonExpresson semiColonExpression = new SemiColonExpresson(subNodeModel, MapInterpreter.this.rdf123Exp);
                Model[] modelAfterSemiColonInterpretation = semiColonExpression.interpret(row);
                ArrayList<Statement> statementList = new ArrayList<Statement>();
                for (Model model : modelAfterSemiColonInterpretation) {
                    MapInterpreter subNodeMapEvaluator = new MapInterpreter(this.mapModel, model, this.tabData, this.embeddedClassExpression, this.mapStatement, MapInterpreter.this.anntModel);
                    Statement[] statementAry = subNodeMapEvaluator.interpret(row);
                    if (statementAry == null || statementAry.length <= 1 || !RdfMakerUtil.isLabelPresentInMap(statementAry)) continue;
                    Resource subject = RdfMakerUtil.getNewResourcesFromRepository(subNodeModel, MapInterpreter.this.rdftorepo);
                    List<Statement> returnedstatementList = RdfMakerUtil.replaceExpressionWithURI(statementAry, subject, this.embeddedClassExpression);
                    Statement statementOfMainInstance = subNodeModel.createStatement(this.mapStatement.getSubject(), this.mapStatement.getPredicate(), (RDFNode)subject);
                    returnedstatementList.add(statementOfMainInstance);
                    statementList.addAll(returnedstatementList);
                }
                return statementList.toArray(new Statement[statementList.size()]);
            }
            catch (IOException ioe) {
                logger.error((Object)"IO Exception Occured in interpret method of EmbeddedClassExpression class");
                throw new RuntimeException(ioe);
            }
        }

        @Override
        public String getExpressionString() {
            return EMBEDDED_CLASS_EXPRESSION_MATCHER;
        }

        @Override
        public Statement getExpressionStatement() {
            return this.mapStatement;
        }
    }

    class ResourceOntologyExpression
    extends Expression<Statement[]> {
        public static final String RESOURCE_ONTOLOGY_EXPRESSION_MATCHER = "Ex:e+ont+$";
        private String resourceOntologyExpression;
        private ExcelAbstractions.ExcelTabData tabData;
        private Statement mapStatement;
        private Model mapModel;

        public ResourceOntologyExpression(String resourceOntologyExpression, ExcelAbstractions.ExcelTabData tabData, Statement mapStatement, Model mapModel) {
            this.resourceOntologyExpression = resourceOntologyExpression;
            this.tabData = tabData;
            this.mapStatement = mapStatement;
            this.mapModel = mapModel;
        }

        @Override
        public Statement[] interpret(int row) {
            return null;
        }

        @Override
        public String getExpressionString() {
            return this.resourceOntologyExpression;
        }

        @Override
        public Statement getExpressionStatement() {
            return this.mapStatement;
        }
    }
}

