/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.etl.server;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.eaglei.datatools.etl.server.ExcelAbstractions;
import org.eaglei.datatools.etl.server.Expression;
import org.eaglei.datatools.etl.server.MapInterpreter;
import org.eaglei.datatools.etl.server.RDFtoRepoService;
import org.eaglei.datatools.etl.server.RdfMaker;
import org.eaglei.datatools.etl.server.RdfMakerUtil;
import org.eaglei.datatools.etl.server.SemiColonExpresson;
import org.eaglei.datatools.etl.utils.Rdf123Expression;
import org.eaglei.datatools.model.AnnotationFormModel;

class OntologyExpression
extends Expression<Statement[]> {
    public static final String ONTOLOGY_EXPRESSION_MATCHER = "Ex:ont+$";
    private String ontologyExpression;
    private ExcelAbstractions.ExcelTabData tabData;
    private Statement mapStatement;
    private Model mapModel;
    private AnnotationFormModel anntModel;
    private Rdf123Expression rdf123Exp = null;
    private RDFtoRepoService rdftorepo;
    private static Logger logger = Logger.getLogger(OntologyExpression.class);

    public OntologyExpression(String ontologyExpression, Rdf123Expression rdf123Exp, Statement mapStatement, Model mapModel, AnnotationFormModel anntModel, ExcelAbstractions.ExcelTabData tabData) {
        this.ontologyExpression = ontologyExpression;
        this.mapStatement = mapStatement;
        this.mapModel = mapModel;
        this.rdf123Exp = rdf123Exp;
        this.rdftorepo = RdfMaker.getRdftorepo();
        this.anntModel = anntModel;
        this.tabData = tabData;
    }

    @Override
    public Statement[] interpret(int row) {
        Model subNodeMapModel = RdfMakerUtil.getsubModelByExpression(this.ontologyExpression, this.mapModel);
        SemiColonExpresson semiColonExpression = new SemiColonExpresson(subNodeMapModel, this.rdf123Exp);
        Model[] modelAfterSemiColonInterpretation = semiColonExpression.interpret(row);
        ArrayList<Statement> statementList = new ArrayList<Statement>();
        for (Model model : modelAfterSemiColonInterpretation) {
            Statement[] statementAry = this.interpretOntologyExpressionAfterSemicolon(row, model);
            if (statementAry == null) continue;
            statementList.addAll(Arrays.asList(statementAry));
        }
        return statementList.toArray(new Statement[statementList.size()]);
    }

    private Statement[] interpretOntologyExpressionAfterSemicolon(int row, Model subNodeMapModel) {
        try {
            String[] strAry = RdfMakerUtil.getLabelAndRootURI(subNodeMapModel, row, this.rdf123Exp);
            String strLabel = strAry[0];
            if (strLabel != null) {
                String instanceURI;
                if (strLabel.equalsIgnoreCase("Protocol")) {
                    strLabel = "Technique";
                }
                if (strLabel.equalsIgnoreCase("core facility")) {
                    strLabel = "Core Laboratory";
                }
                if (strLabel.equalsIgnoreCase("research facility")) {
                    strLabel = "Laboratory";
                }
                if (strLabel.equalsIgnoreCase("laboratory")) {
                    strLabel = "Laboratory";
                }
                if ((instanceURI = this.checkOntology(strLabel.toLowerCase(), strAry[1])) == null) {
                    return this.getStatementsWhenTermsNotFound(subNodeMapModel, strAry[1], strAry[0]);
                }
                Resource foundTermObject = subNodeMapModel.createResource(instanceURI);
                Statement statementToReturn = this.mapStatement.changeObject((RDFNode)foundTermObject);
                return new Statement[]{statementToReturn};
            }
            return new Statement[0];
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Statement[] getStatementsWhenTermsNotFound(Model subNodeMapModel, String instanceURI, String termLabel) {
        Resource typeObject = subNodeMapModel.createResource(instanceURI);
        Statement parentStatement = this.mapStatement.changeObject((RDFNode)typeObject);
        Property termNotFoundProperty = subNodeMapModel.createProperty("http://eagle-i.org/ont/datatools/1.0/temp_term_not_found");
        Statement unFoundTermStatement = subNodeMapModel.createStatement(this.mapStatement.getSubject(), termNotFoundProperty, termLabel);
        return new Statement[]{parentStatement, unFoundTermStatement};
    }

    private Statement[] getNewInstanceWithParentType(int row, Model subMapModel) {
        try {
            MapInterpreter subNodeMapEvaluator = new MapInterpreter(this.mapModel, subMapModel, this.tabData, this.ontologyExpression, this.mapStatement, this.anntModel);
            Statement[] statementAry = subNodeMapEvaluator.interpret(row);
            Resource subject = RdfMakerUtil.getNewResourcesFromRepository(subMapModel, this.rdftorepo);
            List<Statement> statementList = RdfMakerUtil.replaceExpressionWithURI(statementAry, subject, this.ontologyExpression);
            Statement statementOfMainInstance = subMapModel.createStatement(this.mapStatement.getSubject(), this.mapStatement.getPredicate(), (RDFNode)subject);
            statementList.add(statementOfMainInstance);
            return statementList.toArray(new Statement[statementList.size()]);
        }
        catch (IOException e) {
            logger.error((Object)"exception in the method getNewInstanceWithParentType of org.eaglei.datatools.etl.server.OntologyExpression class");
            throw new RuntimeException(e);
        }
    }

    private String checkOntology(String label, String URI2) throws Exception {
        String result = null;
        if (label != null) {
            result = this.anntModel.findSubclassByLabel(URI2, label.replace("  ", " ").trim());
        }
        if (result == null) {
            return URI2;
        }
        return result;
    }

    @Override
    public String getExpressionString() {
        return this.ontologyExpression;
    }

    @Override
    public Statement getExpressionStatement() {
        return this.mapStatement;
    }
}

