/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.etl.server;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.ParseException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.table.DefaultTableModel;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;
import org.eaglei.datatools.etl.server.EIFileParser;
import org.eaglei.datatools.etl.server.ETLEntryPoint;
import org.eaglei.datatools.etl.server.ETLSPARQLQueryUtil;
import org.eaglei.datatools.etl.server.ExcelAbstractions;
import org.eaglei.datatools.etl.server.ExcelFileParser;
import org.eaglei.datatools.etl.server.MapInterpreter;
import org.eaglei.datatools.etl.server.RDFtoRepoService;
import org.eaglei.datatools.etl.server.RdfMakerUtil;
import org.eaglei.datatools.etl.server.RowConfiguration;
import org.eaglei.datatools.etl.utils.Configure;
import org.eaglei.datatools.jena.RESTRepositoryProvider;
import org.eaglei.datatools.model.AnnotationFormModel;
import org.eaglei.datatools.provider.EIDataToolsProviderException;
import org.eaglei.datatools.provider.RepositoryProvider;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;
import org.eaglei.model.jena.JenaEIInstanceFactory;
import org.eaglei.security.Session;

public class RdfMaker {
    private static final long serialVersionUID = 1L;
    private static Model prefixModel = null;
    private Model mapModel = null;
    private int count = 0;
    private static Logger logger = Logger.getLogger(RdfMaker.class);
    private static String mapDirectoryPath;
    private static String currentlyProcessingFile;
    private static RDFtoRepoService rdftorepo;
    public static Map<String, List<Resource>> stringToResourceMap;
    private String[] tabOrder;
    private RepositoryProvider provider;
    private JenaEIInstanceFactory instanceFactory;
    private Session session;
    private PrintWriter outputPrinter;
    private PrintWriter errorPrinter;
    private AnnotationFormModel anntModel;
    private Map<String, String> dcCreatorMap = RowConfiguration.getdcCreatorFromRepoFile(ETLEntryPoint.getRepoConfigFile());
    private List<EIURI> eiurilst = null;
    private Map<String, Integer> numberOfRowsReadFromTabs;
    EIFileParser.FileMetaData fileMetaData;

    public int getCount() {
        return this.count;
    }

    public Session getSession() {
        return this.session;
    }

    public final void setSession(Session session) {
        this.session = session;
    }

    public RdfMaker(AnnotationFormModel anntModel, JenaEIInstanceFactory instanceFactory) throws Exception {
        this.instanceFactory = instanceFactory;
        this.anntModel = anntModel;
        int prefixCount = Configure.prefixArray.length;
        HashMap<String, String> predefinedPrefixes = new HashMap<String, String>();
        for (int row = 0; row < prefixCount; ++row) {
            predefinedPrefixes.put(Configure.prefixArray[row][0], Configure.prefixArray[row][1]);
        }
        prefixModel = ModelFactory.createDefaultModel();
        prefixModel.setNsPrefixes(predefinedPrefixes);
        int metaCount = Configure.metaArray.length;
        try {
            rdftorepo = RDFtoRepoService.getInstance(ETLEntryPoint.getRepoConfigFile(), instanceFactory);
            this.provider = rdftorepo.getRepositoryProvider();
        }
        catch (FileNotFoundException fe) {
            logger.error((Object)"Repository information file not found");
            logger.error((Object)fe);
            throw fe;
        }
        this.setSession(rdftorepo.login(ETLEntryPoint.getRepoConfigFile()));
        mapDirectoryPath = ETLEntryPoint.getMaps();
    }

    public boolean rdfToRepoByExcelStream(String excelFolder, String mapFolder) throws Exception {
        String[] lstFiles;
        HashMap<String, InputStream> mapIns = new HashMap<String, InputStream>();
        File excelDirectory = new File(excelFolder);
        if (!excelDirectory.isDirectory()) {
            logger.error((Object)(excelFolder + " is not a directory...exiting"));
            System.exit(2);
        }
        for (String str : lstFiles = excelDirectory.list()) {
            try {
                String[] lstMapFiles;
                Map<String, ExcelAbstractions.ExcelTab> defaultModelMap;
                InputStream is;
                if (!this.checkForExcelFiles(mapFolder, excelFolder, str) || (is = this.getInputStreamOfExcelFile(excelFolder, str)) == null || (defaultModelMap = this.ExcelToCSV(is)) == null) continue;
                File mapdirectory = null;
                mapdirectory = new File(mapDirectoryPath);
                for (String mapstr : lstMapFiles = mapdirectory.list()) {
                    if (mapstr.contains(".svn")) continue;
                    FileInputStream fis = new FileInputStream(mapDirectoryPath + "/" + mapstr);
                    mapIns.put(mapstr.replace(".rdf", ""), fis);
                }
                this.generateRDFGraph(defaultModelMap, mapIns);
                if (this.outputPrinter != null) {
                    this.outputPrinter.close();
                }
                if (this.errorPrinter != null) {
                    this.errorPrinter.close();
                }
                mapDirectoryPath = ETLEntryPoint.getMaps();
            }
            catch (Exception e) {
                logger.error((Object)e);
                e.printStackTrace();
                throw e;
            }
        }
        return true;
    }

    private boolean checkForExcelFiles(String mapFolder, String excelFolder, String fileName) throws Exception {
        if (!fileName.contains(".xlsx") && !fileName.contains(".xls")) {
            if (fileName.contains(".svn")) {
                return false;
            }
            File strFIle = new File(excelFolder + "/" + fileName);
            if (strFIle.isDirectory()) {
                this.rdfToRepoByExcelStream(excelFolder + "/" + fileName, mapFolder);
            } else {
                logger.info((Object)(fileName + "is not Excel file ...Ignoring"));
                return false;
            }
        }
        return true;
    }

    public InputStream getInputStreamOfExcelFile(String excelFolder, String excelFile) throws FileNotFoundException {
        FileOutputStream fvec;
        File dirfile = new File(excelFolder + "/" + excelFile);
        if (dirfile.isDirectory()) {
            logger.info((Object)(excelFolder + "/" + excelFile + "is directory ...Ignoring"));
            return null;
        }
        logger.info((Object)("processing file :" + excelFolder + "/" + excelFile));
        currentlyProcessingFile = excelFile;
        if (ETLEntryPoint.getOutputdirectory() != null) {
            fvec = new FileOutputStream(ETLEntryPoint.getOutputdirectory() + "/" + excelFile + ".rdf");
            this.outputPrinter = new PrintWriter(fvec);
        }
        if (ETLEntryPoint.getErrorFileDirecotry() != null) {
            fvec = new FileOutputStream(ETLEntryPoint.getErrorFileDirecotry() + "/" + excelFile + ".rdf");
            this.errorPrinter = new PrintWriter(fvec);
        }
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(excelFolder + "/" + excelFile));
        return is;
    }

    public Map<String, ExcelAbstractions.ExcelTab> ExcelToCSV(InputStream excelInputStream) throws ConfigurationException, IOException, ParseException {
        ExcelFileParser fileParser = new ExcelFileParser(ETLEntryPoint.getMaps());
        Object mapToReturn = fileParser.toCSV(excelInputStream);
        mapDirectoryPath = fileParser.getMapDirecotryPath();
        this.tabOrder = fileParser.getTabOrder();
        this.numberOfRowsReadFromTabs = fileParser.getNumberOfRowsReadFromTabs();
        this.fileMetaData = fileParser.getMetaData();
        return mapToReturn;
    }

    public Map<String, Model> generateRDFGraph(Map<String, ExcelAbstractions.ExcelTab> tableModelMap, Map<String, InputStream> mapStreamMap) throws IOException {
        HashMap<String, Model> retMap = new HashMap<String, Model>();
        StringWriter swriter = null;
        for (String keyStr : this.tabOrder) {
            if (!keyStr.equalsIgnoreCase("organisms")) continue;
            logger.info((Object)("Processing " + keyStr));
            ExcelAbstractions.ExcelTab excelTab = tableModelMap.get(keyStr.toUpperCase());
            ExcelAbstractions.ExcelTabData tableModel = excelTab.getTabData();
            if (tableModel == null) {
                logger.info((Object)(keyStr + " havent got anyrow skipping..."));
                continue;
            }
            InputStream mapStream = mapStreamMap.get(keyStr.toLowerCase());
            if (mapStream == null) continue;
            String base = rdftorepo.getDatatoolsConfiguration().getDatatoolsRepositoryNamespace();
            String syntax = "RDF/XML";
            ExcelFileParser.ExcelFileMetaData excelFileMetaData = (ExcelFileParser.ExcelFileMetaData)this.fileMetaData;
            InputStream mapStreamWithNumber = RdfMakerUtil.replaceColumnNamesWithColumnNumbers(mapStream, excelFileMetaData.getSheetMetaData(keyStr).getMapofColumnNameAndNumber());
            this.mapModel = ModelFactory.createDefaultModel();
            this.mapModel.read(mapStreamWithNumber, null, syntax);
            this.mapModel.removeNsPrefix("");
            boolean hasRowHead = true;
            int startRow = 0;
            int endRow = tableModel.getRowCount();
            this.count = 0;
            for (int row = startRow; row <= endRow; ++row) {
                long startTime = System.nanoTime();
                try {
                    int columnCount = tableModel.getColumnCount();
                    int columnsFilled = 0;
                    columnsFilled = this.checkForBlankRow(tableModel, row, columnCount, columnsFilled);
                    if (columnsFilled <= 0) continue;
                    HashSet<String> subjectSet = new HashSet<String>();
                    StmtIterator subIter = this.mapModel.listStatements();
                    this.getMainNodeSubjectSet(subjectSet, subIter);
                    stringToResourceMap = new HashMap<String, List<Resource>>();
                    MapInterpreter mapInterpretor = new MapInterpreter(this.mapModel, excelTab.getTabData(), this.anntModel);
                    Statement[] stmtAry = mapInterpretor.interpret(row);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Map of String Expression to URI");
                        for (Map.Entry<String, List<Resource>> entry : stringToResourceMap.entrySet()) {
                            logger.debug((Object)("the processed expressions are" + entry.getKey() + ":" + entry.getValue().toString()));
                        }
                    }
                    Model rdfModel = null;
                    rdfModel = ModelFactory.createDefaultModel();
                    rdfModel.setNsPrefixes(this.mapModel.getNsPrefixMap());
                    rdfModel.add(stmtAry);
                    logger.debug((Object)"the returned statements are");
                    for (Statement stmt : stmtAry) {
                        logger.debug((Object)stmt.toString());
                    }
                    Model mainRdfModel = null;
                    mainRdfModel = ModelFactory.createDefaultModel();
                    mainRdfModel.setNsPrefixes(this.mapModel.getNsPrefixMap());
                    List<String> lstResources = RdfMakerUtil.getReourceURIFromModel(rdfModel);
                    this.uploadSecondaryNodes(mapInterpretor, stmtAry, mainRdfModel, stringToResourceMap);
                    if (lstResources.size() == 1) {
                        mainRdfModel = rdfModel;
                    }
                    this.addSourcefileTriple(mainRdfModel, mapInterpretor.getMainSubject());
                    logger.info((Object)("pushing " + keyStr + " instance into repo"));
                    swriter = new StringWriter();
                    mainRdfModel.write((Writer)swriter, "RDF/XML");
                    logger.debug((Object)swriter);
                    if (ETLEntryPoint.getOutputdirectory() != null) {
                        this.outputPrinter.println(swriter.toString());
                    }
                    this.checkMainNodeAndPushToRepo(mainRdfModel, EIURI.create((String)mapInterpretor.getMainSubject().toString()), swriter);
                    logger.info((Object)(keyStr + " instance pushed into repo"));
                    ++this.count;
                }
                catch (Exception e) {
                    logger.error((Object)"Exception occured in generateRDFGraph() the stack trace is ");
                    logger.error((Object)Arrays.toString(e.getStackTrace()));
                    logger.error((Object)"............................skipping..............................");
                    if (ETLEntryPoint.getErrorFileDirecotry() == null || swriter == null) continue;
                    this.errorPrinter.println("       ");
                    this.errorPrinter.println(swriter.toString());
                    continue;
                }
                long endTime = System.nanoTime();
            }
            if (this.count % 50 != 0) continue;
            System.gc();
        }
        return retMap;
    }

    private int uploadSecondaryNodes(MapInterpreter mapInterpretor, Statement[] stmtAry, Model mainRdfModel, Map<String, List<Resource>> resourcesMap) throws Exception {
        int i = 0;
        StringWriter swriter = new StringWriter();
        List<Resource> embeddedResourceList = stringToResourceMap.get("Ex:emb");
        for (Map.Entry<String, List<Resource>> entry : stringToResourceMap.entrySet()) {
            if (entry.getKey().equals("Ex:emb") || entry.getKey().contains("Ex:ont+$")) continue;
            List<Resource> lstResources = entry.getValue();
            for (Resource resourceURI : lstResources) {
                try {
                    Model subRdfModel = ModelFactory.createDefaultModel();
                    subRdfModel.setNsPrefixes(this.mapModel.getNsPrefixMap());
                    for (Statement stmt : stmtAry) {
                        if (stmt.getSubject().toString().equals(resourceURI.getURI())) {
                            subRdfModel.add(stmt);
                            continue;
                        }
                        if (i >= 1 || embeddedResourceList == null || !stmt.getSubject().equals(mapInterpretor.getMainSubject()) && !embeddedResourceList.contains(stmt.getSubject())) continue;
                        mainRdfModel.add(stmt);
                    }
                    if (subRdfModel.isEmpty()) continue;
                    this.addSourcefileTriple(subRdfModel, subRdfModel.createResource(resourceURI.getURI()));
                    logger.info((Object)"pushing  sub-node instance into repo");
                    subRdfModel.write((Writer)swriter, "RDF/XML");
                    logger.debug((Object)swriter);
                    rdftorepo.pushtoRepo(subRdfModel, this.session, resourceURI.getURI(), ETLEntryPoint.getPromoteParameter());
                    ++i;
                }
                catch (Exception e) {
                    logger.error((Object)"Exception occured in uploadSecondaryNodes() the stack trace is ");
                    logger.error((Object)Arrays.toString(e.getStackTrace()));
                    logger.error((Object)"............................skipping..............................");
                    if (ETLEntryPoint.getErrorFileDirecotry() != null && swriter != null) {
                        this.errorPrinter.println("       ");
                        this.errorPrinter.println(swriter.toString());
                    }
                    throw e;
                }
            }
        }
        return i;
    }

    private void getMainNodeSubjectSet(Set<String> subjectSet, StmtIterator subIter) {
        while (subIter.hasNext()) {
            Statement stmtMap = subIter.nextStatement();
            Resource subjectMap = stmtMap.getSubject();
            if (subjectMap.getURI().equals("Ex:e+$0")) continue;
            subjectSet.add(subjectMap.getURI());
        }
    }

    private int checkForBlankRow(DefaultTableModel tableModel, int row, int columnCount, int columnsFilled) {
        try {
            for (int column = 0; column <= columnCount - 1; ++column) {
                if (tableModel.getValueAt(row, column) == null || tableModel.getValueAt(row, column).equals("")) continue;
                ++columnsFilled;
            }
            return columnsFilled;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return 0;
        }
    }

    private void checkMainNodeAndPushToRepo(Model rdfModel, EIURI eiuri, StringWriter swriter) throws Exception {
        try {
            String query = ETLSPARQLQueryUtil.getEIResourcesByOnlyTypeANDRdfsLabel(rdfModel);
            String instance = this.provider.query(this.session, query.replace("\n", " ").replace("\r", " "));
            String[] instanceURI = ETLSPARQLQueryUtil.getInstanceURI(instance);
            if (query != null && (instanceURI.length == 0 || !query.contains("ERO_0000001") && !query.contains("ERO_0000002"))) {
                rdftorepo.pushtoRepo(rdfModel, this.getSession(), eiuri.toString(), ETLEntryPoint.getPromoteParameter());
            }
        }
        catch (EIDataToolsProviderException ex) {
            logger.error((Object)ex.getMessage());
            logger.error((Object)("the offending instnace is " + swriter.toString()));
            logger.info((Object)"skiping...");
        }
    }

    private void addSourcefileTriple(Model rdfModel, Resource subject) {
        Property filePredicate = rdfModel.createProperty("http://eagle-i.org/ont/datatools/1.0/source_file");
        Literal fileObject = rdfModel.createLiteral(currentlyProcessingFile);
        rdfModel.add(subject, filePredicate, (RDFNode)fileObject);
    }

    public void updateInstanceIfAdditionalDatafound(String instanceID, Model modelFromExcel, String subjectExpression) throws Exception {
        if (modelFromExcel == null) {
            return;
        }
        if (subjectExpression == null) {
            return;
        }
        if (instanceID == null) {
            return;
        }
        boolean foundNewResource = false;
        Resource subjectMap = modelFromExcel.createResource(instanceID);
        EIInstance instance = this.provider.getInstance(this.session, EIURI.create((String)instanceID));
        if (instance == null) {
            return;
        }
        Model modelFromRepo = this.instanceFactory.convertToJenaModel(instance);
        Model newModelofExtraData = ModelFactory.createDefaultModel();
        StmtIterator stmtIterator = modelFromExcel.listStatements();
        while (stmtIterator.hasNext()) {
            RDFNode objectMap;
            Statement stmtMap = stmtIterator.nextStatement();
            Property predicateMap = stmtMap.getPredicate();
            if (modelFromRepo.contains(subjectMap, predicateMap, objectMap = stmtMap.getObject()) || predicateMap.toString().contains("ERO_0000024") || instance.getReadOnlyResourceProperties().toString().contains(objectMap.toString())) continue;
            newModelofExtraData.add(subjectMap, predicateMap, objectMap);
            foundNewResource = true;
        }
        if (foundNewResource) {
            StmtIterator stmtFromExcelIterator = modelFromExcel.listStatements();
            while (stmtFromExcelIterator.hasNext()) {
                RDFNode objectMap;
                Statement stmtMap = stmtFromExcelIterator.nextStatement();
                Property predicateMap = stmtMap.getPredicate();
                if (newModelofExtraData.contains(subjectMap, predicateMap, objectMap = stmtMap.getObject()) || predicateMap.toString().contains("ERO_0000024")) continue;
                newModelofExtraData.add(subjectMap, predicateMap, objectMap);
            }
            StmtIterator stmtFromRepoIterator = modelFromRepo.listStatements();
            while (stmtFromRepoIterator.hasNext()) {
                Statement stmtMap = stmtFromRepoIterator.nextStatement();
                Property predicateMap = stmtMap.getPredicate();
                RDFNode objectMap = stmtMap.getObject();
                if (!predicateMap.toString().contains("ERO_0000024")) continue;
                newModelofExtraData.add(subjectMap, predicateMap, objectMap);
            }
            try {
                StringWriter swriter = new StringWriter();
                newModelofExtraData.write((Writer)swriter, "RDF/XML");
                logger.info((Object)("updating instance " + subjectMap));
                RESTRepositoryProvider restProvider = (RESTRepositoryProvider)this.provider;
                String token = restProvider.updateInstance(this.session, swriter.toString(), instanceID, null);
                restProvider.updateInstance(this.session, swriter.toString(), instanceID, token);
            }
            catch (EIDataToolsProviderException ei) {
                ei.printStackTrace();
            }
        }
    }

    public static RDFtoRepoService getRdftorepo() {
        return rdftorepo;
    }
}

