/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.etl.utils;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class NamespaceManager {
    private static Hashtable mNamespaces = new Hashtable();

    private NamespaceManager() {
    }

    public static void addAll(Map m) {
        Set aSet = m.keySet();
        Iterator iter = aSet.iterator();
        while (iter.hasNext()) {
            String key = iter.next().toString();
            String value = m.get(key).toString();
            if (mNamespaces.containsKey(key)) continue;
            NamespaceManager.add(key, value);
        }
    }

    public static void add(String prefix, String url) {
        if (!mNamespaces.containsKey(prefix)) {
            mNamespaces.put(prefix, url);
        }
    }

    public static String getQNameFor(String id) {
        int slashIndex = id.lastIndexOf("/");
        int hashIndex = id.lastIndexOf("#");
        String name = null;
        String prefix = null;
        String ns = null;
        if (hashIndex == -1 && slashIndex == -1) {
            return id;
        }
        if (hashIndex == -1) {
            ns = id.substring(0, slashIndex);
            name = id.substring(slashIndex + 1);
            prefix = NamespaceManager.getPrefixForURI(ns);
            if (prefix == null) {
                int lastSlash = ns.lastIndexOf("/");
                prefix = ns.substring(lastSlash + 1);
                try {
                    Float.parseFloat(prefix);
                    int prevSlash = ns.substring(0, lastSlash).lastIndexOf("/");
                    prefix = ns.substring(prevSlash + 1, lastSlash) + "-" + prefix;
                }
                catch (Exception ex) {}
            }
        } else {
            ns = id.substring(0, hashIndex + 1);
            name = id.substring(hashIndex + 1);
            prefix = NamespaceManager.getPrefixForURI(ns);
            if (prefix == null && (prefix = ns.substring(ns.lastIndexOf("/") + 1, ns.length() - 1)).indexOf(".") != -1) {
                prefix = prefix.substring(0, prefix.lastIndexOf("."));
            }
        }
        if (!mNamespaces.containsKey(prefix)) {
            NamespaceManager.add(prefix, ns);
        }
        if (prefix.equals("")) {
            return name;
        }
        return prefix + ":" + name;
    }

    public static String getPrefixForURI(String url) {
        Enumeration e = mNamespaces.keys();
        boolean hasBlank = false;
        while (e.hasMoreElements()) {
            String prefix = e.nextElement().toString();
            String value = mNamespaces.get(prefix).toString();
            if (!value.equals(url)) continue;
            if (prefix.equals("")) {
                hasBlank = true;
                continue;
            }
            return prefix;
        }
        if (hasBlank) {
            return "";
        }
        return null;
    }

    public static String getURIForQName(String qname) {
        int split = qname.indexOf(":");
        String prefix = qname.substring(0, split);
        String url = (String)mNamespaces.get(prefix);
        if (url == null) {
            return null;
        }
        return url + qname.substring(split + 1);
    }

    public static void clear() {
        mNamespaces.clear();
    }
}

