/**
 * 
 */
package org.eaglei.datatools.etl.server;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.Map;

import javax.swing.table.DefaultTableModel;

import org.apache.commons.configuration.ConfigurationException;
import org.eaglei.datatools.etl.server.ExcelFileParser.SheetMetaData;

/**
 * @author Sravan Cheriyala
 * 
 */
public abstract class EIFileParser<I> {

	private String mapDirecotryPath;

	/**
	 * there are some format properties configured in properties file like order of tabs to process,global columns,global columns to appear in csv etc .These properties belong to entire File.readFormatConfigPropertiesOfFile reads the properties file
	 * and get the configuration parameters into class
	 */
	protected abstract void readConfigPropertiesOfFile() throws ConfigurationException, IOException;

	protected abstract String readMapDirectoryPathFromFile() throws ParseException;

	public abstract I toCSV(InputStream in) throws ConfigurationException, IOException, ParseException;

	public String getMapDirecotryPath() {
		return mapDirecotryPath;
	}

	public void setMapDirecotryPath(String mapDirecotryPath) {
		this.mapDirecotryPath = mapDirecotryPath;
	}

	public interface FileMetaData {
		

	}

	
}
