/**
 * 
 */
package org.eaglei.datatools.etl.server;

import org.apache.log4j.FileAppender;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.eaglei.datatools.model.AnnotationFormModel;
import org.eaglei.model.jena.JenaEIInstanceFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

/**
 * @author sc281
 * 
 */

public class ETLEntryPoint {
	private static org.apache.log4j.Logger logger = Logger.getLogger( ETLEntryPoint.class );
	private static String log;
	private static String repoConfigFileLocation;
	private static String mapsParentDirectoryPath;
	private static String excelFilesdirectoryPath;
	private static String outputdirectoryFile;
	private static String promoteParameter;
	private static String errorFileDirecotry;

	public static void main(String args[]) {
		setPromoteParameter( "CURATION" );
		setDirectory( "" );
		try {
			if ( args.length > 0 ) {
				fillInputs( args );
				checkInputs();
				// create and configure spring beans
				ApplicationContext context = new ClassPathXmlApplicationContext( new String[] { "datatools-model-config.xml" } );
				// retrieve configured instance
				AnnotationFormModel anntModel = context.getBean( AnnotationFormModel.class );
				JenaEIInstanceFactory instanceFactory = context.getBean( JenaEIInstanceFactory.class );

				RdfMaker rdfmaker = new RdfMaker( anntModel, instanceFactory );
				rdfmaker.rdfToRepoByExcelStream( excelFilesdirectoryPath, mapsParentDirectoryPath );
			}
		} catch (Exception e) {

			logger.error( e );
			logger.error( "Exiting System" );
			System.exit( 2 );
		}
	}

	private static void checkInputs() {
		if ( getDirectory() == null ) {
			logger.error( "Excel Files location is not provided ,this input is mandatory" );
			System.exit( 2 );
		}
		if ( getRepoConfigFile() == null ) {
			logger.error( "Repository is not provided ,this input is mandatory" );
			System.exit( 2 );
		}
		if ( getMaps() == null ) {
			logger.error( "Maps location are not provided ,this input is mandatory" );
			System.exit( 2 );
		}
		/* Logs if user supplied log output directory with -l option */
		if ( getLog() != null ) {
			FileAppender appender = null;
			try {
				appender = new FileAppender( new PatternLayout(), log );
			} catch (Exception e) {
				logger.error( "Cannot create Log file..ignoring" );
			}
			logger.addAppender( appender );
		}
	}

	private static void fillInputs(String[] args) {
		for (int i = 0; i < args.length - 1; i++) {
			if ( args[i].equals( "-d" ) ) {
				i = i + 1;
				setDirectory( args[i] );
			} else if ( args[i].equals( "-o" ) ) {
				i = i + 1;
				setOutputdirectory( args[i] );
			} else if ( args[i].equals( "-r" ) ) {
				i = i + 1;
				setRepoConfigFile( args[i] );
			} else if ( args[i].equals( "-l" ) ) {
				i = i + 1;
				setLog( args[i] );
			} else if ( args[i].equals( "-m" ) ) {
				i = i + 1;
				setMaps( args[i] );
			} else if ( args[i].equals( "-p" ) ) {
				i = i + 1;
				setPromoteParameter( args[i] );
				checkIfPromoteParameterIsCorrect();
			} else if ( args[i].equals( "-e" ) ) {
				i = i + 1;
				setErrorFileDirecotry( args[i] );
			}

		}
	}

	private static void checkIfPromoteParameterIsCorrect() {
		if ( !( getPromoteParameter().equalsIgnoreCase( "publish" ) || getPromoteParameter().equalsIgnoreCase( "curation" ) || getPromoteParameter().equalsIgnoreCase( "draft" ) ) ) {
			logger.info( "Parameter supplied for promote is not recognized..data  will be promoted to Curation by default" );
			setPromoteParameter( "curation" );
		}
	}

	public static String getRepoConfigFile() {
		return repoConfigFileLocation;
	}

	public static void setRepoConfigFile(String repoConfigFileLocation) {
		ETLEntryPoint.repoConfigFileLocation = repoConfigFileLocation;
	}

	public static String getDirectory() {
		return excelFilesdirectoryPath;
	}

	public static void setDirectory(String directory) {
		ETLEntryPoint.excelFilesdirectoryPath = directory;
	}

	public static String getOutputdirectory() {
		return outputdirectoryFile;
	}

	public static void setOutputdirectory(String oputputdirectory) {
		ETLEntryPoint.outputdirectoryFile = oputputdirectory;
	}

	public static String getPromoteParameter() {
		return promoteParameter;
	}

	public static void setPromoteParameter(String promoteParameter) {
		ETLEntryPoint.promoteParameter = promoteParameter;
	}

	public static String getMaps() {
		return mapsParentDirectoryPath;
	}

	public static void setMaps(String maps) {
		ETLEntryPoint.mapsParentDirectoryPath = maps;
	}

	public static String getLog() {
		return log;
	}

	public static void setLog(String log) {
		ETLEntryPoint.log = log;
	}

	public static String getErrorFileDirecotry() {
		return errorFileDirecotry;
	}

	public static void setErrorFileDirecotry(String errorFileDirecotry) {
		ETLEntryPoint.errorFileDirecotry = errorFileDirecotry;
	}

}
