/**
 * 
 */
package org.eaglei.datatools.etl.server;

import java.util.Vector;

import javax.swing.table.DefaultTableModel;

/**
 * @author sc281
 * 
 */

public class ExcelAbstractions {

	private static ExcelAbstractions	instance	= null;

	public static ExcelAbstractions getInstance() {
		if (instance == null) {
			instance = new ExcelAbstractions();
		}
		return instance;
	}

	private ExcelAbstractions() {

	}

	public class ExcelTab {

		private String			tabName;
		private ExcelTabData	tabData;

		public ExcelTab(String tabName, ExcelTabData tabData) {
			this.tabName = tabName;
			this.tabData = tabData;
		}

		@Override
		public String toString() {
			return tabName;
		}

		@Override
		public int hashCode() {
			return tabName.hashCode();
		}

		@Override
		public boolean equals(Object obj) {
			return tabName.equals(obj);
		}

		public String getTabName() {
			return tabName;
		}

		public ExcelTabData getTabData() {
			return tabData;
		}

		public void setTabData(ExcelTabData tabData) {
			this.tabData = tabData;
		}

	}

	/* abstration of excel tab content for readbilty */
	public class ExcelTabData extends DefaultTableModel {

		public ExcelTabData() {
			super();
		}

		public ExcelTabData(int rowCount, int columnCount) {
			super(rowCount, columnCount);
		}

		public ExcelTabData(Object[][] data, Object[] columnNames) {
			super(data, columnNames);
		}

		public ExcelTabData(Object[] columnNames, int rowCount) {
			super(columnNames, rowCount);
		}

		public ExcelTabData(Vector columnNames, int rowCount) {
			super(columnNames, rowCount);
		}

		public ExcelTabData(Vector data, Vector columnNames) {
			super(data, columnNames);
		}
	}

}
