/**
 * 
 */
package org.eaglei.datatools.etl.server;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

import org.apache.log4j.Logger;
import org.eaglei.datatools.etl.server.ExcelAbstractions.ExcelTabData;
import org.eaglei.datatools.etl.utils.Rdf123Expression;
import org.eaglei.datatools.model.AnnotationFormModel;
import org.eaglei.model.EIURI;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;

/**
 * @author Sravan Kumar Cheriyala
 * 
 *         Design Pattern Used:Interpretor Design Pattern
 * 
 *         FIXME:write more documentation
 */
public class MapInterpreter extends Expression<Statement[]> {

	private List<Expression> expressionList = new ArrayList<Expression>();
	private RDFtoRepoService rdftorepo;
	private Model mapModel;
	private static org.apache.log4j.Logger logger = Logger.getLogger( MapInterpreter.class );
	private Rdf123Expression rdf123Exp = null;
	public static final String PRIMARY_INSTANCE_EXPRESSION_MATCHER = "Ex:e+$0";
	private String expressionString;
	private Statement expressionStatement;
	private AnnotationFormModel anntModel;
	Resource mainNodesubject;

	public MapInterpreter(Model mapModel, ExcelTabData tabData, AnnotationFormModel anntModel) throws IOException {

		this.rdftorepo = RdfMaker.getRdftorepo();
		this.mapModel = mapModel;
		expressionString = PRIMARY_INSTANCE_EXPRESSION_MATCHER;
		this.anntModel = anntModel;
		expressionStatement = null;
		/* gets the base namespace from properties file */
		String base = rdftorepo.getDatatoolsConfiguration().getDatatoolsRepositoryNamespace();
		rdf123Exp = new Rdf123Expression( tabData, mapModel.getNsPrefixMap(), 1, base );
		evaluatePrimaryInstance( mapModel, tabData );
		

	}

	public MapInterpreter(Model primaryMapModel, Model secondaryModel, ExcelTabData tabData, String expressionString, Statement expressionStatement,AnnotationFormModel anntModel) throws IOException {

		this.rdftorepo = RdfMaker.getRdftorepo();
		this.mapModel = primaryMapModel;
		this.expressionString = expressionString;
		this.expressionStatement = expressionStatement;
		this.anntModel=anntModel;
		/* gets the base namespace from properties file */
		String base = rdftorepo.getDatatoolsConfiguration().getDatatoolsRepositoryNamespace();
		rdf123Exp = new Rdf123Expression( tabData, mapModel.getNsPrefixMap(), 1, base );
		evaluateSecondaryInstance( secondaryModel, tabData );

	}

	private void evaluatePrimaryInstance(Model mapModel, ExcelTabData tabData) {

		/* loop through the primary instance of map and prepare expression stack */
		Model modelTocreateStatments = ModelFactory.createDefaultModel();
		mainNodesubject = RdfMakerUtil.getNewResourcesFromRepository( modelTocreateStatments, rdftorepo );
		StmtIterator subIter = mapModel.listStatements();
		while ( subIter.hasNext() ) {
			Statement stmtMap = subIter.nextStatement();
			Resource subjectMap = stmtMap.getSubject();
			RDFNode objectMap = stmtMap.getObject();
			Property property = stmtMap.getPredicate();
			/* replace Ex:e+$0 with new instance URI */
			Statement expToURIStatementMap = modelTocreateStatments.createStatement( mainNodesubject, property, objectMap );
			/*
			 * if the statement is primary node statement then add that statement to the stack
			 */
			if ( subjectMap.getURI().equals( ResourceExpression.RESOURCE_EXPRESSION_MATCHER + "0" ) ) {
				prepareExpressionStack( mapModel, tabData, expToURIStatementMap, objectMap );
			}

		}
	}

	private void evaluateSecondaryInstance(Model submapModel, ExcelTabData tabData) {
		/*
		 * loop through the secondary instance of map and prepare expression stack
		 */
		StmtIterator subIter = submapModel.listStatements();
		while ( subIter.hasNext() ) {
			Statement stmtMap = subIter.nextStatement();
			RDFNode objectMap = stmtMap.getObject();
			prepareExpressionStack( mapModel, tabData, stmtMap, objectMap );

		}
	}

	private void prepareExpressionStack(Model mapModel, ExcelTabData tabData, Statement stmtMap, RDFNode objectMap) {

		if ( objectMap.toString().startsWith( ResourceExpression.RESOURCE_EXPRESSION_MATCHER ) ) {
			Expression<Statement[]> resourceExpression = new ResourceExpression( objectMap.toString(), rdf123Exp, tabData, stmtMap, mapModel,anntModel );
			expressionList.add( resourceExpression );
		} else if ( objectMap.toString().startsWith( ObjectLiteralExpression.OBJECT_LITERAL_EXPRESSION_MATCHER ) ) {
			Expression<Statement[]> objectExpression = new ObjectLiteralExpression( objectMap.toString(), rdf123Exp, stmtMap );
			expressionList.add( objectExpression );
		} else if ( objectMap.toString().startsWith( OntologyExpression.ONTOLOGY_EXPRESSION_MATCHER ) ) {
			Expression<Statement[]> ontologyExpression = new OntologyExpression( objectMap.toString(), rdf123Exp, stmtMap, mapModel, anntModel,tabData );
			expressionList.add( ontologyExpression );
		}// else if ( objectMap.toString().startsWith( ResourceOntologyExpression.RESOURCE_ONTOLOGY_EXPRESSION_MATCHER ) ) {
			//Expression<Statement[]> resourceOntologyExpresion = new ResourceOntologyExpression( objectMap.toString(), tabData, stmtMap, mapModel );
			//expressionList.add( resourceOntologyExpresion );
		//}
		  else if ( objectMap.toString().startsWith( EmbeddedClassExpression.EMBEDDED_CLASS_EXPRESSION_MATCHER ) ) {
			Expression<Statement[]> embeddedClassExpression = new EmbeddedClassExpression( objectMap.toString(), tabData, stmtMap, mapModel );
			expressionList.add( embeddedClassExpression );
		} else {
			Expression<Statement[]> plainStatementExpression = new PlainStatementExpression( stmtMap );
			expressionList.add( plainStatementExpression );
		}
	}

	@Override
	public Statement[] interpret(int row) {
		ArrayList<Statement> statementList = new ArrayList<Statement>();
		/* loop through expression stack and interpret that expression */
		for (Expression<Statement[]> expression : expressionList) {
			if ( RdfMaker.stringToResourceMap.keySet().contains( expression.getExpressionString() ) ) {
				Statement expressionStatement = expression.getExpressionStatement();
				List<Resource> lstResource = RdfMaker.stringToResourceMap.get( expression.getExpressionString() );
				Model modelTocreateStatments = ModelFactory.createDefaultModel();
				for (Resource resource : lstResource) {
					Statement newStatement;
					if ( this.getExpressionStatement() == null ) {
						newStatement = modelTocreateStatments.createStatement( this.getMainSubject(), expressionStatement.getPredicate(), (Resource)resource );
					} else {
						newStatement = modelTocreateStatments.createStatement( (Resource)this.getExpressionStatement().getObject(), expressionStatement.getPredicate(), (Resource)resource );
					}

					statementList.add( newStatement );
				}
				continue;
			}

			Statement[] statementAry = expression.interpret( row );

			if ( !( expression instanceof ObjectLiteralExpression ) && !( expression instanceof PlainStatementExpression ) && !expression.getExpressionString().equals( MapInterpreter.PRIMARY_INSTANCE_EXPRESSION_MATCHER ) ) {
				for (Statement statement : statementAry) {
					if ( statement.getPredicate().equals( expression.getExpressionStatement().getPredicate() ) ) {
						putInMap( RdfMaker.stringToResourceMap, expression.getExpressionString(), (Resource)statement.getObject() );
					}
				}
			}
			if ( statementAry == null ) {
				continue;
			}
			/*
			 * add the statement array to statement list which will be returned
			 */
			statementList.addAll( Arrays.asList( statementAry ) );

		}
		if ( mainNodesubject != null ) {
			return replaceMainNodeExpressionByMainNodeSubject( statementList );
		} else {
			return statementList.toArray( new Statement[statementList.size()] );
		}

	}

	private Statement[] replaceMainNodeExpressionByMainNodeSubject(List<Statement> statementList) {
		Statement[] statementAryToReturn = new Statement[statementList.size()];
		int i = 0;
		for (Statement stmt : statementList) {
			if ( stmt.getObject().toString().equals( MapInterpreter.PRIMARY_INSTANCE_EXPRESSION_MATCHER ) ) {
				Statement changedStatement = stmt.changeObject( this.getMainSubject() );
				statementAryToReturn[i] = changedStatement;
			} else {
				statementAryToReturn[i] = stmt;
			}

			i++;
		}
		return statementAryToReturn;
	}

	public Resource getMainSubject() {
		return mainNodesubject;
	}

	class ResourceOntologyExpression extends Expression<Statement[]> {

		public static final String RESOURCE_ONTOLOGY_EXPRESSION_MATCHER = "Ex:e+ont+$";
		private String resourceOntologyExpression;
		private ExcelTabData tabData;
		private Statement mapStatement;
		private Model mapModel;

		public ResourceOntologyExpression(String resourceOntologyExpression, ExcelTabData tabData, Statement mapStatement, Model mapModel) {
			this.resourceOntologyExpression = resourceOntologyExpression;
			this.tabData = tabData;
			this.mapStatement = mapStatement;
			this.mapModel = mapModel;

		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.eaglei.datatools.etl.server.CSVToRDFGraph.AbstractExpression# Interpret (org.eaglei.datatools.etl.server.ExcelAbstractions.ExcelTabData, int, com.clarkparsia.pellint.rdfxml.RDFModel)
		 */
		@Override
		public Statement[] interpret(int row) {
			// System.out.println( "in ResourceOntologyExpression" );
			return null;

		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.eaglei.datatools.etl.server.Expression#getExpressionString()
		 */
		@Override
		public String getExpressionString() {

			return resourceOntologyExpression;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.eaglei.datatools.etl.server.Expression#getExpressionStatement()
		 */
		@Override
		public Statement getExpressionStatement() {
			// TODO Auto-generated method stub
			return mapStatement;
		}

	}

	class EmbeddedClassExpression extends Expression<Statement[]> {

		public static final String EMBEDDED_CLASS_EXPRESSION_MATCHER = "Ex:emb";

		private String embeddedClassExpression;
		private ExcelTabData tabData;
		private Statement mapStatement;
		private Model mapModel;

		public EmbeddedClassExpression(String embeddedClassExpression, ExcelTabData tabData, Statement mapStatement, Model mapModel) {
			this.embeddedClassExpression = embeddedClassExpression;
			this.tabData = tabData;
			this.mapStatement = mapStatement;
			this.mapModel = mapModel;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.eaglei.datatools.etl.server.MapInterpreter.Expression#interpret (org.eaglei.datatools.etl.server.ExcelAbstractions.ExcelTabData, int)
		 */
		@Override
		public Statement[] interpret(int row) {
			try {

				Model subNodeModel = RdfMakerUtil.getsubModelByExpression( embeddedClassExpression, mapModel );
				/* if there is semicolon on excel data then process that. */
				SemiColonExpresson semiColonExpression = new SemiColonExpresson( subNodeModel, rdf123Exp );
				Model[] modelAfterSemiColonInterpretation = semiColonExpression.interpret( row );
				ArrayList<Statement> statementList = new ArrayList<Statement>();

				/*
				 * if there is really a semicolon then above semiColonExpression returns the Model array ,each Model is for each string separated by semicolon
				 */
				for (Model model : modelAfterSemiColonInterpretation) {
					MapInterpreter subNodeMapEvaluator = new MapInterpreter( mapModel, model, tabData, embeddedClassExpression, mapStatement,anntModel );
					Statement[] statementAry = subNodeMapEvaluator.interpret( row );
					if ( statementAry == null || statementAry.length <= 1 || !RdfMakerUtil.isLabelPresentInMap( statementAry ) ) {
						continue;
					}
					/* replace Secondary instance Expression with new instance URI */
					Resource subject = RdfMakerUtil.getNewResourcesFromRepository( subNodeModel, rdftorepo );
					List<Statement> returnedstatementList=	RdfMakerUtil.replaceExpressionWithURI( statementAry, subject, embeddedClassExpression );
					Statement statementOfMainInstance = subNodeModel.createStatement( mapStatement.getSubject(), mapStatement.getPredicate(), subject );
					returnedstatementList.add(statementOfMainInstance);
					statementList.addAll(returnedstatementList);

				}


				return statementList.toArray( new Statement[statementList.size()] );
			}// FIXME: temporarly throwing Runtime exception until we find better solution on how to handle exceptions
			catch (IOException ioe) {
				logger.error( "IO Exception Occured in interpret method of EmbeddedClassExpression class" );
				throw new RuntimeException( ioe );
			}

		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.eaglei.datatools.etl.server.Expression#getExpressionString()
		 */
		@Override
		public String getExpressionString() {

			return EMBEDDED_CLASS_EXPRESSION_MATCHER;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.eaglei.datatools.etl.server.Expression#getExpressionStatement()
		 */
		@Override
		public Statement getExpressionStatement() {
			// TODO Auto-generated method stub
			return mapStatement;
		}

	}

	class PlainStatementExpression extends Expression<Statement[]> {

		private Statement mapStatement;
		private Model mapModel;

		public PlainStatementExpression(Statement mapStatement) {
			this.mapStatement = mapStatement;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.eaglei.datatools.etl.server.Expression#interpret(int)
		 */
		@Override
		public Statement[] interpret(int row) {
			return new Statement[] { mapStatement };
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.eaglei.datatools.etl.server.Expression#getExpressionString()
		 */
		@Override
		public String getExpressionString() {
			// TODO Auto-generated method stub
			return mapStatement.getObject().toString();
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.eaglei.datatools.etl.server.Expression#getSubjectResourceOfExpression()
		 */
		@Override
		public Statement getExpressionStatement() {
			// TODO Auto-generated method stub
			return mapStatement;
		}

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eaglei.datatools.etl.server.Expression#getExpressionString()
	 */
	@Override
	public String getExpressionString() {

		return expressionString;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eaglei.datatools.etl.server.Expression#getSubjectResourceOfExpression()
	 */
	@Override
	public Statement getExpressionStatement() {

		return expressionStatement;
	}

	private static void putInMap(Map<String, List<Resource>> mapInstanceExp, String key, Resource value) {
		List<Resource> strAry = mapInstanceExp.get( key );
		if ( strAry != null ) {
			strAry.add( value );
		} else {
			List<Resource> list = new ArrayList<Resource>();
			list.add( value );
			mapInstanceExp.put( key, list );
		}
	}

}
