package org.eaglei.datatools.etl.server;

import org.apache.log4j.Logger;
import org.eaglei.datatools.etl.server.ExcelAbstractions.ExcelTabData;
import org.eaglei.datatools.etl.utils.Rdf123Expression;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;

class ObjectLiteralExpression extends Expression<Statement[]> {

	private String literalExpression;
	private ExcelTabData tabData;
	private Statement mapStatement;
	public static final String OBJECT_LITERAL_EXPRESSION_MATCHER = "Ex:$";
	private static org.apache.log4j.Logger logger = Logger.getLogger( ObjectLiteralExpression.class );
	private Rdf123Expression rdf123Exp = null;

	public ObjectLiteralExpression(String literalExpression, Rdf123Expression rdf123Exp, Statement mapStatement) {
		this.literalExpression = literalExpression;
		this.tabData = tabData;
		this.mapStatement = mapStatement;
		this.rdf123Exp = rdf123Exp;

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eaglei.datatools.etl.server.CSVToRDFGraph.AbstractExpression# Interpret (org.eaglei.datatools.etl.server.ExcelAbstractions.ExcelTabData, int, com.clarkparsia.pellint.rdfxml.RDFModel)
	 */
	@Override
	public Statement[] interpret(int row) {
		try {
			String result = RdfMakerUtil.evaluateExpression( rdf123Exp, row, literalExpression.toString() );
			if ( result == null ) {
				return null;
			}
			Model m = ModelFactory.createDefaultModel();

			String[] stringAry = result.split( ";" );
			Statement[] statementAry = new Statement[stringAry.length];
			int i = 0;
			for (String resultStr : stringAry) {
				Statement stmt = m.createStatement( mapStatement.getSubject(), mapStatement.getPredicate(), resultStr );
				statementAry[i] = stmt;
				i++;
			}

			return statementAry;

			// FIXME: temporarly throwing Runtime exception until we find better solution on how to handle exceptions
		} catch (Exception e) {
			logger.error( "Exception has raised in ObjectLiteralExpression's interpret method" );
			e.printStackTrace();
			throw new RuntimeException( e );
		}

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eaglei.datatools.etl.server.Expression#getExpressionString()
	 */
	@Override
	public String getExpressionString() {
		// TODO Auto-generated method stub
		return literalExpression;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eaglei.datatools.etl.server.Expression#getExpressionStatement()
	 */
	@Override
	public Statement getExpressionStatement() {
		// TODO Auto-generated method stub
		return mapStatement;
	}

}
