package org.eaglei.datatools.etl.server;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.log4j.Logger;
import org.eaglei.datatools.etl.server.ExcelAbstractions.ExcelTabData;
import org.eaglei.datatools.etl.utils.Rdf123Expression;
import org.eaglei.datatools.model.AnnotationFormModel;
import org.eaglei.datatools.model.DataToolsOntConstants;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;

class OntologyExpression extends Expression<Statement[]> {

	public static final String ONTOLOGY_EXPRESSION_MATCHER = "Ex:ont+$";
	private String ontologyExpression;
	private ExcelTabData tabData;
	private Statement mapStatement;
	private Model mapModel;
	private AnnotationFormModel anntModel;
	private Rdf123Expression rdf123Exp = null;
	private RDFtoRepoService rdftorepo;
	private static org.apache.log4j.Logger logger = Logger.getLogger( OntologyExpression.class );

	public OntologyExpression(String ontologyExpression, Rdf123Expression rdf123Exp, Statement mapStatement, Model mapModel, AnnotationFormModel anntModel, ExcelTabData tabData) {
		this.ontologyExpression = ontologyExpression;
		this.mapStatement = mapStatement;
		this.mapModel = mapModel;
		this.rdf123Exp = rdf123Exp;
		this.rdftorepo = RdfMaker.getRdftorepo();
		this.anntModel = anntModel;
		this.tabData = tabData;

	}

	public Statement[] interpret(int row) {
		Model subNodeMapModel = RdfMakerUtil.getsubModelByExpression( ontologyExpression, mapModel );
		/* if there is semicolon on excel data then process that. */
		SemiColonExpresson semiColonExpression = new SemiColonExpresson( subNodeMapModel, rdf123Exp );
		Model[] modelAfterSemiColonInterpretation = semiColonExpression.interpret( row );
		ArrayList<Statement> statementList = new ArrayList<Statement>();

		/*
		 * if there is really a semicolon then above semiColonExpression returns the Model array ,each Model is for each string separated by semicolon
		 */
		for (Model model : modelAfterSemiColonInterpretation) {
			Statement[] statementAry = interpretOntologyExpressionAfterSemicolon( row, model );
			if ( statementAry == null ) {
				continue;
			}
			/*
			 * add the returned statement array to statement list which will be returned
			 */
			statementList.addAll( Arrays.asList( statementAry ) );
		}
		return statementList.toArray( new Statement[statementList.size()] );
	}

	private Statement[] interpretOntologyExpressionAfterSemicolon(int row, Model subNodeMapModel) {

		try {
			// Model subNodeMapModel = RdfMakerUtil.getsubModelByExpression( ontologyExpression, mapModel );
			String[] strAry = RdfMakerUtil.getLabelAndRootURI( subNodeMapModel, row, rdf123Exp );
			String strLabel = strAry[0];
			if ( strLabel != null ) {
				// FIXME:hardcoded comparision of the String
				if ( strLabel.equalsIgnoreCase( "Protocol" ) ) {
					strLabel = "Technique";
				}
				if ( strLabel.equalsIgnoreCase( "core facility" ) ) {
					strLabel = "Core Laboratory";
				}
				if ( strLabel.equalsIgnoreCase( "research facility" ) ) {
					strLabel = "Laboratory";
				}
				if ( strLabel.equalsIgnoreCase( "laboratory" ) ) {
					strLabel = "Laboratory";
				}
				String instanceURI = checkOntology( strLabel.toLowerCase(), strAry[1] );
				if ( instanceURI == null ) {
					return getStatementsWhenTermsNotFound( subNodeMapModel, strAry[1], strAry[0] );
				} else {
					RDFNode foundTermObject = subNodeMapModel.createResource( instanceURI );
					Statement statementToReturn = mapStatement.changeObject( foundTermObject );
					return new Statement[] { statementToReturn };
				}

			} else {
				return new Statement[] {};
			}
		}// FIXME:temporary until we find better way to handle exceptions
		catch (Exception e) {
			throw new RuntimeException( e );
		}

	}

	private Statement[] getStatementsWhenTermsNotFound(Model subNodeMapModel, String instanceURI, String termLabel) {
		RDFNode typeObject = subNodeMapModel.createResource( instanceURI );
		Statement parentStatement = mapStatement.changeObject( typeObject );
		Property termNotFoundProperty = subNodeMapModel.createProperty( DataToolsOntConstants.TERM_NOT_FOUND_URI );
		Statement unFoundTermStatement = subNodeMapModel.createStatement( mapStatement.getSubject(), termNotFoundProperty, termLabel );
		return new Statement[] { parentStatement, unFoundTermStatement };
	}

	private Statement[] getNewInstanceWithParentType(int row, final Model subMapModel) {
		try {
			MapInterpreter subNodeMapEvaluator = new MapInterpreter( mapModel, subMapModel, tabData, ontologyExpression, mapStatement, anntModel );
			Statement[] statementAry = subNodeMapEvaluator.interpret( row );
			Resource subject = RdfMakerUtil.getNewResourcesFromRepository( subMapModel, rdftorepo );

			List<Statement> statementList = RdfMakerUtil.replaceExpressionWithURI( statementAry, subject, ontologyExpression );
			Statement statementOfMainInstance = subMapModel.createStatement( mapStatement.getSubject(), mapStatement.getPredicate(), subject );
			statementList.add( statementOfMainInstance );
			return statementList.toArray( new Statement[statementList.size()] );

		} catch (IOException e) {
			logger.error( "exception in the method getNewInstanceWithParentType of org.eaglei.datatools.etl.server.OntologyExpression class" );
			throw new RuntimeException( e );
		}
	}

	private String checkOntology(String label, String URI) throws Exception {
		String result = null;
		if ( label != null ) {
			result = anntModel.findSubclassByLabel( URI, label.replace( "  ", " " ).trim() );

		}
		if ( result == null ) {
			return URI;
		}
		return result;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eaglei.datatools.etl.server.Expression#getExpressionString()
	 */
	@Override
	public String getExpressionString() {
		// TODO Auto-generated method stub
		return ontologyExpression;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eaglei.datatools.etl.server.Expression#getExpressionStatement()
	 */
	@Override
	public Statement getExpressionStatement() {
		// TODO Auto-generated method stub
		return mapStatement;
	}

}