package org.eaglei.datatools.etl.server;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;
import org.eaglei.datatools.etl.server.ExcelAbstractions.ExcelTabData;
import org.eaglei.datatools.etl.utils.Rdf123Expression;
import org.eaglei.datatools.model.AnnotationFormModel;
import org.eaglei.datatools.model.DataToolsOntConstants;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.RDFS;

class ResourceExpression extends Expression<Statement[]> {

	public static final String RESOURCE_EXPRESSION_MATCHER = "Ex:e+$";
	private String subectExpression;
	private ExcelTabData tabData;
	private Statement mapStatement;
	private Model mapModel;
	private RDFtoRepoService rdftorepo;
	private Rdf123Expression rdf123Exp;
	private AnnotationFormModel anntModel;
	private static org.apache.log4j.Logger logger = Logger.getLogger( ResourceExpression.class );

	public ResourceExpression(String subectExpression, Rdf123Expression rdf123Exp, ExcelTabData tabData, Statement mapStatement, Model mapModel, AnnotationFormModel anntModel) {
		this.subectExpression = subectExpression;
		this.tabData = tabData;
		this.mapStatement = mapStatement;
		this.mapModel = mapModel;
		this.rdftorepo = RdfMaker.getRdftorepo();
		this.rdf123Exp = rdf123Exp;
		this.anntModel = anntModel;

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eaglei.datatools.etl.server.CSVToRDFGraph.AbstractExpression# Interpret (org.eaglei.datatools.etl.server.ExcelAbstractions.ExcelTabData, int, com.clarkparsia.pellint.rdfxml.RDFModel)
	 */
	@Override
	public Statement[] interpret(int row) {

		if ( subectExpression.equals( MapInterpreter.PRIMARY_INSTANCE_EXPRESSION_MATCHER ) ) {
			return new Statement[] { mapStatement };
		}

		/*
		 * SPECIAL CASE:In Excel files ,dc creator's last name comes first where as in repository the dc creators are created with last name in last , so we need to replace the dc creators string found in excel file by the string in repository and
		 * then query the repository for DC creator URI
		 * 
		 * checkForDcCreatorAndWrap(row,Model) checks if the statement is DC creator statement and then makes new Model replacing the dc creator string as described above.If the statement is not dc creator statement then it just returns the model as
		 * it is
		 */
		Model subNodeMapModel = checkForDcCreatorAndWrap( row, RdfMakerUtil.getsubModelByExpression( subectExpression, mapModel ) );

		/* if there is semicolon on excel data then process that. */
		SemiColonExpresson semiColonExpression = new SemiColonExpresson( subNodeMapModel, rdf123Exp );
		Model[] modelAfterSemiColonInterpretation = semiColonExpression.interpret( row );
		ArrayList<Statement> statementList = new ArrayList<Statement>();

		/*
		 * if there is really a semicolon then above semiColonExpression returns the Model array ,each Model is for each string separated by semicolon
		 */
		for (Model model : modelAfterSemiColonInterpretation) {
			Statement[] statementAry = interpretResourceExpressionAfterSemicolon( row, model );
			if ( statementAry == null ) {
				continue;
			}
			/*
			 * add the returned statement array to statement list which will be returned
			 */
			statementList.addAll( Arrays.asList( statementAry ) );
		}
		return statementList.toArray( new Statement[statementList.size()] );

	}

	private Model checkForDcCreatorAndWrap(int row, Model dcModel) {
		try {
			if ( mapStatement.getPredicate().getURI().equalsIgnoreCase( DataToolsOntConstants.CREATOR ) ) {

				Map<String, String> dcCreatorMap = RowConfiguration.getdcCreatorFromRepoFile( ETLEntryPoint.getRepoConfigFile() );
				String result;
				result = RdfMakerUtil.evaluateExpression( rdf123Exp, row, subectExpression.split( "\\+" )[1] );
				result = wrapUsersofdcCreator( result, dcCreatorMap );
				StmtIterator stmtIter = dcModel.listStatements();
				Statement labelStatement = null;
				while ( stmtIter.hasNext() ) {
					Statement statement = stmtIter.next();
					if ( statement.getPredicate().equals( RDFS.label ) ) {
						labelStatement = statement;

					}
				}
				if ( labelStatement != null ) {
					dcModel.remove( labelStatement );
					Statement newStatement = labelStatement.changeObject( result );
					dcModel.add( newStatement );
				}

			}
			return dcModel;
			// FIXME: temporarly throwing Runtime exception until we find better solution on how to handle exceptions
		} catch (Exception e) {
			logger.error( "Exception Exception Occured in interpret method of ResourceExpression class while reading DcCreator for config file" );
			throw new RuntimeException( e );
		}
	}

	private Statement[] interpretResourceExpressionAfterSemicolon(int row, Model subNodeMapModel) {
		try {
			MapInterpreter subNodeMapEvaluator = new MapInterpreter( mapModel, subNodeMapModel, tabData, subectExpression.toString(), mapStatement, anntModel );
			Statement[] statementAry = subNodeMapEvaluator.interpret( row );

			if ( statementAry.length <= 1 || !RdfMakerUtil.isLabelPresentInMap( statementAry ) ) {
				return null;
			}
			/* make Model with the returned Statement Array */
			Model tempModel = ModelFactory.createDefaultModel();
			tempModel.add( statementAry );

			/* make query from the Model we just prepared above to see if this instance is already exists in Repository or not */
			String query = "";
			/* FIXME:Termporary hack if its person instance query with only type and label */
			if ( RdfMakerUtil.getTypeOfModel( tempModel ).contains( "person" ) || RdfMakerUtil.getTypeOfModel( tempModel ).contains( "Person" ) ) {
				query = ETLSPARQLQueryUtil.getEIResourcesByOnlyTypeANDRdfsLabel( tempModel );
			} else {
				query = ETLSPARQLQueryUtil.getEIResourcesByAllPropertiesQuery( rdftorepo.getRepositoryProvider(), tempModel, rdftorepo.getSession() );
			}

			logger.debug( "the query for Resource in Resource Expression class " + query );
			String instance = rdftorepo.getRepositoryProvider().query( rdftorepo.getSession(), query.replace( "\n", " " ).replace( "\r", " " ) );
			String[] instanceURI = ETLSPARQLQueryUtil.getInstanceURI( instance );

			Resource subject = RdfMakerUtil.getNewResourcesFromRepository( tempModel, rdftorepo );

			/* if there are no Instances returned from repository then make new instance otherwise add the returned instances URI to statement */
			if ( instanceURI.length == 0 ) {
				/* replace Secondary instance Expression with new instance URI */
				List<Statement> statementList = RdfMakerUtil.replaceExpressionWithURI( statementAry, subject, subectExpression );
				Statement statementOfMainInstance = tempModel.createStatement( mapStatement.getSubject(), mapStatement.getPredicate(), subject );
				statementList.add( statementOfMainInstance );
				return statementList.toArray( new Statement[statementList.size()] );
			} else {
				RDFNode typeObject = tempModel.createResource( instanceURI[0] );
				Statement stmtToReturn = tempModel.createStatement( mapStatement.getSubject(), mapStatement.getPredicate(), typeObject );
				return new Statement[] { stmtToReturn };
			}

			// FIXME: temporarly throwing Runtime exception until we find better solution on how to handle exceptions
		} catch (IOException ioe) {
			logger.error( "IO Exception Occured in interpret method of ResourceExpression class while interpreting " + mapStatement.getObject() );
			throw new RuntimeException( ioe );
		} catch (ArrayIndexOutOfBoundsException aie) {
			logger.error( "ArrayIndexOutOfBounds Exception  Occured in interpret method of ResourceExpressio's interpret method " + mapStatement.getObject() );
			System.exit( 2 );
			throw new RuntimeException( aie );

		} catch (Exception e) {
			logger.error( " Exception Occured in interpret method of ResourceExpression class" + mapStatement.getObject() );
			throw new RuntimeException( e );
		}
	}

	private String wrapUsersofdcCreator(String result, Map<String, String> dcCreatorMap) throws ConfigurationException {
		if ( dcCreatorMap.get( result.replace( " ", "" ) ) != null ) {

			return dcCreatorMap.get( result.replace( " ", "" ) );
		} else {
			return result;
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eaglei.datatools.etl.server.Expression#getExpressionString()
	 */
	@Override
	public String getExpressionString() {
		// TODO Auto-generated method stub
		return subectExpression;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eaglei.datatools.etl.server.Expression#getExpressionStatement()
	 */
	@Override
	public Statement getExpressionStatement() {
		// TODO Auto-generated method stub
		return mapStatement;
	}

}