package org.eaglei.datatools.etl.server;

/**
 * @author Sravan Kumar Cheriyala
 * 
 * This class hace methods for read from properties file
 */
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;

public class RowConfiguration {
	/**
	 * Reads the content of rowInfo.prperties file
	 * 
	 * @param mapPath
	 * @param tab
	 * @return
	 * @throws ConfigurationException
	 */
	public static Map<String, String> getFormatingInfoOfRow(String mapPath, String tab) throws ConfigurationException {
		Map<String, String> rowInfoMap = new HashMap<String, String>();
		PropertiesConfiguration config = new PropertiesConfiguration(mapPath + "/rowinfo.properties");
		Integer startrow = config.getInteger(tab.toLowerCase() + ".startrow", 1);
		rowInfoMap.put("startrow", startrow + "");
		Integer rowheadStart = config.getInteger(tab + ".rowheadstart", 1);
		rowInfoMap.put("rowheadstart", rowheadStart + "");
		String order = config.getString("process.order");
		rowInfoMap.put("order", order);
		String globalColumns = config.getString("globalcolumnsorderintoCSV");
		if (globalColumns != null) {
			rowInfoMap.put("globalcolumnsorderintoCSV", globalColumns);
		}
		String globalColumnsOrder = config.getString("globalcolumnsorderinexcel");
		if (globalColumnsOrder != null) {
			rowInfoMap.put("globalcolumnsorderinexcel", globalColumnsOrder);
		}
		return rowInfoMap;
	}
	
	
	public static Map<String,String> getFormatingInfoOfFile(String mapPath) throws ConfigurationException
	{
		Map<String, String> rowInfoMap = new HashMap<String, String>();
		PropertiesConfiguration config = new PropertiesConfiguration(mapPath + "/rowinfo.properties");
		
		String order = config.getString("process.order");
		rowInfoMap.put("order", order);
		String globalColumns = config.getString("globalcolumnsorderintoCSV");
		if (globalColumns != null) {
			rowInfoMap.put("globalcolumnsorderintoCSV", globalColumns);
		}
		String globalColumnsOrder = config.getString("globalcolumnsorderinexcel");
		if (globalColumnsOrder != null) {
			rowInfoMap.put("globalcolumnsorderinexcel", globalColumnsOrder);
		}
		return rowInfoMap;
	}
	
	/**
	 * Reads the username and password for the repository properties file
	 * 
	 * @param repoPath
	 * @return
	 * @throws ConfigurationException
	 */
	public static Map<String, String> getCredentialsForRepo(String repoPath) throws ConfigurationException {
		Map<String, String> rowInfoMap = new HashMap<String, String>();
		PropertiesConfiguration config = new PropertiesConfiguration(repoPath);
		String user = config.getString("datatools.repository.user");
		String password = config.getString("datatools.repository.password");
		rowInfoMap.put("user", user);
		rowInfoMap.put("password", password);
		return rowInfoMap;
	}
	/**
	 * Reads the username and password for the repository properties file
	 * 
	 * @param repoPath
	 * @return
	 * @throws ConfigurationException
	 */
	public static Map<String, String> getMapInfo(String mapPath) throws ConfigurationException {
		Map<String, String> rowInfoMap = new HashMap<String, String>();
		PropertiesConfiguration config = new PropertiesConfiguration(mapPath);
		Iterator<String> iter = config.getKeys();
		while (iter.hasNext()) {
			String key = iter.next();
			rowInfoMap.put(key, config.getString(key));
		}
		return rowInfoMap;
	}
	public static Map<String, String> getdcCreatorFromRepoFile(String repoPath) throws ConfigurationException {
		Map<String, String> dcCreatorMap = new HashMap<String, String>();
		PropertiesConfiguration config = new PropertiesConfiguration(repoPath);
		config.setDelimiterParsingDisabled(true);
		String[] dccreatorAry = config.getStringArray("datatools.repository.dccreator");
		for (String dccreator : dccreatorAry) {
			String[] splitAry = dccreator.split("#");
			dcCreatorMap.put(splitAry[0].replace(";", ","), splitAry[1]);
		}
		return dcCreatorMap;
	}
}
