package org.eaglei.datatools.etl.server;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import org.apache.log4j.Logger;
import org.eaglei.datatools.etl.server.ExcelAbstractions.ExcelTabData;
import org.eaglei.datatools.etl.utils.Rdf123Expression;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;

class SemiColonExpresson extends Expression<Model[]> {

	public static final String SEMICOLON_MATCHER = ";";
	private Model mapModel;
	private static org.apache.log4j.Logger logger = Logger.getLogger( SemiColonExpresson.class );
	private Rdf123Expression rdf123Exp = null;
	private RDFtoRepoService rdftorepo;

	public SemiColonExpresson(Model mapModel,Rdf123Expression rdf123Exp ) {
		this.mapModel = mapModel;
		rdftorepo = RdfMaker.getRdftorepo();
		/* gets the base namespace from properties file */
		String base = rdftorepo.getDatatoolsConfiguration().getDatatoolsRepositoryNamespace();
		this.rdf123Exp =rdf123Exp; 

	}

	/*
	 * * (non-Javadoc)
	 * 
	 * @see org.eaglei.datatools.etl.server.CSVToRDFGraph.AbstractExpression# Interpret (org.eaglei.datatools.etl.server.ExcelAbstractions.ExcelTabData, int, com.clarkparsia.pellint.rdfxml.RDFModel)
	 */

	@Override
	public Model[] interpret(int row) {
		try {

			Map<String, String[]> objectLiteralMap = new HashMap<String, String[]>();
			int largestArraySize = 0;
			Model[] modelAryToReturn = null;
			StmtIterator stmtIterator = mapModel.listStatements();
			while ( stmtIterator.hasNext() ) {
				Statement stmtMap = stmtIterator.nextStatement();
				Property predicate = stmtMap.getPredicate();
				RDFNode rdfNode = stmtMap.getObject();

				if ( !rdfNode.isResource() ) {
					Literal objectLiteral = (Literal)rdfNode;
					if ( objectLiteral.toString().contains( "$" ) ) {
						String result = RdfMakerUtil.evaluateExpression( rdf123Exp, row, objectLiteral.toString() );
						if ( result != null ) {
							String[] stringSplitAry = result.split( ";" );
							if ( stringSplitAry.length > 1 ) {
								objectLiteralMap.put( predicate.toString(), stringSplitAry );
							}
							if ( stringSplitAry.length > largestArraySize ) {
								largestArraySize = stringSplitAry.length;
							}
						}

					}
				}
				

			}

			if ( largestArraySize > 0 ) {
				modelAryToReturn = new Model[largestArraySize];
				for (int i = 0; i <= largestArraySize - 1; i++) {
					Model model = ModelFactory.createDefaultModel();
					StmtIterator iter = mapModel.listStatements();
					while ( iter.hasNext() ) {
						Statement stmtMap = iter.nextStatement();
						Resource subject = stmtMap.getSubject();
						Property predicate = stmtMap.getPredicate();

						if ( objectLiteralMap.containsKey( predicate.toString() ) ) {
							model.add( subject, predicate, objectLiteralMap.get( predicate.toString() )[i] );
						} else {
							model.add( stmtMap );
						}

					}
					modelAryToReturn[i] = model;
				}
				return modelAryToReturn;
			} else {
				return new Model[] { mapModel };
			}

			// FIXME: temporarly throwing Runtime exception until we find better solution on how to handle exceptions
		} catch (Exception e) {
			logger.error( " Exception Occured in interpret method of SemiColonExpresson class" );
			e.printStackTrace();
			throw new RuntimeException( e );
		}

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eaglei.datatools.etl.server.Expression#getExpressionString()
	 */
	@Override
	public String getExpressionString() {
		// TODO Auto-generated method stub
		return ";";
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eaglei.datatools.etl.server.Expression#getExpressionStatement()
	 */
	@Override
	public Statement getExpressionStatement() {
		// TODO Auto-generated method stub
		return null;
	}

}