/**
 * 
 */
package org.eaglei.datatools.etl.utils;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;

import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;
import org.eaglei.datatools.User;
import org.eaglei.datatools.etl.server.ETLSPARQLQueryUtil;

import org.eaglei.datatools.etl.server.RowConfiguration;
import org.eaglei.datatools.etl.server.RDFtoRepoService;
import org.eaglei.datatools.jena.SPARQLQueryUtil;
import org.eaglei.datatools.provider.RepositoryProvider;
import org.eaglei.model.EIURI;
import org.eaglei.security.Session;

/**
 * This class is for deleting instances which ETled from particular file, -f takes filename as input ,this is the file name which we want to delete all instances ETLed from .-r takes repository configuration file path
 * 
 * FLOW : deleteInsntaceETledFromFIle(String) takes file name as input ,it then calls getResourcesOfFile(String) where it builds query to ge the Instance URI's we want to delete,It builds the query by calling
 * SPARQLQueryUtil.getInstance().getResourcesETLedFromFileQuery(fileName); .We query repository using the query which we built it then returns results in xml format ,xml is parsed for Instance URIs in ETLSPARQLQueryUtil.getInstanceURI(resources)
 * method ,which returns array if instance URI's . instanceURI array is then passed to deleteInsntaceETledFromFIle(String) where it will be deleted one by one by looping throught he array
 * 
 * @author Sravan Kumar Cheriyala
 * 
 */
public class DeETL {

	private static org.apache.log4j.Logger logger = Logger.getLogger( DeETL.class );
	private static String fileName;
	private static String repo;
	private static RDFtoRepoService rdftorepo;
	private RepositoryProvider provider;
	private Session session;

	public static void main(String args[]) throws Exception {

		for (int i = 0; i < args.length - 1; i++) {
			if ( args[i].equals( "-f" ) ) {
				i = i + 1;
				fileName = args[i];
			} else if ( args[i].equals( "-r" ) ) {
				i = i + 1;
				repo = args[i];
			}

		}

		DeETL deetl = new DeETL();
		deetl.deleteInstanceETLedFromFile( fileName );
		logger.info( "delete complete" );

	}

	/**
	 * Constructor where we get the ReposiotryProvider object and also gets session by loging into reposiotry
	 * 
	 * @throws ConfigurationException
	 * @throws IOException
	 */
	public DeETL() throws ConfigurationException, IOException {
		try {
			rdftorepo = RDFtoRepoService.getInstance( repo, null );
		} catch (FileNotFoundException fe) {
			logger.error( "Repository information file not found" );
			logger.error( fe );
			throw fe;
		}
		provider = rdftorepo.getRepositoryProvider();
		Map<String, String> credentialMap = RowConfiguration.getCredentialsForRepo( repo );
		try {
			/* login and get the session */
			User strAry = provider.login( credentialMap.get( "user" ), credentialMap.get( "password" ) );
			if ( strAry == null ) {
				logger.error( "Could not authenticate please check username,password and Repository URL...Exiting System" );
				System.exit( 2 );
			}
			setSession( strAry.getSession() );
		} catch (Exception e) {
			logger.error( "Exception thrown in constructor" );
			logger.error( e );
			throw new RuntimeException( e );
		}

	}

	/**
	 * Delete the instances which are ETLed from fileName
	 * */
	public int deleteInstanceETLedFromFile(String fileName) throws Exception {
		/* fetch the resources ETLed from file */
		String[] instanceURIAry = getResourcesOfFile( fileName );
		int i = 0;
		for (String instaceURI : instanceURIAry) {
			try {
				/* delete instances one by one */
				logger.info( "deleting " + instaceURI );
				provider.deleteInstance( session, EIURI.create( instaceURI ) );
				i++;
				if(i%50==0)
				{
					System.gc();	
				}
			} catch (Exception e) {
				logger.error( "There is Error in deleting this resource" + instaceURI );
				continue;
			}

		}
		if ( i == 0 ) {
			logger.info( "There are no resources with this file to delete" );
		}
		return i;

	}

	/**
	 * gets the resources Array by making query and queriying it against repository
	 * 
	 * @param fileName
	 * @return
	 */
	public String[] getResourcesOfFile(String fileName) {
		try {
			logger.info( "making delete query for filename" + fileName );
			/* get the query which gives the resources of particular file */
			String query = SPARQLQueryUtil.getInstance().getResourcesETLedFromFileQuery( fileName );
			logger.info( "querying the repository for resources ETLed from " + fileName );
			/* query repository */
			String resources = provider.query( session, query );
			/*
			 * repository returns the xml of resources,parse that xml and make array of resources
			 */
			String[] instanceURIAry = ETLSPARQLQueryUtil.getInstanceURI( resources );
			logger.info( "Query returned " + instanceURIAry.length + " resources" );
			return instanceURIAry;
		} catch (Exception e) {
			logger.error( "exception thrown in getResourcesOfFile()" );
			logger.error( e );
			throw new RuntimeException( e );
		}

	}

	public Session getSession() {
		return session;
	}

	private void setSession(Session session) {
		this.session = session;
	}

	public static String getRepo() {
		return repo;
	}

	public static void setRepo(String repo) {
		DeETL.repo = repo;
	}

	public static String getFileName() {
		return fileName;
	}

	public static RDFtoRepoService getRdftorepo() {
		return rdftorepo;
	}

}
