/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.etl.server;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;
import org.eaglei.datatools.etl.server.ETLEntryPoint;
import org.eaglei.datatools.etl.server.ETLSPARQLQueryUtil;
import org.eaglei.datatools.etl.server.ExcelAbstractions;
import org.eaglei.datatools.etl.server.Expression;
import org.eaglei.datatools.etl.server.MapInterpreter;
import org.eaglei.datatools.etl.server.RDFtoRepoService;
import org.eaglei.datatools.etl.server.RdfMaker;
import org.eaglei.datatools.etl.server.RdfMakerUtil;
import org.eaglei.datatools.etl.server.RowConfiguration;
import org.eaglei.datatools.etl.server.SemiColonExpresson;
import org.eaglei.datatools.etl.utils.Rdf123Expression;
import org.eaglei.datatools.model.AnnotationFormModel;

class ResourceExpression
extends Expression<Statement[]> {
    public static final String RESOURCE_EXPRESSION_MATCHER = "Ex:e+$";
    private String subectExpression;
    private ExcelAbstractions.ExcelTabData tabData;
    private Statement mapStatement;
    private Model mapModel;
    private RDFtoRepoService rdftorepo;
    private Rdf123Expression rdf123Exp;
    private AnnotationFormModel anntModel;
    private static Logger logger = Logger.getLogger(ResourceExpression.class);

    public ResourceExpression(String subectExpression, Rdf123Expression rdf123Exp, ExcelAbstractions.ExcelTabData tabData, Statement mapStatement, Model mapModel, AnnotationFormModel anntModel) {
        this.subectExpression = subectExpression;
        this.tabData = tabData;
        this.mapStatement = mapStatement;
        this.mapModel = mapModel;
        this.rdftorepo = RdfMaker.getRdftorepo();
        this.rdf123Exp = rdf123Exp;
        this.anntModel = anntModel;
    }

    @Override
    public Statement[] interpret(int row) {
        if (this.subectExpression.equals("Ex:e+$0")) {
            return new Statement[]{this.mapStatement};
        }
        Model subNodeMapModel = this.checkForDcCreatorAndWrap(row, RdfMakerUtil.getsubModelByExpression(this.subectExpression, this.mapModel));
        SemiColonExpresson semiColonExpression = new SemiColonExpresson(subNodeMapModel, this.rdf123Exp);
        Model[] modelAfterSemiColonInterpretation = semiColonExpression.interpret(row);
        ArrayList<Statement> statementList = new ArrayList<Statement>();
        for (Model model : modelAfterSemiColonInterpretation) {
            Statement[] statementAry = this.interpretResourceExpressionAfterSemicolon(row, model);
            if (statementAry == null) continue;
            statementList.addAll(Arrays.asList(statementAry));
        }
        return statementList.toArray(new Statement[statementList.size()]);
    }

    private Model checkForDcCreatorAndWrap(int row, Model dcModel) {
        try {
            if (this.mapStatement.getPredicate().getURI().equalsIgnoreCase("http://purl.org/dc/terms/creator")) {
                Map<String, String> dcCreatorMap = RowConfiguration.getdcCreatorFromRepoFile(ETLEntryPoint.getRepoConfigFile());
                String result = RdfMakerUtil.evaluateExpression(this.rdf123Exp, row, this.subectExpression.split("\\+")[1]);
                result = this.wrapUsersofdcCreator(result, dcCreatorMap);
                StmtIterator stmtIter = dcModel.listStatements();
                Statement labelStatement = null;
                while (stmtIter.hasNext()) {
                    Statement statement = (Statement)stmtIter.next();
                    if (!statement.getPredicate().equals(RDFS.label)) continue;
                    labelStatement = statement;
                }
                if (labelStatement != null) {
                    dcModel.remove(labelStatement);
                    Statement newStatement = labelStatement.changeObject(result);
                    dcModel.add(newStatement);
                }
            }
            return dcModel;
        }
        catch (Exception e) {
            logger.error((Object)"Exception Exception Occured in interpret method of ResourceExpression class while reading DcCreator for config file");
            throw new RuntimeException(e);
        }
    }

    private Statement[] interpretResourceExpressionAfterSemicolon(int row, Model subNodeMapModel) {
        try {
            MapInterpreter subNodeMapEvaluator = new MapInterpreter(this.mapModel, subNodeMapModel, this.tabData, this.subectExpression.toString(), this.mapStatement, this.anntModel);
            Statement[] statementAry = subNodeMapEvaluator.interpret(row);
            if (statementAry.length <= 1 || !RdfMakerUtil.isLabelPresentInMap(statementAry)) {
                return null;
            }
            Model tempModel = ModelFactory.createDefaultModel();
            tempModel.add(statementAry);
            String query = "";
            query = RdfMakerUtil.getTypeOfModel(tempModel).contains("person") || RdfMakerUtil.getTypeOfModel(tempModel).contains("Person") ? ETLSPARQLQueryUtil.getEIResourcesByOnlyTypeANDRdfsLabel(tempModel) : ETLSPARQLQueryUtil.getEIResourcesByAllPropertiesQuery(this.rdftorepo.getRepositoryProvider(), tempModel, this.rdftorepo.getSession());
            logger.debug((Object)("the query for Resource in Resource Expression class " + query));
            String instance = this.rdftorepo.getRepositoryProvider().query(this.rdftorepo.getSession(), query.replace("\n", " ").replace("\r", " "));
            String[] instanceURI = ETLSPARQLQueryUtil.getInstanceURI(instance);
            Resource subject = RdfMakerUtil.getNewResourcesFromRepository(tempModel, this.rdftorepo);
            if (instanceURI.length == 0) {
                List<Statement> statementList = RdfMakerUtil.replaceExpressionWithURI(statementAry, subject, this.subectExpression);
                Statement statementOfMainInstance = tempModel.createStatement(this.mapStatement.getSubject(), this.mapStatement.getPredicate(), (RDFNode)subject);
                statementList.add(statementOfMainInstance);
                return statementList.toArray(new Statement[statementList.size()]);
            }
            Resource typeObject = tempModel.createResource(instanceURI[0]);
            Statement stmtToReturn = tempModel.createStatement(this.mapStatement.getSubject(), this.mapStatement.getPredicate(), (RDFNode)typeObject);
            return new Statement[]{stmtToReturn};
        }
        catch (IOException ioe) {
            logger.error((Object)("IO Exception Occured in interpret method of ResourceExpression class while interpreting " + this.mapStatement.getObject()));
            throw new RuntimeException(ioe);
        }
        catch (ArrayIndexOutOfBoundsException aie) {
            logger.error((Object)("ArrayIndexOutOfBounds Exception  Occured in interpret method of ResourceExpressio's interpret method " + this.mapStatement.getObject()));
            System.exit(2);
            throw new RuntimeException(aie);
        }
        catch (Exception e) {
            logger.error((Object)(" Exception Occured in interpret method of ResourceExpression class" + this.mapStatement.getObject()));
            throw new RuntimeException(e);
        }
    }

    private String wrapUsersofdcCreator(String result, Map<String, String> dcCreatorMap) throws ConfigurationException {
        if (dcCreatorMap.get(result.replace(" ", "")) != null) {
            return dcCreatorMap.get(result.replace(" ", ""));
        }
        return result;
    }

    @Override
    public String getExpressionString() {
        return this.subectExpression;
    }

    @Override
    public Statement getExpressionStatement() {
        return this.mapStatement;
    }
}

