/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.etl.utils;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;
import org.eaglei.datatools.User;
import org.eaglei.datatools.etl.server.ETLSPARQLQueryUtil;
import org.eaglei.datatools.etl.server.RDFtoRepoService;
import org.eaglei.datatools.etl.server.RowConfiguration;
import org.eaglei.datatools.jena.SPARQLQueryUtil;
import org.eaglei.datatools.provider.RepositoryProvider;
import org.eaglei.model.EIURI;
import org.eaglei.security.Session;

public class DeETL {
    private static Logger logger = Logger.getLogger(DeETL.class);
    private static String fileName;
    private static String repo;
    private static RDFtoRepoService rdftorepo;
    private RepositoryProvider provider;
    private Session session;

    public static void main(String[] args) throws Exception {
        for (int i = 0; i < args.length - 1; ++i) {
            if (args[i].equals("-f")) {
                fileName = args[++i];
                continue;
            }
            if (!args[i].equals("-r")) continue;
            repo = args[++i];
        }
        DeETL deetl = new DeETL();
        deetl.deleteInstanceETLedFromFile(fileName);
        logger.info((Object)"delete complete");
    }

    public DeETL() throws ConfigurationException, IOException {
        try {
            rdftorepo = RDFtoRepoService.getInstance(repo, null);
        }
        catch (FileNotFoundException fe) {
            logger.error((Object)"Repository information file not found");
            logger.error((Object)fe);
            throw fe;
        }
        this.provider = rdftorepo.getRepositoryProvider();
        Map<String, String> credentialMap = RowConfiguration.getCredentialsForRepo(repo);
        try {
            User strAry = this.provider.login(credentialMap.get("user"), credentialMap.get("password"));
            if (strAry == null) {
                logger.error((Object)"Could not authenticate please check username,password and Repository URL...Exiting System");
                System.exit(2);
            }
            this.setSession(strAry.getSession());
        }
        catch (Exception e) {
            logger.error((Object)"Exception thrown in constructor");
            logger.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    public int deleteInstanceETLedFromFile(String fileName) throws Exception {
        String[] instanceURIAry = this.getResourcesOfFile(fileName);
        int i = 0;
        for (String instaceURI : instanceURIAry) {
            try {
                logger.info((Object)("deleting " + instaceURI));
                this.provider.deleteInstance(this.session, EIURI.create((String)instaceURI));
                if (++i % 50 != 0) continue;
                System.gc();
            }
            catch (Exception e) {
                logger.error((Object)("There is Error in deleting this resource" + instaceURI));
            }
        }
        if (i == 0) {
            logger.info((Object)"There are no resources with this file to delete");
        }
        return i;
    }

    public String[] getResourcesOfFile(String fileName) {
        try {
            logger.info((Object)("making delete query for filename" + fileName));
            String query = SPARQLQueryUtil.getInstance().getResourcesETLedFromFileQuery(fileName);
            logger.info((Object)("querying the repository for resources ETLed from " + fileName));
            String resources = this.provider.query(this.session, query);
            String[] instanceURIAry = ETLSPARQLQueryUtil.getInstanceURI(resources);
            logger.info((Object)("Query returned " + instanceURIAry.length + " resources"));
            return instanceURIAry;
        }
        catch (Exception e) {
            logger.error((Object)"exception thrown in getResourcesOfFile()");
            logger.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    public Session getSession() {
        return this.session;
    }

    private void setSession(Session session) {
        this.session = session;
    }

    public static String getRepo() {
        return repo;
    }

    public static void setRepo(String repo) {
        DeETL.repo = repo;
    }

    public static String getFileName() {
        return fileName;
    }

    public static RDFtoRepoService getRdftorepo() {
        return rdftorepo;
    }
}

