/**
 * 
 */
package org.eaglei.datatools.etl.server;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;

/**
 * @author Sravan Cheriyala
 *
 */
public class ETLRepositoryConfiguration {

	
	/**
	 * get the dccreators from repository config file
	 * @param repoPath
	 * @return
	 * @throws ConfigurationException
	 */
	public static Map<String, String> getdcCreatorFromRepoFile(String repoPath) throws ConfigurationException {
		Map<String, String> dcCreatorMap = new HashMap<String, String>();
		PropertiesConfiguration config = new PropertiesConfiguration( repoPath );
		config.setDelimiterParsingDisabled( true );
		String[] dccreatorAry = config.getStringArray( "datatools.repository.dccreator" );
		for (String dccreator : dccreatorAry) {
			String[] splitAry = dccreator.split( "#" );
			dcCreatorMap.put( splitAry[0].replace( ";", "," ), splitAry[1] );
		}
		return dcCreatorMap;
	}
	
	/**
	 * Reads the username and password for the repository config file
	 * 
	 * @param repoPath
	 * @return
	 * @throws ConfigurationException
	 */
	public static Map<String, String> getCredentialsForRepo(String repoPath) throws ConfigurationException {
		Map<String, String> rowInfoMap = new HashMap<String, String>();
		PropertiesConfiguration config = new PropertiesConfiguration( repoPath );
		String user = config.getString( "datatools.repository.user" );
		String password = config.getString( "datatools.repository.password" );
		rowInfoMap.put( "user", user );
		rowInfoMap.put( "password", password );
		return rowInfoMap;
	}
}
