package org.eaglei.datatools.etl.server.extractor;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.configuration.ConfigurationException;
import org.eaglei.datatools.etl.server.exceptions.ExtractorException;
import org.eaglei.datatools.etl.server.extractor.parsers.Data;

/**
 * 
 * @author Sravan Cheriyala
 *
 * @param <I>
 * @param <ROW>
 */
public abstract class Extractor {

	public abstract String getFormVersion() throws ParseException,IOException;
	
	public abstract Map<String,Data> getData(File mapDirectory) throws ConfigurationException, IOException, ParseException,ExtractorException ;
	
	public Map<String, File> getMapFiles(File mapDirectory) throws FileNotFoundException {
		final Map<String, File> mapIns = new HashMap<String, File>();

		final String[] lstMapFiles = mapDirectory.list();

		for (final String mapFileName : lstMapFiles) {
			if ( mapFileName.contains( ".svn" ) ) {
				continue;
			}
			/*
			 * make a map of inputstream of all map files with the filename of mapfile as key NOTE: here filename of map file should be same as tab name in excel file
			 */
			File mapFile = new File( mapDirectory.getPath() +"/"+ mapFileName );
			mapIns.put( mapFileName.replace( ".rdf", "" ).toUpperCase(), mapFile );
		}

		return mapIns;
	}
	
	public File getMapDirectory(String formVersion, File mapsParentDirectory) {
		return new File( mapsParentDirectory.getPath() +"/"+ formVersion );
	}

}
