/**
 * 
 */
package org.eaglei.datatools.etl.server.loader;

import java.io.IOException;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;
import org.eaglei.datatools.etl.server.LoggerFactory;
import org.eaglei.datatools.etl.server.RepoService;
import org.eaglei.datatools.etl.server.exceptions.LoaderException;
import org.eaglei.datatools.etl.server.transformer.MapInterpreterTracker;
import org.eaglei.datatools.model.AnnotationFormModel;
import org.eaglei.datatools.model.DataToolsOntConstants;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;
import org.eaglei.model.jena.JenaEIInstanceFactory;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;

/**
 * @author Sravan Cheriyala
 * 
 */
public class LoaderImpl extends Loader {

	private static org.apache.log4j.Logger logger = Logger.getLogger( LoaderImpl.class );
	private Validation validation;
	private RepoService repoService;
	private JenaEIInstanceFactory jenaIntanceFactory;
	private AnnotationFormModel anntModel;

	public LoaderImpl(RepoService repoService, JenaEIInstanceFactory jenaIntanceFactory, AnnotationFormModel anntModel) {
		this.repoService = repoService;
		this.jenaIntanceFactory = jenaIntanceFactory;
		this.anntModel = anntModel;
		validation = new Validation( repoService );
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eaglei.datatools.etl.server.loader.Loader#load(com.hp.hpl.jena.rdf.model.Statement[])
	 */
	@Override
	public void load(Statement[] statements, String sourceFile, Promote promoteParameter) throws LoaderException {
		try {
			Model rdfModel = null;
			rdfModel = ModelFactory.createDefaultModel();
			rdfModel.add( statements );
			StringWriter swriter = new StringWriter();
			rdfModel.write( swriter, "RDF/XML" );
			Map<String, List<Resource>> trackerMap = MapInterpreterTracker.getInstance().getMapOfExpressionStringToResourceURI();
			List<Resource> resourceLst = trackerMap.get( "Ex:e+$NEW_INSTANCE" );
			push( repoService,swriter.toString(),resourceLst.get( 0 ).getURI(),promoteParameter);
			List<EIInstance> lstInstance = jenaIntanceFactory.create( rdfModel );
			for (EIInstance instance : lstInstance) {
				EIInstance instanceTopush = jenaIntanceFactory.createExtended( instance.getInstanceURI(), rdfModel );
				if ( validation.isEmbeddedClass( instanceTopush.getInstanceClass(), anntModel.getDatatoolsEIOntModel() ) ) {
					continue;
				}
				addSourcefileProperty( instanceTopush, sourceFile );
				if ( validation.isLab( instanceTopush ) && !validation.isInstanceLableAndTypeAlreadyExsistsInRepository( instanceTopush ) ) {
					push( repoService, instanceTopush, promoteParameter );
				} else if ( !validation.isLab( instanceTopush ) ) {
					push( repoService, instanceTopush, promoteParameter );
				}
			}

			//StringWriter swriter = new StringWriter();
			rdfModel.write( swriter, "RDF/XML" );
			LoggerFactory.outputFileLogger.info( swriter.toString() );
		} catch (IOException ioe) {
			throw new LoaderException( "Exception when getting RepoService instance", ioe );
		} catch (Exception e) {
			throw new LoaderException( e );
		}

	}

	private void push(RepoService repoService, EIInstance instance, Promote promoteParameter) throws LoaderException {
		try {
			repoService.pushToRepo( instance );
			workFlowTansistion( instance.getInstanceURI(), promoteParameter );

		} catch (Exception e) {
			throw new LoaderException( e );
		}

	}
	
	private void push(RepoService repoService, String rdfString,String instanceUri,Promote promoteParameter) throws LoaderException
	{
		try {
			repoService.pushToRepo( rdfString,instanceUri );
		//	workFlowTansistion( instance.getInstanceURI(), promoteParameter );

		} catch (Exception e) {
			throw new LoaderException( e );
		}

	}

	private void addSourcefileProperty(EIInstance instance, String sourceFile) {

		EIEntity property = EIEntity.create( EIURI.create( DataToolsOntConstants.SOURCE_FILE_PREDICATE ), sourceFile );

		instance.addNonOntologyLiteralProperty( property, sourceFile );
	}

}
