/**
 * 
 */
package org.eaglei.datatools.etl.server.transformer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;

import org.eaglei.datatools.etl.server.RepoService;
import org.eaglei.datatools.etl.server.exceptions.TransformException;
import org.eaglei.datatools.model.AnnotationFormModel;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Statement;

/**
 * @author Sravan Cheriyala
 * 
 */
public class TransformerImpl implements Transformer {

	private final AnnotationFormModel annotationFormModel;
	private final RepoService repoService;
	private final Model mapModel;

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eaglei.datatools.etl.server.transformer.Transformer#transformToRDF(java.lang.Object, java.io.File)
	 */

	public TransformerImpl(AnnotationFormModel model, RepoService repoService, File mapFile) throws FileNotFoundException {

		annotationFormModel = model;
		this.repoService = repoService;
		FileInputStream mapStream = new FileInputStream( mapFile );
		Model mapModel = ModelFactory.createDefaultModel();
		mapModel.read( mapStream, SYNTAX );
		mapModel.removeNsPrefix( "" );
		this.mapModel = mapModel;

	}

	@Override
	public Statement[] transformToRDF(Map<String, String> columnMap) throws TransformException {
		try {
			MapInterpreterTracker.getInstance().getMapOfExpressionStringToResourceURI().clear();
			final MapInterpreter mapInterpretor = new MapInterpreter( mapModel, columnMap, annotationFormModel, repoService );
			final Statement[] stmtAry = mapInterpretor.interpret();
			return stmtAry;
		} catch (IOException ioe) {
			throw new TransformException( ioe );
		}

	}

}
