/**
 * 
 */
package org.eaglei.datatools.etl.utils;

import java.util.Arrays;

import org.apache.log4j.Logger;
import org.eaglei.datatools.etl.server.RepoService;
import org.eaglei.datatools.etl.server.loader.Loader.Promote;
import org.eaglei.model.EIURI;

/**
 * @author Sravan Cheriyala
 * 
 */
public class BulkWorkFlow extends BulkOperation {

	private static org.apache.log4j.Logger logger = Logger.getLogger( DeETL.class );
	private static String fileName;
	private static String repo;
	private static Promote promoteParameter;
	public static RepoService rdftorepo;

	public static void main(String args[]) throws Exception {

		for (int i = 0; i < args.length - 1; i++) {
			if ( args[i].equals( "-f" ) ) {
				i = i + 1;
				fileName = args[i];
			} else if ( args[i].equals( "-r" ) ) {
				i = i + 1;
				repo = args[i];
			} else if ( args[i].equals( "-p" ) ) {
				i = i + 1;
				promoteParameter = Promote.getPromote( args[i] );
			}

		}

		BulkWorkFlow bulkworkflow = new BulkWorkFlow( repo );
		bulkworkflow.promote( promoteParameter );

	}

	/**
	 * Constructor where we get the ReposiotryProvider object and also gets session by loging into reposiotry
	 * 
	 * @throws Exception
	 */
	public BulkWorkFlow(String repo) throws Exception {

		super( repo );
	}

	public void promote(Promote promote) {

		String[] instanceURIAry = getResourcesOfFile( fileName );
		int i = 0;
		for (String instanceURI : instanceURIAry) {
			try {

				this.getRdftorepo().getRepositoryProvider().claim( this.getRdftorepo().getSession(), Arrays.asList( EIURI.create( instanceURI ) ) );
				this.getRdftorepo().workFlowTansistion( Arrays.asList( EIURI.create( instanceURI ) ), promote );
				i++;
				if ( i % 50 == 0 ) {
					System.gc();
				}
			} catch (Exception e) {
				logger.error( "There is Error in deleting this resource" + instanceURI );
				continue;
			}

		}
		if ( i == 0 ) {
			logger.info( "There are no resources with this file to delete" );
		}

	}

}
